/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.search;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.builder.ReferenceResolver;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchReporter;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchRequestor;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchScope;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.util.Util;

public final class ApiSearchEngine {
    public static final IReference[] NO_REFERENCES = new IReference[0];
    private static boolean DEBUG = Util.DEBUG;
    private String fRequestorContext = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    private List getResolvedReferences(IApiSearchRequestor requestor, IApiType type, IProgressMonitor monitor) throws CoreException {
        String name = type.getSimpleName();
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format((String)SearchMessages.ApiSearchEngine_extracting_refs_from, (Object[])new String[]{name == null ? SearchMessages.ApiSearchEngine_anonymous_type : name}), (int)2);
        try {
            List refs = type.extractReferences(requestor.getReferenceKinds(), (IProgressMonitor)localmonitor.newChild(1));
            ReferenceResolver.resolveReferences(refs, (IProgressMonitor)localmonitor.newChild(1));
            List list = refs;
            return list;
        }
        finally {
            localmonitor.done();
        }
    }

    private List acceptReferences(IApiSearchRequestor requestor, IApiType type, List references, IProgressMonitor monitor) throws CoreException {
        ArrayList<Reference> refs = new ArrayList<Reference>();
        Reference ref = null;
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)references.size());
        IApiMember member = null;
        try {
            Iterator iter = references.iterator();
            while (iter.hasNext()) {
                if (localmonitor.isCanceled()) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                ref = (Reference)iter.next();
                member = ref.getResolvedReference();
                if (member == null) continue;
                localmonitor.setTaskName(MessageFormat.format((String)SearchMessages.ApiSearchEngine_searching_for_use_from, (Object[])new String[]{this.fRequestorContext, type.getName()}));
                if (requestor.acceptReference(ref)) {
                    refs.add(ref);
                }
                localmonitor.worked(1);
            }
        }
        finally {
            localmonitor.done();
        }
        return refs;
    }

    private void searchReferences(IApiSearchRequestor requestor, IApiElement element, IApiSearchReporter reporter, IProgressMonitor monitor) throws CoreException {
        List refs = null;
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            switch (element.getType()) {
                case 2: {
                    if (localmonitor.isCanceled()) {
                        reporter.reportResults(element, NO_REFERENCES);
                    }
                    IApiType type = (IApiType)element;
                    refs = this.acceptReferences(requestor, type, this.getResolvedReferences(requestor, type, (IProgressMonitor)localmonitor.newChild(1)), (IProgressMonitor)localmonitor.newChild(1));
                    reporter.reportResults(element, refs.toArray(new IReference[refs.size()]));
                    break;
                }
                case 1: {
                    if (localmonitor.isCanceled()) {
                        reporter.reportResults(element, NO_REFERENCES);
                    }
                    ReferenceExtractor visitor = new ReferenceExtractor(requestor, reporter, element, (IProgressMonitor)localmonitor.newChild(1));
                    IApiComponent comp = (IApiComponent)element;
                    comp.accept(visitor);
                    localmonitor.worked(1);
                    break;
                }
                case 5: 
                case 6: {
                    IApiMember member;
                    IApiType type;
                    if (localmonitor.isCanceled()) {
                        reporter.reportResults(element, NO_REFERENCES);
                    }
                    if ((type = (member = (IApiMember)element).getEnclosingType()) != null) {
                        refs = this.acceptReferences(requestor, type, this.getResolvedReferences(requestor, type, (IProgressMonitor)localmonitor.newChild(1)), (IProgressMonitor)localmonitor.newChild(1));
                    }
                    if (refs == null) break;
                    reporter.reportResults(element, refs.toArray(new IReference[refs.size()]));
                }
            }
            localmonitor.worked(1);
        }
        finally {
            localmonitor.done();
        }
    }

    public void search(IApiBaseline baseline, IApiSearchRequestor requestor, IApiSearchReporter reporter, IProgressMonitor monitor) throws CoreException {
        if (baseline == null || reporter == null || requestor == null) {
            return;
        }
        IApiSearchScope scope = requestor.getScope();
        if (scope == null) {
            return;
        }
        this.fRequestorContext = SearchMessages.ApiSearchEngine_api_internal;
        if (requestor.includesAPI() && !requestor.includesInternal()) {
            this.fRequestorContext = SearchMessages.ApiSearchEngine_api;
        }
        if (requestor.includesInternal() && !requestor.includesAPI()) {
            this.fRequestorContext = SearchMessages.ApiSearchEngine_internal;
        }
        IApiElement[] scopeelements = scope.getScope();
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format((String)SearchMessages.ApiSearchEngine_searching_projects, (Object[])new String[]{this.fRequestorContext}), (int)(scopeelements.length * 2 + 1));
        try {
            long start = System.currentTimeMillis();
            long loopstart = 0L;
            String taskname = null;
            int i = 0;
            while (i < scopeelements.length) {
                taskname = MessageFormat.format((String)SearchMessages.ApiSearchEngine_searching_project, (Object[])new String[]{scopeelements[i].getApiComponent().getId(), this.fRequestorContext});
                localmonitor.setTaskName(taskname);
                if (DEBUG) {
                    loopstart = System.currentTimeMillis();
                    System.out.println("Searching " + scopeelements[i].getApiComponent().getId() + "...");
                }
                this.searchReferences(requestor, scopeelements[i], reporter, (IProgressMonitor)localmonitor.newChild(1));
                localmonitor.setTaskName(taskname);
                if (localmonitor.isCanceled()) {
                    reporter.reportResults(scopeelements[i], NO_REFERENCES);
                    return;
                }
                localmonitor.worked(1);
                if (DEBUG) {
                    System.out.println(String.valueOf(Math.round((float)(i + 1) / (float)scopeelements.length * 100.0f)) + "% done in " + (System.currentTimeMillis() - loopstart) + " ms");
                }
                ++i;
            }
            if (DEBUG) {
                System.out.println("Total Search Time: " + (System.currentTimeMillis() - start) / 1000L + " seconds");
            }
        }
        finally {
            localmonitor.done();
        }
    }

    class ReferenceExtractor
    extends ApiTypeContainerVisitor {
        private List collector = new ArrayList();
        private IApiSearchRequestor requestor = null;
        private IApiSearchReporter reporter = null;
        IApiElement element = null;
        private SubMonitor monitor = null;

        public ReferenceExtractor(IApiSearchRequestor requestor, IApiSearchReporter reporter, IApiElement element, IProgressMonitor monitor) {
            this.requestor = requestor;
            this.reporter = reporter;
            this.element = element;
            this.monitor = (SubMonitor)monitor;
        }

        public void visit(String packageName, IApiTypeRoot typeroot) {
            if (this.monitor.isCanceled()) {
                return;
            }
            try {
                IApiType type = typeroot.getStructure();
                if (!this.requestor.acceptMember(type)) {
                    return;
                }
                this.collector.addAll(ApiSearchEngine.this.acceptReferences(this.requestor, type, ApiSearchEngine.this.getResolvedReferences(this.requestor, type, (IProgressMonitor)this.monitor.newChild(1)), (IProgressMonitor)this.monitor.newChild(1)));
            }
            catch (CoreException ce) {
                ApiPlugin.log(ce);
            }
        }

        public boolean visit(IApiComponent component) {
            return this.requestor.acceptComponent(component);
        }

        public void endVisitPackage(String packageName) {
            this.reporter.reportResults(this.element, this.collector.toArray(new IReference[this.collector.size()]));
            this.collector.clear();
        }
    }
}

