/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathMinus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XDTDayTimeDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XDTYearMonthDuration;

public class XSDateTime
extends CalendarType
implements CmpEq,
CmpLt,
CmpGt,
MathMinus,
MathPlus,
Cloneable {
    private Calendar _calendar;
    private boolean _timezoned;
    private XDTDayTimeDuration _tz;

    public XSDateTime(Calendar cal, XDTDayTimeDuration tz) {
        this._calendar = cal;
        this._tz = tz;
        this._timezoned = tz != null;
    }

    public Object clone() throws CloneNotSupportedException {
        Calendar c = (Calendar)this.calendar().clone();
        XDTDayTimeDuration t = this.tz();
        if (t != null) {
            t = (XDTDayTimeDuration)t.clone();
        }
        return new XSDateTime(c, t);
    }

    public XSDateTime() {
        this(new GregorianCalendar(), null);
    }

    public String type_name() {
        return "dateTime";
    }

    public static boolean is_digit(char x) {
        return '0' <= x && x <= '9';
    }

    public static int[] parse_date(String str) {
        int state = 0;
        int[] ret = new int[3];
        int i = 0;
        while (i < ret.length) {
            ret[i] = 0;
            ++i;
        }
        String token = "";
        int i2 = 0;
        while (i2 < str.length()) {
            char x = str.charAt(i2);
            switch (state) {
                case 0: {
                    if (XSDateTime.is_digit(x)) {
                        token = String.valueOf(token) + x;
                    } else if (x == '-') {
                        token = String.valueOf(token) + x;
                    } else {
                        return null;
                    }
                    state = 1;
                    break;
                }
                case 1: {
                    if (x == '-') {
                        int uyl;
                        String uy = token;
                        if (uy.startsWith("-")) {
                            uy = uy.substring(1, uy.length());
                        }
                        if ((uyl = uy.length()) < 4) {
                            return null;
                        }
                        if (uyl == 4 ? uy.compareTo("0000") == 0 : uy.charAt(0) == '0') {
                            return null;
                        }
                        ret[0] = Integer.parseInt(token);
                        token = "";
                        state = 2;
                        break;
                    }
                    if (XSDateTime.is_digit(x)) {
                        token = String.valueOf(token) + x;
                        break;
                    }
                    return null;
                }
                case 2: {
                    if (x == '-') {
                        if (token.length() != 2) {
                            return null;
                        }
                        ret[1] = Integer.parseInt(token);
                        token = "";
                        state = 3;
                        break;
                    }
                    if (XSDateTime.is_digit(x)) {
                        token = String.valueOf(token) + x;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (XSDateTime.is_digit(x)) {
                        token = String.valueOf(token) + x;
                        break;
                    }
                    return null;
                }
                default: {
                    assert (false);
                    return ret;
                }
            }
            ++i2;
        }
        if (state != 3) {
            return null;
        }
        if (token.length() != 2) {
            return null;
        }
        ret[2] = Integer.parseInt(token);
        return ret;
    }

    public static double[] parse_time(String str) {
        int state = 0;
        double[] ret = new double[3];
        String token = "";
        int i = 0;
        while (i < str.length()) {
            char x = str.charAt(i);
            switch (state) {
                case 0: 
                case 1: {
                    if (x == ':') {
                        if (token.length() != 2) {
                            return null;
                        }
                        ret[state] = Integer.parseInt(token);
                        ++state;
                        token = "";
                        break;
                    }
                    if (XSDateTime.is_digit(x)) {
                        token = String.valueOf(token) + x;
                        break;
                    }
                    return null;
                }
                case 2: {
                    if (XSDateTime.is_digit(x)) {
                        if ((token = String.valueOf(token) + x).length() <= 2) break;
                        return null;
                    }
                    if (x == '.') {
                        token = String.valueOf(token) + x;
                        state = 3;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (XSDateTime.is_digit(x)) {
                        token = String.valueOf(token) + x;
                        break;
                    }
                    return null;
                }
                default: {
                    assert (false);
                    return null;
                }
            }
            ++i;
        }
        if (state != 3 && state != 2) {
            return null;
        }
        if (token.length() == 3) {
            return null;
        }
        ret[2] = Double.parseDouble(token);
        return ret;
    }

    public static int[] parse_timezone(String str) {
        int[] ret;
        block12: {
            block11: {
                ret = new int[3];
                int i = 0;
                while (i < ret.length) {
                    ret[i] = 0;
                    ++i;
                }
                ret[0] = 1;
                if (str.equals("Z")) {
                    return ret;
                }
                if (str.startsWith("+")) {
                    ret[0] = 1;
                } else if (str.startsWith("-")) {
                    ret[0] = -1;
                } else {
                    return null;
                }
                str = str.substring(1, str.length());
                if (str.length() != 5) {
                    return null;
                }
                try {
                    ret[1] = Integer.parseInt(str.substring(0, 2));
                    ret[2] = Integer.parseInt(str.substring(3, 5));
                    if (ret[1] <= 14) break block11;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if (ret[2] <= 59) break block12;
            return null;
        }
        return ret;
    }

    private static boolean set_item(Calendar cal, int item, int val) {
        int min = cal.getActualMinimum(item);
        if (val < min) {
            return false;
        }
        int max = cal.getActualMaximum(item);
        if (val > max) {
            return false;
        }
        cal.set(item, val);
        return true;
    }

    public static XSDateTime parseDateTime(String str) {
        int[] d;
        int index = str.indexOf(84);
        if (index == -1) {
            return null;
        }
        String date = str.substring(0, index);
        String time = str.substring(index + 1, str.length());
        String timezone = null;
        index = time.indexOf(43);
        if (index == -1) {
            index = time.indexOf(45);
        }
        if (index == -1) {
            index = time.indexOf(90);
        }
        if (index != -1) {
            timezone = time.substring(index, time.length());
            time = time.substring(0, index);
        }
        if ((d = XSDateTime.parse_date(date)) == null) {
            return null;
        }
        TimeZone UTC = TimeZone.getTimeZone("UTC");
        GregorianCalendar cal = new GregorianCalendar(UTC);
        int year = d[0];
        if (year < 0) {
            year *= -1;
            cal.set(0, 0);
        } else {
            cal.set(0, 1);
        }
        cal.set(5, 2);
        cal.set(2, 2);
        if (!XSDateTime.set_item(cal, 1, year)) {
            return null;
        }
        if (!XSDateTime.set_item(cal, 2, d[1] - 1)) {
            return null;
        }
        if (!XSDateTime.set_item(cal, 5, d[2])) {
            return null;
        }
        double[] t = XSDateTime.parse_time(time);
        if (t == null) {
            return null;
        }
        if (!XSDateTime.set_item(cal, 11, (int)t[0])) {
            return null;
        }
        if (!XSDateTime.set_item(cal, 12, (int)t[1])) {
            return null;
        }
        if (!XSDateTime.set_item(cal, 13, (int)t[2])) {
            return null;
        }
        double ms = t[2] - (double)((int)t[2]);
        if (!XSDateTime.set_item(cal, 14, (int)(ms *= 1000.0))) {
            return null;
        }
        int[] tz = null;
        XDTDayTimeDuration tzd = null;
        if (timezone != null) {
            tz = XSDateTime.parse_timezone(timezone);
            if (tz == null) {
                return null;
            }
            int mul = 1;
            if (tz[0] > 0) {
                mul = -1;
            }
            tzd = new XDTDayTimeDuration(0, tz[1], tz[2], 0.0, tz[0] < 0);
            cal.add(11, mul * tz[1]);
            cal.add(12, mul * tz[2]);
        }
        return new XSDateTime(cal, tzd);
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        XSDateTime dt = XSDateTime.parseDateTime(aat.string_value());
        if (dt == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(dt);
        return rs;
    }

    public int year() {
        int y = this._calendar.get(1);
        if (this._calendar.get(0) == 0) {
            y *= -1;
        }
        return y;
    }

    public int month() {
        return this._calendar.get(2) + 1;
    }

    public int day() {
        return this._calendar.get(5);
    }

    public int hour() {
        return this._calendar.get(11);
    }

    public int minute() {
        return this._calendar.get(12);
    }

    public double second() {
        double s = this._calendar.get(13);
        double ms = this._calendar.get(14);
        return s += (ms /= 1000.0);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    public static String pad_int(int num, int len) {
        String ret = "";
        String snum = "" + num;
        int pad = len - snum.length();
        if (num < 0) {
            ret = String.valueOf(ret) + "-";
            snum = snum.substring(1, snum.length());
            ++pad;
        }
        int i = 0;
        while (i < pad) {
            ret = String.valueOf(ret) + "0";
            ++i;
        }
        ret = String.valueOf(ret) + snum;
        return ret;
    }

    public String string_value() {
        String ret = "";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.year(), 4);
        ret = String.valueOf(ret) + "-";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.month(), 2);
        ret = String.valueOf(ret) + "-";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.day(), 2);
        ret = String.valueOf(ret) + "T";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.hour(), 2);
        ret = String.valueOf(ret) + ":";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.minute(), 2);
        ret = String.valueOf(ret) + ":";
        int isecond = (int)this.second();
        double sec = this.second();
        ret = sec - (double)isecond == 0.0 ? String.valueOf(ret) + XSDateTime.pad_int(isecond, 2) : (sec < 10.0 ? String.valueOf(ret) + "0" + sec : String.valueOf(ret) + sec);
        if (this.timezoned()) {
            ret = String.valueOf(ret) + "Z";
        }
        return ret;
    }

    public String string_type() {
        return "xs:dateTime";
    }

    public Calendar calendar() {
        return this._calendar;
    }

    public boolean eq(AnyType arg) throws DynamicError {
        XSDateTime val = (XSDateTime)NumericType.get_single_type(arg, XSDateTime.class);
        return this.calendar().equals(val.calendar());
    }

    public boolean lt(AnyType arg) throws DynamicError {
        XSDateTime val = (XSDateTime)NumericType.get_single_type(arg, XSDateTime.class);
        return this.calendar().before(val.calendar());
    }

    public boolean gt(AnyType arg) throws DynamicError {
        XSDateTime val = (XSDateTime)NumericType.get_single_type(arg, XSDateTime.class);
        return this.calendar().after(val.calendar());
    }

    public XDTDayTimeDuration tz() {
        return this._tz;
    }

    public double value() {
        return (double)this.calendar().getTimeInMillis() / 1000.0;
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        AnyType at = arg.first();
        try {
            if (at instanceof XSDateTime) {
                XSDateTime val = (XSDateTime)NumericType.get_single_type(arg, XSDateTime.class);
                double res = this.value() - val.value();
                return ResultSequenceFactory.create_new(new XDTDayTimeDuration(res));
            }
            if (at instanceof XDTYearMonthDuration) {
                XDTYearMonthDuration val = (XDTYearMonthDuration)at;
                XSDateTime res = (XSDateTime)this.clone();
                res.calendar().add(2, val.value() * -1);
                return ResultSequenceFactory.create_new(res);
            }
            if (at instanceof XDTDayTimeDuration) {
                XDTDayTimeDuration val = (XDTDayTimeDuration)at;
                XSDateTime res = (XSDateTime)this.clone();
                res.calendar().add(14, (int)(val.value() * -1000.0));
                return ResultSequenceFactory.create_new(res);
            }
            DynamicError.throw_type_error();
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        AnyType at = arg.first();
        try {
            if (at instanceof XDTYearMonthDuration) {
                XDTYearMonthDuration val = (XDTYearMonthDuration)at;
                XSDateTime res = (XSDateTime)this.clone();
                res.calendar().add(2, val.value());
                return ResultSequenceFactory.create_new(res);
            }
            if (at instanceof XDTDayTimeDuration) {
                XDTDayTimeDuration val = (XDTDayTimeDuration)at;
                XSDateTime res = (XSDateTime)this.clone();
                res.calendar().add(14, (int)(val.value() * 1000.0));
                return ResultSequenceFactory.create_new(res);
            }
            DynamicError.throw_type_error();
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }
}

