/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xsl.core.internal.StylesheetBuilder;
import org.eclipse.wst.xsl.core.internal.util.FileUtil;
import org.eclipse.wst.xsl.core.model.Stylesheet;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XSLCore {
    public static final String XSL_NAMESPACE_URI = "http://www.w3.org/1999/XSL/Transform";
    public static final String XSL_CONTENT_TYPE = "org.eclipse.wst.xml.core.xslsource";
    private static XSLCore instance;
    private Map<IFile, StylesheetModel> stylesheetsComposed = new HashMap<IFile, StylesheetModel>();

    private XSLCore() {
    }

    public synchronized StylesheetModel getStylesheet(IFile file) {
        StylesheetModel stylesheet = this.stylesheetsComposed.get(file);
        if (stylesheet == null) {
            stylesheet = this.buildStylesheet(file);
        }
        return stylesheet;
    }

    public synchronized StylesheetModel buildStylesheet(IFile file) {
        Stylesheet stylesheet = StylesheetBuilder.getInstance().getStylesheet(file, true);
        if (stylesheet == null) {
            return null;
        }
        StylesheetModel stylesheetComposed = new StylesheetModel(stylesheet);
        this.stylesheetsComposed.put(file, stylesheetComposed);
        stylesheetComposed.fix();
        return stylesheetComposed;
    }

    public synchronized void clean(IProject project, IProgressMonitor monitor) {
        Iterator<StylesheetModel> iter = this.stylesheetsComposed.values().iterator();
        while (iter.hasNext()) {
            StylesheetModel model = iter.next();
            if (project != null && !project.equals((Object)model.getStylesheet().getFile().getProject())) continue;
            iter.remove();
        }
    }

    public static synchronized XSLCore getInstance() {
        if (instance == null) {
            instance = new XSLCore();
        }
        return instance;
    }

    public static IFile resolveFile(IFile currentFile, String uri) {
        if (uri == null || uri.trim().length() == 0) {
            return null;
        }
        IResource resource = currentFile.getParent().findMember((IPath)new Path(uri));
        if (resource == null || resource.getType() != 1) {
            return null;
        }
        return (IFile)resource;
    }

    public static boolean isXMLFile(IFile file) {
        return FileUtil.isXMLFile(file);
    }

    public static boolean isXSLFile(IFile file) {
        return FileUtil.isXSLFile(file);
    }

    public static boolean isXSLNamespace(Node node) {
        if (XSLCore.hasNamespace(node)) {
            return false;
        }
        return node.getNamespaceURI().equals(XSL_NAMESPACE_URI);
    }

    private static boolean hasNamespace(Node node) {
        return node == null || node.getNamespaceURI() == null;
    }

    public static Attr getCurrentAttrNode(Node node, int offset) {
        if (node instanceof IndexedRegion && ((IndexedRegion)node).contains(offset) && node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                IndexedRegion attRegion = (IndexedRegion)attrs.item(i);
                if (attRegion.contains(offset)) {
                    return (Attr)attrs.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static Node getCurrentNode(IDocument document, int offset) {
        IndexedRegion inode = null;
        IStructuredModel sModel = null;
        try {
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            inode = sModel.getIndexedRegion(offset);
            if (inode == null) {
                inode = sModel.getIndexedRegion(offset - 1);
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        if (inode instanceof Node) {
            return (Node)inode;
        }
        return null;
    }
}

