/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.BundleManifestChange;
import org.eclipse.pde.internal.ui.refactoring.PDEMoveParticipant;
import org.eclipse.pde.internal.ui.refactoring.PluginManifestChange;

public class ManifestTypeMoveParticipant
extends PDEMoveParticipant {
    protected boolean initialize(Object element) {
        IType type;
        IJavaProject javaProject;
        IProject project;
        if (element instanceof IType && WorkspaceModelManager.isPluginProject((IProject)(project = (javaProject = (IJavaProject)(type = (IType)element).getAncestor(2)).getProject()))) {
            this.fProject = javaProject.getProject();
            this.fElements = new HashMap();
            this.fElements.put(element, this.getNewName(this.getArguments().getDestination(), element));
            return true;
        }
        return false;
    }

    public String getName() {
        return PDEUIMessages.ManifestTypeRenameParticipant_composite;
    }

    protected boolean isInterestingForExtensions() {
        Object dest = this.getArguments().getDestination();
        if (dest instanceof IJavaElement) {
            IJavaElement destination = (IJavaElement)dest;
            IJavaProject jProject = (IJavaProject)destination.getAncestor(2);
            return jProject.getProject().equals((Object)this.fProject);
        }
        return false;
    }

    protected void addChange(CompositeChange result, String filename, IProgressMonitor pm) throws CoreException {
        Change change;
        IFile file = this.fProject.getFile(filename);
        if (file.exists() && (change = PluginManifestChange.createRenameChange(file, this.fElements.keySet().toArray(), this.getNewNames(), this.getTextChange(file), pm)) != null) {
            result.add(change);
        }
    }

    protected String getNewName(Object destination, Object element) {
        if (destination instanceof IPackageFragment && element instanceof IJavaElement) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(((IPackageFragment)destination).getElementName());
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            return buffer.append(((IJavaElement)element).getElementName()).toString();
        }
        return super.getNewName(destination, element);
    }

    protected void addChange(CompositeChange result, IProgressMonitor pm) throws CoreException {
        Change change;
        IFile file = this.fProject.getFile("META-INF/MANIFEST.MF");
        if (file.exists() && (change = BundleManifestChange.createRenameChange(file, this.fElements.keySet().toArray(), this.getNewNames(), pm)) != null) {
            result.add(change);
        }
    }
}

