/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.net;

import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.net.NetUIMessages;
import org.eclipse.ui.internal.net.NonProxyHostsComposite;
import org.eclipse.ui.internal.net.ProxyEntriesComposite;

public class ProxyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PROXY_PREFERENCE_PAGE_CONTEXT_ID = "org.eclipse.ui.net.proxy_preference_page_context";
    private Label providerLabel;
    protected Combo providerCombo;
    private ProxyEntriesComposite proxyEntriesComposite;
    private NonProxyHostsComposite nonProxyHostsComposite;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createProviderComposite(composite);
        this.createProxyEntriesComposite(composite);
        this.createNonProxiedHostsComposite(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), PROXY_PREFERENCE_PAGE_CONTEXT_ID);
        this.initializeValues();
        return composite;
    }

    private void createProviderComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        this.providerLabel = new Label(composite, 0);
        this.providerLabel.setText(NetUIMessages.ProxyPreferencePage_0);
        this.providerCombo = new Combo(composite, 12);
        this.providerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyPreferencePage.this.setProvider(ProxySelector.unlocalizeProvider((String)ProxyPreferencePage.this.providerCombo.getText()));
            }
        });
    }

    private void createProxyEntriesComposite(Composite parent) {
        this.proxyEntriesComposite = new ProxyEntriesComposite(parent, 0);
        this.proxyEntriesComposite.setLayoutData(new GridData(4, 4, true, true));
    }

    private void createNonProxiedHostsComposite(Composite parent) {
        this.nonProxyHostsComposite = new NonProxyHostsComposite(parent, 0);
        this.nonProxyHostsComposite.setLayoutData(new GridData(4, 4, true, true));
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        int sel = this.providerCombo.getSelectionIndex();
        this.proxyEntriesComposite.performApply();
        this.nonProxyHostsComposite.performApply();
        ProxySelector.setActiveProvider((String)ProxySelector.unlocalizeProvider((String)this.providerCombo.getItem(sel)));
    }

    protected void performDefaults() {
        int index = 1;
        if (this.providerCombo.getItemCount() == 3) {
            index = 2;
        }
        this.providerCombo.select(index);
        this.setProvider(ProxySelector.unlocalizeProvider((String)this.providerCombo.getItem(index)));
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    private void initializeValues() {
        String[] providers = ProxySelector.getProviders();
        String[] localizedProviders = new String[providers.length];
        int i = 0;
        while (i < localizedProviders.length) {
            localizedProviders[i] = ProxySelector.localizeProvider((String)providers[i]);
            ++i;
        }
        this.providerCombo.setItems(localizedProviders);
        this.providerCombo.select(this.providerCombo.indexOf(ProxySelector.localizeProvider((String)ProxySelector.getDefaultProvider())));
    }

    protected void setProvider(String name) {
        this.proxyEntriesComposite.setProvider(name);
        this.nonProxyHostsComposite.setProvider(name);
    }
}

