/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.actions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.actions.IVersionAdvice;

public class VersionAdvice
extends AbstractAdvice
implements IVersionAdvice {
    Map versions = new HashMap(11);

    public void load(String namespace, String location) {
        this.load(namespace, location, null);
    }

    public void load(String namespace, String location, String idSuffix) {
        Properties properties;
        block19: {
            if (namespace == null) {
                namespace = "null";
            }
            properties = new Properties();
            File file = new File(location);
            if (file.exists()) {
                InputStream stream = null;
                try {
                    try {
                        stream = new BufferedInputStream(new FileInputStream(file));
                        properties.load(stream);
                    }
                    catch (IOException iOException) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (properties.size() > 0) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (idSuffix != null) {
                    key = String.valueOf(key) + idSuffix;
                }
                String value = properties.getProperty(key);
                this.setVersion(namespace, key, new Version(value));
            }
        }
    }

    public Version getVersion(String namespace, String id) {
        Version result;
        Map values = (Map)this.versions.get(namespace);
        if (values != null && (result = (Version)values.get(id)) != null) {
            return result;
        }
        values = (Map)this.versions.get("null");
        if (values == null) {
            return null;
        }
        return (Version)values.get(id);
    }

    public void setVersion(String namespace, String id, Version version) {
        HashMap<String, Version> values = (HashMap<String, Version>)this.versions.get(namespace);
        if (values == null) {
            if (version == null) {
                return;
            }
            values = new HashMap<String, Version>();
            this.versions.put(namespace, values);
        }
        if (version == null) {
            values.remove(id);
        } else {
            values.put(id, version);
        }
    }

    public IPublisherAdvice merge(IPublisherAdvice advice) {
        if (!(advice instanceof VersionAdvice)) {
            return this;
        }
        VersionAdvice source = (VersionAdvice)advice;
        Iterator i = source.versions.keySet().iterator();
        while (i.hasNext()) {
            String namespace = (String)i.next();
            Map myValues = (Map)this.versions.get(namespace);
            Map sourceValues = (Map)source.versions.get(namespace);
            if (myValues == null) {
                this.versions.put(namespace, sourceValues);
                continue;
            }
            if (sourceValues == null) continue;
            this.versions.put(namespace, this.merge(myValues, sourceValues));
        }
        return this;
    }

    private Map merge(Map myValues, Map sourceValues) {
        HashMap result = new HashMap(myValues);
        Iterator i = sourceValues.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (result.get(key) != null) continue;
            result.put(key, sourceValues.get(key));
        }
        return result;
    }
}

