/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathDiv;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathMinus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathTimes;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDecimal;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;

public class XDTYearMonthDuration
extends XSDuration
implements CmpEq,
CmpLt,
CmpGt,
MathPlus,
MathMinus,
MathTimes,
MathDiv {
    private int _year;
    private int _month;
    private boolean _negative;

    public XDTYearMonthDuration(int year, int month, boolean negative) {
        this._year = year;
        this._month = month;
        this._negative = negative;
        if (this._month >= 12) {
            this._year += this._month / 12;
            this._month %= 12;
        }
    }

    public XDTYearMonthDuration(int months) {
        this(0, Math.abs(months), months < 0);
    }

    public XDTYearMonthDuration() {
        this(0, 0, false);
    }

    public static XDTYearMonthDuration parseYMDuration(String str) {
        boolean negative = false;
        int year = 0;
        int month = 0;
        int state = 0;
        String digits = "";
        int i = 0;
        while (i < str.length()) {
            char x = str.charAt(i);
            switch (state) {
                case 0: {
                    if (x == '-') {
                        negative = true;
                        state = 4;
                        break;
                    }
                    if (x == 'P') {
                        state = 5;
                        break;
                    }
                    return null;
                }
                case 4: {
                    if (x == 'P') {
                        state = 5;
                        break;
                    }
                    return null;
                }
                case 5: {
                    if ('0' <= x && x <= '9') {
                        digits = String.valueOf(digits) + x;
                        break;
                    }
                    if (x == 'Y') {
                        if (digits.length() == 0) {
                            return null;
                        }
                        year = Integer.parseInt(digits);
                        digits = "";
                        state = 6;
                        break;
                    }
                    if (x == 'M') {
                        if (digits.length() == 0) {
                            return null;
                        }
                        month = Integer.parseInt(digits);
                        state = 7;
                        break;
                    }
                    return null;
                }
                case 6: {
                    if ('0' <= x && x <= '9') {
                        digits = String.valueOf(digits) + x;
                        break;
                    }
                    if (x == 'M') {
                        if (digits.length() == 0) {
                            return null;
                        }
                        month = Integer.parseInt(digits);
                        state = 7;
                        break;
                    }
                    return null;
                }
                case 7: {
                    return null;
                }
                default: {
                    assert (false);
                    return null;
                }
            }
            ++i;
        }
        return new XDTYearMonthDuration(year, month, negative);
    }

    public String type_name() {
        return "yearMonthDuration";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        XDTYearMonthDuration ymd = XDTYearMonthDuration.parseYMDuration(aat.string_value());
        if (ymd == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(ymd);
        return rs;
    }

    public boolean negative() {
        return this._negative;
    }

    public int year() {
        return this._year;
    }

    public int month() {
        return this._month;
    }

    public String string_value() {
        int months;
        String strval = "";
        if (this.negative()) {
            strval = String.valueOf(strval) + "-";
        }
        strval = String.valueOf(strval) + "P";
        int years = this.year();
        if (years != 0) {
            strval = String.valueOf(strval) + years + "Y";
        }
        if ((months = this.month()) == 0) {
            if (years == 0) {
                strval = String.valueOf(strval) + months + "M";
            }
        } else {
            strval = String.valueOf(strval) + months + "M";
        }
        return strval;
    }

    public String string_type() {
        return "xdt:yearMonthDuration";
    }

    public int value() {
        int ret = this.year() * 12 + this.month();
        if (this.negative()) {
            ret *= -1;
        }
        return ret;
    }

    public boolean eq(AnyType arg) throws DynamicError {
        XDTYearMonthDuration val = (XDTYearMonthDuration)NumericType.get_single_type(arg, XDTYearMonthDuration.class);
        return this.value() == val.value();
    }

    public boolean lt(AnyType arg) throws DynamicError {
        XDTYearMonthDuration val = (XDTYearMonthDuration)NumericType.get_single_type(arg, XDTYearMonthDuration.class);
        return this.value() < val.value();
    }

    public boolean gt(AnyType arg) throws DynamicError {
        XDTYearMonthDuration val = (XDTYearMonthDuration)NumericType.get_single_type(arg, XDTYearMonthDuration.class);
        return this.value() > val.value();
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        XDTYearMonthDuration val = (XDTYearMonthDuration)NumericType.get_single_type(arg, XDTYearMonthDuration.class);
        int res = this.value() + val.value();
        return ResultSequenceFactory.create_new(new XDTYearMonthDuration(res));
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        XDTYearMonthDuration val = (XDTYearMonthDuration)NumericType.get_single_type(arg, XDTYearMonthDuration.class);
        int res = this.value() - val.value();
        return ResultSequenceFactory.create_new(new XDTYearMonthDuration(res));
    }

    public ResultSequence times(ResultSequence arg) throws DynamicError {
        XSDouble val = (XSDouble)NumericType.get_single_type(arg, XSDouble.class);
        int res = (int)Math.round((double)this.value() * val.double_value());
        return ResultSequenceFactory.create_new(new XDTYearMonthDuration(res));
    }

    public ResultSequence div(ResultSequence arg) throws DynamicError {
        AnyType at;
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        if ((at = arg.first()) instanceof XSDouble) {
            XSDouble dt = (XSDouble)at;
            int ret = 0;
            if (!dt.zero()) {
                ret = (int)Math.round((double)this.value() / dt.double_value());
            }
            return ResultSequenceFactory.create_new(new XDTYearMonthDuration(ret));
        }
        if (at instanceof XDTYearMonthDuration) {
            XDTYearMonthDuration md = (XDTYearMonthDuration)at;
            double res = (double)this.value() / (double)md.value();
            return ResultSequenceFactory.create_new(new XSDecimal(res));
        }
        DynamicError.throw_type_error();
        return null;
    }
}

