/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.internal.ui.launchConfigurations.AntClasspathTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntEnvironmentTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntJRETab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntMainTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntPropertiesTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetsTab;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsBuildTab;

public class AntTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean captureOutput = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", true);
            if (!captureOutput && configuration instanceof ILaunchConfigurationWorkingCopy) {
                ILaunchConfigurationWorkingCopy copy = (ILaunchConfigurationWorkingCopy)configuration;
                copy.setAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", null);
                copy.setAttribute("org.eclipse.debug.core.capture_output", false);
                copy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
            }
        }
        catch (CoreException coreException) {}
        super.initializeFrom(configuration);
    }

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{new AntMainTab(), new RefreshTab(), new ExternalToolsBuildTab(), new AntTargetsTab(), new AntClasspathTab(), new AntPropertiesTab(), new AntJRETab(), new AntEnvironmentTab(), new CommonTab()};
        this.setTabs(tabs);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IFile file;
        String extension;
        IResource resource = DebugUITools.getSelectedResource();
        if (resource != null && resource instanceof IFile && (extension = (file = (IFile)resource).getFileExtension()) != null && extension.equalsIgnoreCase("xml")) {
            String projectName = file.getProject().getName();
            StringBuffer buffer = new StringBuffer(projectName);
            buffer.append(' ');
            buffer.append(file.getName());
            String name = buffer.toString().trim();
            name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name);
            configuration.rename(name);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", file.getFullPath().toString()));
        }
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        super.setDefaults(configuration);
    }
}

