/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling.engine;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.DefaultPhoneticDistanceAlgorithm;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.DefaultPhoneticHashProvider;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.IPhoneticDistanceAlgorithm;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.IPhoneticHashProvider;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.RankedWordProposal;

public abstract class AbstractSpellDictionary
implements ISpellDictionary {
    protected static final int BUCKET_CAPACITY = 4;
    protected static final int BUFFER_CAPACITY = 32;
    protected static final int DISTANCE_THRESHOLD = 160;
    protected static final int HASH_CAPACITY = 22528;
    private IPhoneticDistanceAlgorithm fDistanceAlgorithm = new DefaultPhoneticDistanceAlgorithm();
    private final Map fHashBuckets = new HashMap(22528);
    private IPhoneticHashProvider fHashProvider = new DefaultPhoneticHashProvider();
    private boolean fLoaded = false;
    private boolean fMustLoad = true;
    boolean fIsStrippingNonLetters = true;

    protected final Object getCandidates(String hash) {
        return this.fHashBuckets.get(hash);
    }

    protected final Set getCandidates(String word, boolean sentence, ArrayList hashs) {
        int distance = 0;
        String hash = null;
        StringBuffer buffer = new StringBuffer(32);
        HashSet<RankedWordProposal> result = new HashSet<RankedWordProposal>(4 * hashs.size());
        int index = 0;
        while (index < hashs.size()) {
            hash = (String)hashs.get(index);
            Object candidates = this.getCandidates(hash);
            if (candidates != null) {
                if (candidates instanceof String) {
                    String candidate = (String)candidates;
                    distance = this.fDistanceAlgorithm.getDistance(word, candidate);
                    if (distance < 160) {
                        buffer.setLength(0);
                        buffer.append(candidate);
                        if (sentence) {
                            buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                        }
                        result.add(new RankedWordProposal(buffer.toString(), -distance));
                    }
                } else {
                    ArrayList candidateList = (ArrayList)candidates;
                    int offset = 0;
                    while (offset < candidateList.size()) {
                        String candidate = (String)candidateList.get(offset);
                        distance = this.fDistanceAlgorithm.getDistance(word, candidate);
                        if (distance < 160) {
                            buffer.setLength(0);
                            buffer.append(candidate);
                            if (sentence) {
                                buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                            }
                            result.add(new RankedWordProposal(buffer.toString(), -distance));
                        }
                        ++offset;
                    }
                }
            }
            ++index;
        }
        return result;
    }

    protected final void getCandidates(String word, boolean sentence, Set result) {
        int distance = 0;
        int minimum = Integer.MAX_VALUE;
        StringBuffer buffer = new StringBuffer(32);
        Object candidates = this.getCandidates(this.fHashProvider.getHash(word));
        if (candidates == null) {
            return;
        }
        if (candidates instanceof String) {
            String candidate = (String)candidates;
            distance = this.fDistanceAlgorithm.getDistance(word, candidate);
            buffer.append(candidate);
            if (sentence) {
                buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
            }
            result.add(new RankedWordProposal(buffer.toString(), -distance));
            return;
        }
        ArrayList candidateList = (ArrayList)candidates;
        ArrayList<RankedWordProposal> matches = new ArrayList<RankedWordProposal>(candidateList.size());
        int index = 0;
        while (index < candidateList.size()) {
            String candidate = (String)candidateList.get(index);
            distance = this.fDistanceAlgorithm.getDistance(word, candidate);
            if (distance <= minimum) {
                if (distance < minimum) {
                    matches.clear();
                }
                buffer.setLength(0);
                buffer.append(candidate);
                if (sentence) {
                    buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                }
                matches.add(new RankedWordProposal(buffer.toString(), -distance));
                minimum = distance;
            }
            ++index;
        }
        result.addAll(matches);
    }

    protected boolean isEmpty() {
        return this.fHashBuckets.size() == 0;
    }

    protected final IPhoneticDistanceAlgorithm getDistanceAlgorithm() {
        return this.fDistanceAlgorithm;
    }

    protected final IPhoneticHashProvider getHashProvider() {
        return this.fHashProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getProposals(String word, boolean sentence) {
        block14: {
            try {
                if (this.fLoaded) break block14;
                AbstractSpellDictionary abstractSpellDictionary = this;
                synchronized (abstractSpellDictionary) {
                    this.fLoaded = this.load(this.getURL());
                    if (this.fLoaded) {
                        this.compact();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        String hash = this.fHashProvider.getHash(word);
        char[] mutators = this.fHashProvider.getMutators();
        ArrayList<String> neighborhood = new ArrayList<String>((word.length() + 1) * (mutators.length + 2));
        neighborhood.add(hash);
        Set candidates = this.getCandidates(word, sentence, neighborhood);
        neighborhood.clear();
        char previous = '\u0000';
        char next = '\u0000';
        char[] characters = word.toCharArray();
        int index = 0;
        while (index < word.length() - 1) {
            next = characters[index];
            characters[index] = previous = characters[index + 1];
            characters[index + 1] = next;
            neighborhood.add(this.fHashProvider.getHash(new String(characters)));
            characters[index] = next;
            characters[index + 1] = previous;
            ++index;
        }
        String sentinel = String.valueOf(word) + " ";
        characters = sentinel.toCharArray();
        int offset = characters.length - 1;
        while (true) {
            int index2 = 0;
            while (index2 < mutators.length) {
                characters[offset] = mutators[index2];
                neighborhood.add(this.fHashProvider.getHash(new String(characters)));
                ++index2;
            }
            if (offset == 0) break;
            characters[offset] = characters[offset - 1];
            --offset;
        }
        char mutated = '\u0000';
        characters = word.toCharArray();
        int index3 = 0;
        while (index3 < word.length()) {
            mutated = characters[index3];
            int mutator = 0;
            while (mutator < mutators.length) {
                characters[index3] = mutators[mutator];
                neighborhood.add(this.fHashProvider.getHash(new String(characters)));
                ++mutator;
            }
            characters[index3] = mutated;
            ++index3;
        }
        characters = word.toCharArray();
        char[] deleted = new char[characters.length - 1];
        int index4 = 0;
        while (index4 < deleted.length) {
            deleted[index4] = characters[index4];
            ++index4;
        }
        next = characters[characters.length - 1];
        offset = deleted.length;
        while (true) {
            neighborhood.add(this.fHashProvider.getHash(new String(characters)));
            if (offset == 0) break;
            previous = next;
            next = deleted[offset - 1];
            deleted[offset - 1] = previous;
            --offset;
        }
        neighborhood.remove(hash);
        Set matches = this.getCandidates(word, sentence, neighborhood);
        if (matches.size() == 0 && candidates.size() == 0) {
            this.getCandidates(word, sentence, candidates);
        }
        candidates.addAll(matches);
        return candidates;
    }

    protected abstract URL getURL() throws MalformedURLException;

    protected final void hashWord(String word) {
        String hash = this.fHashProvider.getHash(word);
        Object bucket = this.fHashBuckets.get(hash);
        if (bucket == null) {
            this.fHashBuckets.put(hash, word);
        } else if (bucket instanceof ArrayList) {
            ((ArrayList)bucket).add(word);
        } else {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(bucket);
            list.add(word);
            this.fHashBuckets.put(hash, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCorrect(String word) {
        block8: {
            word = this.stripNonLetters(word);
            try {
                if (this.fLoaded) break block8;
                AbstractSpellDictionary abstractSpellDictionary = this;
                synchronized (abstractSpellDictionary) {
                    this.fLoaded = this.load(this.getURL());
                    if (this.fLoaded) {
                        this.compact();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        Object candidates = this.getCandidates(this.fHashProvider.getHash(word));
        if (candidates == null) {
            return false;
        }
        if (candidates instanceof String) {
            String candidate = (String)candidates;
            return candidate.equals(word) || candidate.equals(word.toLowerCase());
        }
        ArrayList candidateList = (ArrayList)candidates;
        return candidateList.contains(word) || candidateList.contains(word.toLowerCase());
    }

    public void setStripNonLetters(boolean state) {
        this.fIsStrippingNonLetters = state;
    }

    /*
     * Unable to fully structure code
     */
    protected String stripNonLetters(String word) {
        if (!this.fIsStrippingNonLetters) {
            return word;
        }
        i = 0;
        j = word.length() - 1;
        while (i <= j && !Character.isLetter(word.charAt(i))) {
            ++i;
        }
        if (i <= j) ** GOTO lbl11
        return "";
lbl-1000:
        // 1 sources

        {
            --j;
lbl11:
            // 2 sources

            ** while (j > i && !Character.isLetter((char)word.charAt((int)j)))
        }
lbl12:
        // 1 sources

        return word.substring(i, j + 1);
    }

    public final synchronized boolean isLoaded() {
        return this.fLoaded || this.fHashBuckets.size() > 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized boolean load(URL url) {
        if (!this.fMustLoad) {
            return this.fLoaded;
        }
        if (url == null) return false;
        InputStream stream = null;
        int line = 0;
        try {
            block20: {
                stream = url.openStream();
                if (stream == null) break block20;
                String word = null;
                CharsetDecoder decoder = Charset.forName(this.getEncoding()).newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPORT);
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, decoder));
                boolean doRead = true;
                while (true) {
                    if (!doRead) {
                        Object var11_18 = null;
                        this.fMustLoad = false;
                        break;
                    }
                    try {
                        word = reader.readLine();
                    }
                    catch (MalformedInputException ex) {
                        decoder.onMalformedInput(CodingErrorAction.REPLACE);
                        decoder.reset();
                        word = reader.readLine();
                        decoder.onMalformedInput(CodingErrorAction.REPORT);
                        String message = Messages.format(JavaUIMessages.AbstractSpellingDictionary_encodingError, new String[]{word, decoder.replacement(), url.toString()});
                        Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 0, message, (Throwable)ex);
                        JavaScriptPlugin.log((IStatus)status);
                        doRead = word != null;
                        continue;
                    }
                    doRead = word != null;
                    if (!doRead) continue;
                    this.hashWord(word);
                }
                try {
                    if (stream == null) return true;
                    stream.close();
                    return true;
                }
                catch (IOException iOException) {}
                return true;
                catch (FileNotFoundException ex) {
                    boolean bl;
                    String urlString = url.toString();
                    String lowercaseUrlString = urlString.toLowerCase();
                    if (urlString.equals(lowercaseUrlString)) {
                        JavaScriptPlugin.log(ex);
                        break block20;
                    }
                    try {
                        bl = this.load(new URL(lowercaseUrlString));
                    }
                    catch (MalformedURLException e) {
                        JavaScriptPlugin.log(e);
                        break block20;
                    }
                    Object var11_19 = null;
                    this.fMustLoad = false;
                    try {}
                    catch (IOException iOException) {}
                    if (stream == null) return bl;
                    stream.close();
                    return bl;
                }
                catch (IOException exception) {
                    if (line > 0) {
                        String message = Messages.format(JavaUIMessages.AbstractSpellingDictionary_encodingError, new Object[]{new Integer(line), url.toString()});
                        Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 0, message, (Throwable)exception);
                        JavaScriptPlugin.log((IStatus)status);
                        break block20;
                    }
                    JavaScriptPlugin.log(exception);
                }
            }
            Object var11_21 = null;
            this.fMustLoad = false;
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            this.fMustLoad = false;
            try {}
            catch (IOException iOException) {}
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return false;
        }
        if (stream == null) return false;
        stream.close();
        return false;
    }

    private void compact() {
        Iterator iter = this.fHashBuckets.values().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof ArrayList)) continue;
            ((ArrayList)element).trimToSize();
        }
    }

    protected final void setDistanceAlgorithm(IPhoneticDistanceAlgorithm algorithm) {
        this.fDistanceAlgorithm = algorithm;
    }

    protected final void setHashProvider(IPhoneticHashProvider provider) {
        this.fHashProvider = provider;
    }

    public synchronized void unload() {
        this.fLoaded = false;
        this.fMustLoad = true;
        this.fHashBuckets.clear();
    }

    public boolean acceptsWords() {
        return false;
    }

    public void addWord(String word) {
    }

    protected String getEncoding() {
        String encoding = JavaScriptPlugin.getDefault().getPreferenceStore().getString("spelling_user_dictionary_encoding");
        if (encoding == null || encoding.length() == 0) {
            encoding = ResourcesPlugin.getEncoding();
        }
        return encoding;
    }
}

