/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.db;

import java.util.Iterator;
import org.eclipse.jpt.core.JpaNode;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Sequence;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.Tracing;
import org.eclipse.jpt.ui.internal.listeners.SWTConnectionListenerWrapper;
import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseObjectCombo<T extends JpaNode>
extends Pane<T> {
    private CCombo comboBox;
    private ConnectionListener connectionListener;
    private PropertyChangeListener connectionProfileListener;

    protected DatabaseObjectCombo(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected DatabaseObjectCombo(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected DatabaseObjectCombo(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.connectionListener = this.buildConnectionListener();
        this.connectionProfileListener = this.buildConnectionProfileListener();
    }

    protected ConnectionListener buildConnectionListener() {
        return new SWTConnectionListenerWrapper(this.buildConnectionListener_());
    }

    protected ConnectionListener buildConnectionListener_() {
        return new LocalConnectionListener();
    }

    protected PropertyChangeListener buildConnectionProfileListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildConnectionProfileListener_());
    }

    protected PropertyChangeListener buildConnectionProfileListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                DatabaseObjectCombo.this.connectionProfileChanged(event);
            }
        };
    }

    protected void connectionProfileChanged(PropertyChangeEvent event) {
        if (event.getOldValue() != null) {
            ((ConnectionProfile)event.getOldValue()).removeConnectionListener(this.connectionListener);
        }
        if (event.getNewValue() != null) {
            ((ConnectionProfile)event.getNewValue()).addConnectionListener(this.connectionListener);
        }
        this.repopulateComboBox();
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.comboBox = this.addEditableCCombo(container);
        this.comboBox.addModifyListener(this.buildModifyListener());
        SWTUtil.attachDefaultValueHandler(this.comboBox);
    }

    protected ModifyListener buildModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatabaseObjectCombo.this.comboBoxModified();
            }
        };
    }

    protected abstract Iterator<String> values();

    protected abstract String getDefaultValue();

    protected abstract String getValue();

    protected abstract void setValue(String var1);

    @Override
    protected void engageListeners_(T subject) {
        super.engageListeners_(subject);
        subject.getJpaProject().getDataSource().addPropertyChangeListener("connectionProfile", this.connectionProfileListener);
        ConnectionProfile cp = subject.getJpaProject().getConnectionProfile();
        if (cp != null) {
            cp.addConnectionListener(this.connectionListener);
        }
    }

    @Override
    protected void disengageListeners_(T subject) {
        ConnectionProfile cp = subject.getJpaProject().getConnectionProfile();
        if (cp != null) {
            cp.removeConnectionListener(this.connectionListener);
        }
        subject.getJpaProject().getDataSource().removePropertyChangeListener("connectionProfile", this.connectionProfileListener);
        super.disengageListeners_(subject);
    }

    @Override
    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        if (!this.comboBox.isDisposed()) {
            this.comboBox.setEnabled(enabled);
        }
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        this.updateSelectedItem();
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.populateComboBox();
    }

    protected void populateComboBox() {
        this.comboBox.removeAll();
        this.comboBox.add(this.buildDefaultValueEntry());
        if (this.connectionProfileIsActive()) {
            Iterator<String> stream = this.values();
            while (stream.hasNext()) {
                this.comboBox.add(stream.next());
            }
        }
        this.updateSelectedItem_();
    }

    protected String buildDefaultValueEntry() {
        if (this.getSubject() == null) {
            return JptUiMappingsMessages.NoneSelected;
        }
        String defaultValue = this.getDefaultValue();
        return defaultValue == null ? this.buildNullDefaultValueEntry() : this.buildNonNullDefaultValueEntry(defaultValue);
    }

    protected String buildNullDefaultValueEntry() {
        return JptUiMappingsMessages.DefaultEmpty;
    }

    protected String buildNonNullDefaultValueEntry(String defaultValue) {
        return NLS.bind((String)JptUiMappingsMessages.DefaultWithOneParam, (Object)defaultValue);
    }

    protected void updateSelectedItem() {
        String defaultValueEntry = this.buildDefaultValueEntry();
        if (!this.comboBox.getItem(0).equals(defaultValueEntry)) {
            this.comboBox.remove(0);
            this.comboBox.add(defaultValueEntry, 0);
        }
        this.updateSelectedItem_();
    }

    protected void updateSelectedItem_() {
        String value;
        String string = value = this.getSubject() == null ? null : this.getValue();
        if (value == null) {
            this.comboBox.select(0);
        } else if (!value.equals(this.comboBox.getText())) {
            this.comboBox.setText(value);
        }
    }

    protected void comboBoxModified() {
        if (!this.isPopulating()) {
            this.valueChanged(this.comboBox.getText());
        }
    }

    protected void valueChanged(String newValue) {
        String oldValue;
        JpaNode subject = (JpaNode)this.getSubject();
        if (subject == null) {
            if (this.nullSubjectIsNotAllowed()) {
                return;
            }
            oldValue = null;
        } else {
            oldValue = this.getValue();
        }
        if (StringTools.stringIsEmpty((String)newValue) || this.valueIsDefault(newValue)) {
            newValue = null;
        }
        if (this.valuesAreDifferent(oldValue, newValue)) {
            this.setPopulating(true);
            try {
                this.setValue(newValue);
            }
            finally {
                this.setPopulating(false);
            }
        }
    }

    protected boolean nullSubjectIsAllowed() {
        return false;
    }

    protected final boolean nullSubjectIsNotAllowed() {
        return !this.nullSubjectIsAllowed();
    }

    protected boolean valueIsDefault(String value) {
        return this.comboBox.getItemCount() > 0 && value.equals(this.comboBox.getItem(0));
    }

    protected boolean valuesAreEqual(String value1, String value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    protected boolean valuesAreDifferent(String value1, String value2) {
        return !this.valuesAreEqual(value1, value2);
    }

    protected JpaProject getJpaProject() {
        JpaNode subject = (JpaNode)this.getSubject();
        return subject == null ? null : subject.getJpaProject();
    }

    protected final ConnectionProfile getConnectionProfile() {
        JpaProject jpaProject = this.getJpaProject();
        return jpaProject == null ? null : jpaProject.getConnectionProfile();
    }

    protected final boolean connectionProfileIsActive() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp != null && cp.isActive();
    }

    protected final Database getDatabase() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp == null ? null : cp.getDatabase();
    }

    protected void repopulateComboBox() {
        if (!this.comboBox.isDisposed()) {
            this.repopulate();
        }
    }

    protected final void databaseChanged(Database database) {
        if (!this.comboBox.isDisposed()) {
            this.databaseChanged_(database);
        }
    }

    protected void databaseChanged_(Database database) {
    }

    protected final void catalogChanged(Catalog catalog) {
        if (!this.comboBox.isDisposed()) {
            this.catalogChanged_(catalog);
        }
    }

    protected void catalogChanged_(Catalog catalog) {
    }

    protected final void schemaChanged(Schema schema) {
        if (!this.comboBox.isDisposed()) {
            this.schemaChanged_(schema);
        }
    }

    protected void schemaChanged_(Schema schema) {
    }

    protected final void sequenceChanged(Sequence sequence) {
        if (!this.comboBox.isDisposed()) {
            this.sequenceChanged_(sequence);
        }
    }

    protected void sequenceChanged_(Sequence sequence) {
    }

    protected final void tableChanged(Table table) {
        if (!this.comboBox.isDisposed()) {
            this.tableChanged_(table);
        }
    }

    protected void tableChanged_(Table table) {
    }

    protected final void columnChanged(Column column) {
        if (!this.comboBox.isDisposed()) {
            this.columnChanged_(column);
        }
    }

    protected void columnChanged_(Column column) {
    }

    protected final void foreignKeyChanged(ForeignKey foreignKey) {
        if (!this.comboBox.isDisposed()) {
            this.foreignKeyChanged_(foreignKey);
        }
    }

    protected void foreignKeyChanged_(ForeignKey foreignKey) {
    }

    @Override
    protected void log(String flag, String message) {
        if (flag.equals("/debug/ui/db") && Tracing.booleanDebugOption("/debug/ui/db")) {
            this.log(message);
        } else {
            super.log(flag, message);
        }
    }

    protected class LocalConnectionListener
    implements ConnectionListener {
        protected LocalConnectionListener() {
        }

        public void opened(ConnectionProfile profile) {
            this.log("opened: " + profile.getName());
            DatabaseObjectCombo.this.repopulateComboBox();
        }

        public void modified(ConnectionProfile profile) {
            this.log("modified: " + profile.getName());
            DatabaseObjectCombo.this.repopulateComboBox();
        }

        public boolean okToClose(ConnectionProfile profile) {
            this.log("OK to close: " + profile.getName());
            return true;
        }

        public void aboutToClose(ConnectionProfile profile) {
            this.log("about to close: " + profile.getName());
        }

        public void closed(ConnectionProfile profile) {
            this.log("closed: " + profile.getName());
            DatabaseObjectCombo.this.repopulateComboBox();
        }

        public void databaseChanged(ConnectionProfile profile, Database database) {
            this.log("database changed: " + database.getName());
            DatabaseObjectCombo.this.databaseChanged(database);
        }

        public void catalogChanged(ConnectionProfile profile, Catalog catalog) {
            this.log("catalog changed: " + catalog.getName());
            DatabaseObjectCombo.this.catalogChanged(catalog);
        }

        public void schemaChanged(ConnectionProfile profile, Schema schema) {
            this.log("schema changed: " + schema.getName());
            DatabaseObjectCombo.this.schemaChanged(schema);
        }

        public void sequenceChanged(ConnectionProfile profile, Sequence sequence) {
            this.log("sequence changed: " + sequence.getName());
            DatabaseObjectCombo.this.sequenceChanged(sequence);
        }

        public void tableChanged(ConnectionProfile profile, Table table) {
            this.log("table changed: " + table.getName());
            DatabaseObjectCombo.this.tableChanged(table);
        }

        public void columnChanged(ConnectionProfile profile, Column column) {
            this.log("column changed: " + column.getName());
            DatabaseObjectCombo.this.columnChanged(column);
        }

        public void foreignKeyChanged(ConnectionProfile profile, ForeignKey foreignKey) {
            this.log("foreign key changed: " + foreignKey.getName());
            DatabaseObjectCombo.this.foreignKeyChanged(foreignKey);
        }

        protected void log(String message) {
            DatabaseObjectCombo.this.log("/debug/ui/db", message);
        }
    }
}

