/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.internal.DefaultHttpContext;
import org.eclipse.equinox.http.servlet.internal.ProxyServlet;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpServiceImpl
implements HttpService {
    private Bundle bundle;
    private ProxyServlet proxy;
    private Set aliases = new HashSet();
    private boolean shutdown = false;

    public HttpServiceImpl(Bundle bundle, ProxyServlet proxy) {
        this.bundle = bundle;
        this.proxy = proxy;
    }

    synchronized void unregisterAliases() {
        Iterator it = this.aliases.iterator();
        while (it.hasNext()) {
            String alias = (String)it.next();
            this.proxy.unregister(alias, false);
        }
        this.aliases.clear();
        this.shutdown = true;
    }

    private void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("Service instance is already shutdown");
        }
    }

    public synchronized void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext context) throws ServletException, NamespaceException {
        this.checkShutdown();
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        this.proxy.registerServlet(alias, servlet, initparams, context, this.bundle);
        this.aliases.add(alias);
    }

    public synchronized void registerResources(String alias, String name, HttpContext context) throws NamespaceException {
        this.checkShutdown();
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        this.proxy.registerResources(alias, name, context);
        this.aliases.add(alias);
    }

    public synchronized void unregister(String alias) {
        this.checkShutdown();
        if (!this.aliases.remove(alias)) {
            throw new IllegalArgumentException("Alias not found.");
        }
        this.proxy.unregister(alias, true);
    }

    public HttpContext createDefaultHttpContext() {
        this.checkShutdown();
        return new DefaultHttpContext(this.bundle);
    }
}

