/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.util;

import org.eclipse.datatools.connectivity.oda.spec.AdvancedQuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultProjection;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultSetSpecification;
import org.eclipse.datatools.connectivity.oda.spec.result.SortSpecification;

public class QuerySpecificationFactory {
    protected QuerySpecification createQuerySpecification() {
        return new QuerySpecification();
    }

    protected AdvancedQuerySpecification createAdvancedQuerySpecification() {
        return new AdvancedQuerySpecification();
    }

    protected ResultSetSpecification createResultSetSpecification() {
        return new ResultSetSpecification();
    }

    protected ResultProjection createResultProjection() {
        return new ResultProjection();
    }

    protected SortSpecification createSortSpecification() {
        return new SortSpecification();
    }

    protected SortSpecification createSortSpecification(int sortMode) {
        return new SortSpecification(sortMode);
    }

    public QuerySpecification createQuerySpecification(FilterExpression filterExpr, ResultProjection projectionSpec, SortSpecification sortSpec) {
        ResultSetSpecification resultSetSpec = this.createResultSetSpecification();
        resultSetSpec.setFilterSpecification(filterExpr);
        resultSetSpec.setResultProjection(projectionSpec);
        resultSetSpec.setSortSpecification(sortSpec);
        QuerySpecification newQuerySpec = this.createQuerySpecification();
        newQuerySpec.setResultSetSpecification(resultSetSpec);
        return newQuerySpec;
    }
}

