/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.ApiDescriptionProcessor;
import org.eclipse.pde.api.tools.internal.BundleVersionRange;
import org.eclipse.pde.api.tools.internal.CompositeApiDescription;
import org.eclipse.pde.api.tools.internal.RequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.model.AbstractApiComponent;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.ArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.DirectoryApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.ProfileModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.util.SourceDefaultHandler;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.internal.core.TargetWeaver;
import org.osgi.framework.BundleException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BundleApiComponent
extends AbstractApiComponent {
    private Dictionary fManifest;
    private static final String[] MANIFEST_HEADERS = new String[]{"Eclipse-SourceBundle", "Bundle-ClassPath", "Bundle-Name", "Bundle-Version"};
    private boolean fHasApiDescription = false;
    private String fLocation;
    private BundleDescription fBundleDescription;
    private String[] lowestEEs;

    public BundleApiComponent(IApiBaseline profile, String location) throws CoreException {
        super(profile);
        this.fLocation = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            super.dispose();
        }
        catch (Throwable throwable) {
            BundleApiComponent bundleApiComponent = this;
            synchronized (bundleApiComponent) {
                this.fManifest = null;
                this.fBundleDescription = null;
            }
            throw throwable;
        }
        BundleApiComponent bundleApiComponent = this;
        synchronized (bundleApiComponent) {
            this.fManifest = null;
            this.fBundleDescription = null;
        }
    }

    protected synchronized Dictionary getManifest() throws CoreException {
        if (this.fManifest == null) {
            try {
                this.fManifest = (Dictionary)((Object)this.loadManifest(new File(this.fLocation)));
            }
            catch (IOException e) {
                this.abort("Unable to load manifest due to IO error", e);
            }
        }
        return this.fManifest;
    }

    protected synchronized void doManifestCompaction() throws CoreException {
        Dictionary temp = this.fManifest;
        this.fManifest = new Hashtable(MANIFEST_HEADERS.length);
        int i = 0;
        while (i < MANIFEST_HEADERS.length) {
            String header = MANIFEST_HEADERS[i];
            Object value = temp.get(header);
            if (value != null) {
                this.fManifest.put(header, value);
            }
            ++i;
        }
    }

    public boolean isValidBundle() throws CoreException {
        Dictionary manifest = this.getManifest();
        return manifest != null && manifest.get("Bundle-Name") != null && manifest.get("Bundle-Version") != null;
    }

    protected synchronized void init(long bundleId) throws CoreException {
        try {
            Dictionary manifest = this.getManifest();
            if (this.isBinaryBundle() && "workspace".equals(this.getBaseline().getName())) {
                TargetWeaver.weaveManifest((Dictionary)manifest);
            }
            StateObjectFactory factory = StateObjectFactory.defaultFactory;
            this.fBundleDescription = factory.createBundleDescription(((ApiBaseline)this.getBaseline()).getState(), manifest, this.fLocation, bundleId);
            this.setName((String)this.getManifest().get("Bundle-Name"));
        }
        catch (BundleException e) {
            this.abort("Unable to create API component from specified location: " + this.fLocation, e);
        }
        this.doManifestCompaction();
    }

    protected boolean isBinaryBundle() {
        return true;
    }

    protected IApiDescription createApiDescription() throws CoreException {
        BundleDescription[] fragments = this.getBundleDescription().getFragments();
        if (fragments.length == 0) {
            return this.createLocalApiDescription();
        }
        IApiDescription[] descriptions = new IApiDescription[fragments.length + 1];
        int i = 0;
        while (i < fragments.length) {
            BundleDescription fragment = fragments[i];
            BundleApiComponent component = (BundleApiComponent)this.getBaseline().getApiComponent(fragment.getSymbolicName());
            descriptions[i + 1] = component.getApiDescription();
            ++i;
        }
        descriptions[0] = this.createLocalApiDescription();
        return new CompositeApiDescription(descriptions);
    }

    protected IApiDescription createLocalApiDescription() throws CoreException {
        ApiDescription apiDesc = new ApiDescription(this.getId());
        BundleApiComponent.initializeApiDescription(apiDesc, this.getBundleDescription(), this.getLocalPackageNames());
        try {
            String xml = this.loadApiDescription(new File(this.fLocation));
            this.setHasApiDescription(xml != null);
            if (xml != null) {
                ApiDescriptionProcessor.annotateApiSettings(null, apiDesc, xml);
            }
        }
        catch (IOException e) {
            this.abort("Unable to load .api_description file ", e);
        }
        return apiDesc;
    }

    protected Set getLocalPackageNames() throws CoreException {
        HashSet<String> names = new HashSet<String>();
        IApiTypeContainer[] containers = this.getApiTypeContainers();
        IApiComponent comp = null;
        int i = 0;
        while (i < containers.length) {
            comp = (IApiComponent)containers[i].getAncestor(1);
            if (comp != null && comp.getId().equals(this.getId())) {
                String[] packageNames = containers[i].getPackageNames();
                int j = 0;
                while (j < packageNames.length) {
                    names.add(packageNames[j]);
                    ++j;
                }
            }
            ++i;
        }
        return names;
    }

    public static void initializeApiDescription(IApiDescription apiDesc, BundleDescription bundle, Set packages) throws CoreException {
        int i;
        Iterator iterator = packages.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            apiDesc.setVisibility(Factory.packageDescriptor(name), 2);
        }
        ArrayList supplied = new ArrayList();
        ExportPackageDescription[] exportPackages = bundle.getExportPackages();
        BundleApiComponent.addSuppliedPackages(packages, supplied, exportPackages);
        HostSpecification host = bundle.getHost();
        if (host != null) {
            BundleDescription[] hosts = host.getHosts();
            i = 0;
            while (i < hosts.length) {
                BundleApiComponent.addSuppliedPackages(packages, supplied, hosts[i].getExportPackages());
                ++i;
            }
        }
        BundleDescription[] fragments = bundle.getFragments();
        i = 0;
        while (i < fragments.length) {
            BundleApiComponent.addSuppliedPackages(packages, supplied, fragments[i].getExportPackages());
            ++i;
        }
        BundleApiComponent.annotateExportedPackages(apiDesc, supplied.toArray(new ExportPackageDescription[supplied.size()]));
    }

    protected static void addSuppliedPackages(Set packages, List supplied, ExportPackageDescription[] exportPackages) {
        int i = 0;
        while (i < exportPackages.length) {
            ExportPackageDescription pkg = exportPackages[i];
            String name = pkg.getName();
            if (name.equals(".")) {
                name = "";
            }
            if (packages.contains(name)) {
                supplied.add(pkg);
            }
            ++i;
        }
    }

    protected static void annotateExportedPackages(IApiDescription apiDesc, ExportPackageDescription[] exportedPackages) {
        int i = 0;
        while (i < exportedPackages.length) {
            ExportPackageDescription pkg = exportedPackages[i];
            boolean internal = (Boolean)pkg.getDirective("x-internal");
            String[] friends = (String[])pkg.getDirective("x-friends");
            String pkgName = pkg.getName();
            if (pkgName.equals(".")) {
                pkgName = "";
            }
            IPackageDescriptor pkgDesc = Factory.packageDescriptor(pkgName);
            if (internal) {
                apiDesc.setVisibility(pkgDesc, 2);
            }
            if (friends != null) {
                apiDesc.setVisibility(pkgDesc, 2);
                int j = 0;
                while (j < friends.length) {
                    apiDesc.setAccessLevel(Factory.componentDescriptor(friends[j]), Factory.packageDescriptor(pkgName), 1);
                    ++j;
                }
            }
            if (!internal && friends == null) {
                apiDesc.setVisibility(pkgDesc, 1);
            }
            ++i;
        }
    }

    protected IApiFilterStore createApiFilterStore() throws CoreException {
        return null;
    }

    protected synchronized List createApiTypeContainers() throws CoreException {
        if (this.fBundleDescription == null) {
            this.baselineDisposed();
        }
        ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>(5);
        try {
            BundleApiComponent component;
            ArrayList<BundleApiComponent> all = new ArrayList<BundleApiComponent>();
            all.add(this);
            boolean considerFragments = true;
            if ("org.eclipse.swt".equals(this.getId())) {
                boolean bl = considerFragments = !this.isApiEnabled();
            }
            if (considerFragments) {
                BundleDescription[] fragments = this.fBundleDescription.getFragments();
                int i = 0;
                while (i < fragments.length) {
                    BundleDescription fragment = fragments[i];
                    component = (BundleApiComponent)this.getBaseline().getApiComponent(fragment.getSymbolicName());
                    if (component != null) {
                        component.getApiTypeContainers();
                        all.add(component);
                    }
                    ++i;
                }
            }
            Iterator iterator = all.iterator();
            HashSet<String> entryNames = new HashSet<String>(5);
            BundleApiComponent other = null;
            while (iterator.hasNext()) {
                component = (BundleApiComponent)iterator.next();
                String[] paths = this.getClasspathEntries(component.getManifest());
                int i = 0;
                while (i < paths.length) {
                    String path = paths[i];
                    if (".".equals(path) || !entryNames.contains(path)) {
                        IApiTypeContainer container = component.createApiTypeContainer(path);
                        if (container == null) {
                            Iterator iter = all.iterator();
                            while (iter.hasNext()) {
                                other = (BundleApiComponent)iter.next();
                                if (other == component) continue;
                                container = other.createApiTypeContainer(path);
                            }
                        }
                        if (container != null) {
                            containers.add(container);
                            if (!".".equals(path)) {
                                entryNames.add(path);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        catch (BundleException e) {
            this.abort("Unable to parse bundle classpath", e);
        }
        catch (IOException e) {
            this.abort("Unable to initialize class file containers", e);
        }
        return containers;
    }

    protected boolean isApiEnabled() {
        return false;
    }

    protected String[] getClasspathEntries(Dictionary manifest) throws BundleException {
        ManifestElement[] classpath = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)((String)manifest.get("Bundle-ClassPath")));
        String[] elements = null;
        if (classpath == null) {
            elements = new String[]{"."};
        } else {
            elements = new String[classpath.length];
            int i = 0;
            while (i < classpath.length) {
                elements[i] = classpath[i].getValue();
                ++i;
            }
        }
        return elements;
    }

    protected IApiTypeContainer createApiTypeContainer(String path) throws IOException, CoreException {
        block24: {
            File bundle = new File(this.fLocation);
            if (bundle.isDirectory()) {
                File entry = new File(bundle, path);
                if (entry.exists()) {
                    if (entry.isFile()) {
                        return new ArchiveApiTypeContainer(this, entry.getCanonicalPath());
                    }
                    return new DirectoryApiTypeContainer(this, entry.getCanonicalPath());
                }
            } else {
                ZipFile zip = null;
                try {
                    File tempFile;
                    if (path.equals(".")) {
                        ArchiveApiTypeContainer archiveApiTypeContainer = new ArchiveApiTypeContainer(this, this.fLocation);
                        return archiveApiTypeContainer;
                    }
                    zip = new ZipFile(this.fLocation);
                    ZipEntry entry = zip.getEntry(path);
                    if (entry == null) break block24;
                    InputStream inputStream = null;
                    FileOutputStream outputStream = null;
                    try {
                        inputStream = zip.getInputStream(entry);
                        tempFile = File.createTempFile("api", "tmp");
                        tempFile.deleteOnExit();
                        outputStream = new FileOutputStream(tempFile);
                        byte[] bytes = new byte[8096];
                        while (inputStream.available() > 0) {
                            int read = inputStream.read(bytes);
                            if (read <= 0) continue;
                            outputStream.write(bytes, 0, read);
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                ApiPlugin.log(e);
                            }
                        }
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException e) {
                                ApiPlugin.log(e);
                            }
                        }
                    }
                    ArchiveApiTypeContainer archiveApiTypeContainer = new ArchiveApiTypeContainer(this, tempFile.getCanonicalPath());
                    return archiveApiTypeContainer;
                }
                finally {
                    if (zip != null) {
                        zip.close();
                    }
                }
            }
        }
        return null;
    }

    protected Map loadManifest(File bundleLocation) throws IOException {
        block11: {
            Map map;
            ZipFile jarFile = null;
            InputStream manifestStream = null;
            String extension = new Path(bundleLocation.getName()).getFileExtension();
            try {
                if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                    jarFile = new ZipFile(bundleLocation, 1);
                    ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                    if (manifestEntry != null) {
                        manifestStream = jarFile.getInputStream(manifestEntry);
                    }
                } else {
                    File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
                    if (file.exists()) {
                        manifestStream = new FileInputStream(file);
                    }
                }
                if (manifestStream == null) {
                    this.closingZipFileAndStream(manifestStream, jarFile);
                    return null;
                }
                map = ManifestElement.parseBundleManifest((InputStream)manifestStream, new Hashtable(10));
                this.closingZipFileAndStream(manifestStream, jarFile);
            }
            catch (BundleException e) {
                ApiPlugin.log(e);
                break block11;
            }
            finally {
                this.closingZipFileAndStream(manifestStream, jarFile);
            }
            return map;
        }
        return null;
    }

    protected Manifest readManifest(File bundleLocation) throws IOException {
        InputStream manifestStream;
        ZipFile jarFile;
        block7: {
            jarFile = null;
            manifestStream = null;
            try {
                String extension = new Path(bundleLocation.getName()).getFileExtension();
                if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                    jarFile = new ZipFile(bundleLocation, 1);
                    ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                    if (manifestEntry != null) {
                        manifestStream = jarFile.getInputStream(manifestEntry);
                    }
                } else {
                    File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
                    if (file.exists()) {
                        manifestStream = new FileInputStream(file);
                    }
                }
                if (manifestStream != null) break block7;
                this.closingZipFileAndStream(manifestStream, jarFile);
                return null;
            }
            catch (Throwable throwable) {
                this.closingZipFileAndStream(manifestStream, jarFile);
                throw throwable;
            }
        }
        Manifest manifest = new Manifest(manifestStream);
        this.closingZipFileAndStream(manifestStream, jarFile);
        return manifest;
    }

    void closingZipFileAndStream(InputStream stream, ZipFile jarFile) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
    }

    protected String readFileContents(String xmlFileName, File bundleLocation) {
        ZipFile jarFile = null;
        InputStream stream = null;
        try {
            String extension = new Path(bundleLocation.getName()).getFileExtension();
            if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry(xmlFileName);
                if (manifestEntry != null) {
                    stream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File file = new File(bundleLocation, xmlFileName);
                if (file.exists()) {
                    stream = new FileInputStream(file);
                }
            }
            if (stream == null) {
                this.closingZipFileAndStream(stream, jarFile);
                return null;
            }
            String string = new String(Util.getInputStreamAsCharArray(stream, -1, "UTF-8"));
            this.closingZipFileAndStream(stream, jarFile);
            return string;
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
        finally {
            this.closingZipFileAndStream(stream, jarFile);
        }
        return null;
    }

    protected String loadApiDescription(File bundleLocation) throws IOException {
        String contents;
        InputStream stream;
        ZipFile jarFile;
        block7: {
            jarFile = null;
            stream = null;
            contents = null;
            try {
                String extension = new Path(bundleLocation.getName()).getFileExtension();
                if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                    jarFile = new ZipFile(bundleLocation, 1);
                    ZipEntry manifestEntry = jarFile.getEntry(".api_description");
                    if (manifestEntry != null) {
                        stream = jarFile.getInputStream(manifestEntry);
                    }
                } else {
                    File file = new File(bundleLocation, ".api_description");
                    if (file.exists()) {
                        stream = new FileInputStream(file);
                    }
                }
                if (stream != null) break block7;
                this.closingZipFileAndStream(stream, jarFile);
                return null;
            }
            catch (Throwable throwable) {
                this.closingZipFileAndStream(stream, jarFile);
                throw throwable;
            }
        }
        char[] charArray = Util.getInputStreamAsCharArray(stream, -1, "UTF-8");
        contents = new String(charArray);
        this.closingZipFileAndStream(stream, jarFile);
        return contents;
    }

    protected URL getFileInBundle(File bundleLocation, String filePath) throws MalformedURLException {
        String extension = new Path(bundleLocation.getName()).getFileExtension();
        StringBuffer urlSt = new StringBuffer();
        if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
            urlSt.append("jar:file:");
            urlSt.append(bundleLocation.getAbsolutePath());
            urlSt.append("!/");
            urlSt.append(filePath);
        } else {
            urlSt.append("file:");
            urlSt.append(bundleLocation.getAbsolutePath());
            urlSt.append(File.separatorChar);
            urlSt.append(filePath);
        }
        return new URL(urlSt.toString());
    }

    public synchronized String[] getExecutionEnvironments() throws CoreException {
        if (this.fBundleDescription == null) {
            this.baselineDisposed();
        }
        return this.fBundleDescription.getExecutionEnvironments();
    }

    public synchronized String getId() throws CoreException {
        if (this.fBundleDescription == null) {
            this.baselineDisposed();
        }
        return this.fBundleDescription.getSymbolicName();
    }

    public synchronized IRequiredComponentDescription[] getRequiredComponents() throws CoreException {
        if (this.fBundleDescription == null) {
            this.baselineDisposed();
        }
        BundleSpecification[] requiredBundles = this.fBundleDescription.getRequiredBundles();
        IRequiredComponentDescription[] req = new IRequiredComponentDescription[requiredBundles.length];
        int i = 0;
        while (i < requiredBundles.length) {
            BundleSpecification bundle = requiredBundles[i];
            req[i] = new RequiredComponentDescription(bundle.getName(), new BundleVersionRange(bundle.getVersionRange()), bundle.isOptional(), bundle.isExported());
            ++i;
        }
        return req;
    }

    public synchronized String getVersion() throws CoreException {
        if (this.fBundleDescription == null) {
            this.baselineDisposed();
        }
        return this.fBundleDescription.getVersion().toString();
    }

    public synchronized BundleDescription getBundleDescription() throws CoreException {
        if (this.fBundleDescription == null) {
            this.baselineDisposed();
        }
        return this.fBundleDescription;
    }

    public String toString() {
        if (this.fBundleDescription != null) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append(this.fBundleDescription.toString());
                buffer.append(" - ");
                buffer.append("[fragment: ").append(this.isFragment()).append("] ");
                buffer.append("[host: ").append(this.fBundleDescription.getFragments().length > 0).append("] ");
                buffer.append("[system bundle: ").append(this.isSystemComponent()).append("] ");
                buffer.append("[source bundle: ").append(this.isSourceComponent()).append("] ");
                return buffer.toString();
            }
            catch (CoreException coreException) {}
        }
        return super.toString();
    }

    public String getLocation() {
        return this.fLocation;
    }

    public boolean isSystemComponent() {
        return false;
    }

    protected boolean getBooleanOption(Map options, String optionName, boolean defaultValue) {
        Boolean optionB = (Boolean)options.get(optionName);
        if (optionB != null) {
            return optionB;
        }
        return defaultValue;
    }

    public synchronized boolean isSourceComponent() throws CoreException {
        if (this.fManifest == null) {
            this.baselineDisposed();
        }
        ManifestElement[] sourceBundle = null;
        try {
            sourceBundle = ManifestElement.parseHeader((String)"Eclipse-SourceBundle", (String)((String)this.fManifest.get("Eclipse-SourceBundle")));
        }
        catch (BundleException bundleException) {}
        if (sourceBundle != null) {
            return true;
        }
        String pluginXMLContents = this.readFileContents("plugin.xml", new File(this.getLocation()));
        if (pluginXMLContents != null && this.containsSourceExtensionPoint(pluginXMLContents)) {
            return true;
        }
        pluginXMLContents = this.readFileContents("fragment.xml", new File(this.getLocation()));
        return pluginXMLContents != null && this.containsSourceExtensionPoint(pluginXMLContents);
    }

    private boolean containsSourceExtensionPoint(String pluginXMLContents) {
        SAXParserFactory factory = null;
        try {
            factory = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            return false;
        }
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {}
        if (saxParser == null) {
            return false;
        }
        InputSource inputSource = new InputSource(new BufferedReader(new StringReader(pluginXMLContents)));
        try {
            SourceDefaultHandler defaultHandler = new SourceDefaultHandler();
            saxParser.parse(inputSource, (DefaultHandler)defaultHandler);
            return defaultHandler.isSource();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    public synchronized boolean isFragment() throws CoreException {
        if (this.fBundleDescription == null) {
            this.baselineDisposed();
        }
        return this.fBundleDescription.getHost() != null;
    }

    public synchronized IApiComponent getHost() throws CoreException {
        HostSpecification host;
        if (this.fBundleDescription == null) {
            this.baselineDisposed();
        }
        if ((host = this.fBundleDescription.getHost()) != null) {
            return this.getBaseline().getApiComponent(host.getName());
        }
        return null;
    }

    public synchronized boolean hasFragments() throws CoreException {
        if (this.fBundleDescription == null) {
            this.baselineDisposed();
        }
        return this.fBundleDescription.getFragments().length != 0;
    }

    protected void setHasApiDescription(boolean hasApiDescription) {
        this.fHasApiDescription = hasApiDescription;
    }

    public boolean hasApiDescription() {
        try {
            this.getApiDescription();
        }
        catch (CoreException coreException) {}
        return this.fHasApiDescription;
    }

    public String[] getLowestEEs() throws CoreException {
        if (this.lowestEEs != null) {
            return this.lowestEEs;
        }
        String[] temp = null;
        String[] executionEnvironments = this.getExecutionEnvironments();
        int length = executionEnvironments.length;
        switch (length) {
            case 0: {
                return null;
            }
            case 1: {
                temp = new String[]{executionEnvironments[0]};
                break;
            }
            default: {
                int tempLength;
                int values = 0;
                int i = 0;
                while (i < length) {
                    values |= ProfileModifiers.getValue(executionEnvironments[i]);
                    ++i;
                }
                if (ProfileModifiers.isJRE(values)) {
                    temp = ProfileModifiers.isJRE_1_1(values) ? new String[]{"JRE-1.1"} : (ProfileModifiers.isJ2SE_1_2(values) ? new String[]{"J2SE-1.2"} : (ProfileModifiers.isJ2SE_1_3(values) ? new String[]{"J2SE-1.3"} : (ProfileModifiers.isJ2SE_1_4(values) ? new String[]{"J2SE-1.4"} : (ProfileModifiers.isJ2SE_1_5(values) ? new String[]{"J2SE-1.5"} : new String[]{"JavaSE-1.6"}))));
                }
                if (ProfileModifiers.isCDC_Foundation(values)) {
                    temp = ProfileModifiers.isCDC_1_0_FOUNDATION_1_0(values) ? (temp != null ? new String[]{temp[0], "CDC-1.0/Foundation-1.0"} : new String[]{"CDC-1.0/Foundation-1.0"}) : (temp != null ? new String[]{temp[0], "CDC-1.1/Foundation-1.1"} : new String[]{"CDC-1.1/Foundation-1.1"});
                }
                if (!ProfileModifiers.isOSGi(values)) break;
                if (ProfileModifiers.isOSGI_MINIMUM_1_0(values)) {
                    if (temp != null) {
                        tempLength = temp.length;
                        String[] stringArray = temp;
                        temp = new String[tempLength + 1];
                        System.arraycopy(stringArray, 0, temp, 0, tempLength);
                        temp[tempLength] = "OSGi/Minimum-1.0";
                        break;
                    }
                    temp = new String[]{"OSGi/Minimum-1.0"};
                    break;
                }
                if (ProfileModifiers.isOSGI_MINIMUM_1_1(values)) {
                    if (temp != null) {
                        tempLength = temp.length;
                        String[] stringArray = temp;
                        temp = new String[tempLength + 1];
                        System.arraycopy(stringArray, 0, temp, 0, tempLength);
                        temp[tempLength] = "OSGi/Minimum-1.1";
                        break;
                    }
                    temp = new String[]{"OSGi/Minimum-1.1"};
                    break;
                }
                if (temp != null) {
                    tempLength = temp.length;
                    String[] stringArray = temp;
                    temp = new String[tempLength + 1];
                    System.arraycopy(stringArray, 0, temp, 0, tempLength);
                    temp[tempLength] = "OSGi/Minimum-1.2";
                    break;
                }
                temp = new String[]{"OSGi/Minimum-1.2"};
            }
        }
        this.lowestEEs = temp;
        return temp;
    }

    public synchronized ResolverError[] getErrors() throws CoreException {
        IApiElement ancestor;
        if (this.fBundleDescription == null) {
            this.baselineDisposed();
        }
        if ((ancestor = this.getAncestor(4)) != null && ancestor instanceof ApiBaseline) {
            ApiBaseline baseline = (ApiBaseline)ancestor;
            ResolverError[] resolverErrors = baseline.getState().getResolverErrors(this.fBundleDescription);
            if (resolverErrors.length == 0) {
                return null;
            }
            return resolverErrors;
        }
        return null;
    }

    protected void baselineDisposed() throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", 123, "baseline is disposed", null));
    }
}

