/*
 * Decompiled with CFR 0.152.
 */
package com.android.prefs;

import java.io.File;

public final class AndroidLocation {
    public static final String FOLDER_AVD = "avd";
    private static String sPrefsLocation = null;

    public static final String getFolder() throws AndroidLocationException {
        File f;
        if (sPrefsLocation == null) {
            String home = AndroidLocation.findValidPath("ANDROID_SDK_HOME", "user.home", "HOME");
            if (home == null) {
                throw new AndroidLocationException("Unable to get the home directory. Make sure the user.home property is set up");
            }
            sPrefsLocation = home + File.separator + ".android" + File.separator;
        }
        if (!(f = new File(sPrefsLocation)).exists()) {
            try {
                f.mkdir();
            }
            catch (SecurityException e) {
                AndroidLocationException e2 = new AndroidLocationException(String.format("Unable to create folder '%1$s'. This is the path of preference folder expected by the Android tools.", sPrefsLocation));
                e2.initCause(e);
                throw e2;
            }
        } else if (f.isFile()) {
            throw new AndroidLocationException(sPrefsLocation + " is not a directory! " + "This is the path of preference folder expected by the Android tools.");
        }
        return sPrefsLocation;
    }

    private static String findValidPath(String ... names) {
        for (String name : names) {
            File f;
            String path = name.indexOf(46) != -1 ? System.getProperty(name) : System.getenv(name);
            if (path == null || !(f = new File(path)).isDirectory()) continue;
            return path;
        }
        return null;
    }

    public static final class AndroidLocationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AndroidLocationException(String string) {
            super(string);
        }
    }
}

