/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.device;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceBridge {
    private static AndroidDebugBridge bridge;
    private static final HashMap<IDevice, Integer> devicePortMap;
    private static int nextLocalPort;

    public static void initDebugBridge() {
        if (bridge == null) {
            AndroidDebugBridge.init(false);
        }
        if (bridge == null || !bridge.isConnected()) {
            String adbLocation = System.getProperty("hierarchyviewer.adb");
            adbLocation = adbLocation != null && adbLocation.length() != 0 ? adbLocation + File.separator + "adb" : "adb";
            bridge = AndroidDebugBridge.createBridge(adbLocation, true);
        }
    }

    public static void startListenForDevices(AndroidDebugBridge.IDeviceChangeListener listener) {
        AndroidDebugBridge.addDeviceChangeListener(listener);
    }

    public static void stopListenForDevices(AndroidDebugBridge.IDeviceChangeListener listener) {
        AndroidDebugBridge.removeDeviceChangeListener(listener);
    }

    public static IDevice[] getDevices() {
        return bridge.getDevices();
    }

    public static boolean isViewServerRunning(IDevice device) {
        DeviceBridge.initDebugBridge();
        boolean[] result = new boolean[1];
        try {
            if (device.isOnline()) {
                device.executeShellCommand(DeviceBridge.buildIsServerRunningShellCommand(), new BooleanResultReader(result));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    public static boolean startViewServer(IDevice device) {
        return DeviceBridge.startViewServer(device, 4939);
    }

    public static boolean startViewServer(IDevice device, int port) {
        DeviceBridge.initDebugBridge();
        boolean[] result = new boolean[1];
        try {
            if (device.isOnline()) {
                device.executeShellCommand(DeviceBridge.buildStartServerShellCommand(port), new BooleanResultReader(result));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    public static boolean stopViewServer(IDevice device) {
        DeviceBridge.initDebugBridge();
        boolean[] result = new boolean[1];
        try {
            if (device.isOnline()) {
                device.executeShellCommand(DeviceBridge.buildStopServerShellCommand(), new BooleanResultReader(result));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    public static void terminate() {
        AndroidDebugBridge.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupDeviceForward(IDevice device) {
        HashMap<IDevice, Integer> hashMap = devicePortMap;
        synchronized (hashMap) {
            if (device.getState() == IDevice.DeviceState.ONLINE) {
                int localPort = nextLocalPort++;
                device.createForward(localPort, 4939);
                devicePortMap.put(device, localPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDeviceForward(IDevice device) {
        HashMap<IDevice, Integer> hashMap = devicePortMap;
        synchronized (hashMap) {
            Integer localPort = devicePortMap.get(device);
            if (localPort != null) {
                device.removeForward(localPort, 4939);
                devicePortMap.remove(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDeviceLocalPort(IDevice device) {
        HashMap<IDevice, Integer> hashMap = devicePortMap;
        synchronized (hashMap) {
            Integer port = devicePortMap.get(device);
            if (port != null) {
                return port;
            }
            Log.e("hierarchy", "Missing forwarded port for " + device.getSerialNumber());
            return -1;
        }
    }

    private static String buildStartServerShellCommand(int port) {
        return String.format("service call window %d i32 %d", 1, port);
    }

    private static String buildStopServerShellCommand() {
        return String.format("service call window %d", 2);
    }

    private static String buildIsServerRunningShellCommand() {
        return String.format("service call window %d", 3);
    }

    static {
        devicePortMap = new HashMap();
        nextLocalPort = 4939;
    }

    private static class BooleanResultReader
    extends MultiLineReceiver {
        private final boolean[] mResult;

        public BooleanResultReader(boolean[] result) {
            this.mResult = result;
        }

        public void processNewLines(String[] strings) {
            Pattern pattern;
            Matcher matcher;
            if (strings.length > 0 && (matcher = (pattern = Pattern.compile(".*?\\([0-9]{8} ([0-9]{8}).*")).matcher(strings[0])).matches() && Integer.parseInt(matcher.group(1)) == 1) {
                this.mResult[0] = true;
            }
        }

        public boolean isCancelled() {
            return false;
        }
    }
}

