/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import org.w3c.dom.Node;

class XmlParserUtils {
    XmlParserUtils() {
    }

    public static Node getFirstChild(Node node, String xmlLocalName) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !"http://schemas.android.com/sdk/android/repository/1".equals(child.getNamespaceURI()) || xmlLocalName != null && !xmlLocalName.equals(child.getLocalName())) continue;
            return child;
        }
        return null;
    }

    public static String getXmlString(Node node, String xmlLocalName) {
        Node child = XmlParserUtils.getFirstChild(node, xmlLocalName);
        return child == null ? "" : child.getTextContent();
    }

    public static int getXmlInt(Node node, String xmlLocalName, int defaultValue) {
        String s = XmlParserUtils.getXmlString(node, xmlLocalName);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getXmlLong(Node node, String xmlLocalName, long defaultValue) {
        String s = XmlParserUtils.getXmlString(node, xmlLocalName);
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Object getEnumAttribute(Node archiveNode, String attrName, Object[] values, Object defaultValue) {
        Node attr = archiveNode.getAttributes().getNamedItem(attrName);
        if (attr != null) {
            String found = attr.getNodeValue();
            for (Object value : values) {
                if (!value.toString().equalsIgnoreCase(found)) continue;
                return value;
            }
        }
        return defaultValue;
    }
}

