/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.AddOnTarget;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.PlatformTarget;
import com.android.sdklib.SdkConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SdkManager {
    public static final String PROP_VERSION_SDK = "ro.build.version.sdk";
    public static final String PROP_VERSION_CODENAME = "ro.build.version.codename";
    public static final String PROP_VERSION_RELEASE = "ro.build.version.release";
    private static final String ADDON_NAME = "name";
    private static final String ADDON_VENDOR = "vendor";
    private static final String ADDON_API = "api";
    private static final String ADDON_DESCRIPTION = "description";
    private static final String ADDON_LIBRARIES = "libraries";
    private static final String ADDON_DEFAULT_SKIN = "skin";
    private static final String ADDON_USB_VENDOR = "usb-vendor";
    private static final String ADDON_REVISION = "revision";
    private static final String ADDON_REVISION_OLD = "version";
    private static final Pattern PATTERN_PROP = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    private static final Pattern PATTERN_LIB_DATA = Pattern.compile("^([a-zA-Z0-9._-]+\\.jar);(.*)$", 2);
    private static final Pattern PATTERN_USB_IDS = Pattern.compile("^0x[a-f0-9]{4}$", 2);
    private static final String[] sPlatformContentList = new String[]{"android.jar", "framework.aidl", SdkConstants.OS_SDK_TOOLS_FOLDER + SdkConstants.FN_AAPT, SdkConstants.OS_SDK_TOOLS_FOLDER + SdkConstants.FN_AIDL, SdkConstants.OS_SDK_TOOLS_FOLDER + SdkConstants.FN_DX, SdkConstants.OS_SDK_TOOLS_LIB_FOLDER + "dx.jar"};
    private static final String ADB_INI_FILE = "adb_usb.ini";
    private static final String ADB_INI_HEADER = "# ANDROID 3RD PARTY USB VENDOR ID LIST -- DO NOT EDIT.\n# USE 'android update adb' TO GENERATE.\n# 1 USB VENDOR ID PER LINE.\n";
    private final String mSdkLocation;
    private IAndroidTarget[] mTargets;

    public static SdkManager createManager(String sdkLocation, ISdkLog log) {
        try {
            SdkManager manager = new SdkManager(sdkLocation);
            ArrayList<IAndroidTarget> list = new ArrayList<IAndroidTarget>();
            SdkManager.loadPlatforms(sdkLocation, list, log);
            SdkManager.loadAddOns(sdkLocation, list, log);
            Collections.sort(list);
            manager.setTargets(list.toArray(new IAndroidTarget[list.size()]));
            return manager;
        }
        catch (IllegalArgumentException e) {
            if (log != null) {
                log.error(e, "Error parsing the sdk.", new Object[0]);
            }
            return null;
        }
    }

    public String getLocation() {
        return this.mSdkLocation;
    }

    public IAndroidTarget[] getTargets() {
        return this.mTargets;
    }

    public IAndroidTarget getTargetFromHashString(String hash) {
        if (hash != null) {
            for (IAndroidTarget target : this.mTargets) {
                if (!hash.equals(target.hashString())) continue;
                return target;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdb() throws AndroidLocation.AndroidLocationException, IOException {
        OutputStreamWriter writer = null;
        try {
            IAndroidTarget[] targets;
            File adbIni = new File(AndroidLocation.getFolder(), ADB_INI_FILE);
            writer = new FileWriter(adbIni);
            HashSet<Integer> set = new HashSet<Integer>();
            for (IAndroidTarget target : targets = this.getTargets()) {
                if (target.getUsbVendorId() == 0) continue;
                set.add(target.getUsbVendorId());
            }
            writer.write(ADB_INI_HEADER);
            for (Integer i : set) {
                writer.write(String.format("0x%04x\n", i));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void reloadSdk(ISdkLog log) {
        ArrayList<IAndroidTarget> list = new ArrayList<IAndroidTarget>();
        SdkManager.loadPlatforms(this.mSdkLocation, list, log);
        SdkManager.loadAddOns(this.mSdkLocation, list, log);
        Collections.sort(list);
        this.setTargets(list.toArray(new IAndroidTarget[list.size()]));
    }

    private SdkManager(String sdkLocation) {
        this.mSdkLocation = sdkLocation;
    }

    private void setTargets(IAndroidTarget[] targets) {
        this.mTargets = targets;
    }

    private static void loadPlatforms(String location, ArrayList<IAndroidTarget> list, ISdkLog log) {
        File platformFolder = new File(location, "platforms");
        if (platformFolder.isDirectory()) {
            File[] platforms;
            for (File platform : platforms = platformFolder.listFiles()) {
                if (platform.isDirectory()) {
                    PlatformTarget target = SdkManager.loadPlatform(platform, log);
                    if (target == null) continue;
                    list.add(target);
                    continue;
                }
                if (log == null) continue;
                log.warning("Ignoring platform '%1$s', not a folder.", platform.getName());
            }
            return;
        }
        String message = null;
        message = !platformFolder.exists() ? "%s is missing." : "%s is not a folder.";
        throw new IllegalArgumentException(String.format(message, platformFolder.getAbsolutePath()));
    }

    private static PlatformTarget loadPlatform(File platform, ISdkLog log) {
        File buildProp = new File(platform, "build.prop");
        if (buildProp.isFile()) {
            Map<String, String> map = SdkManager.parsePropertyFile(buildProp, log);
            if (map != null) {
                int apiNumber;
                String apiName = map.get(PROP_VERSION_RELEASE);
                if (apiName == null) {
                    if (log != null) {
                        log.error(null, "Ignoring platform '%1$s': %2$s is missing from '%3$s'", platform.getName(), PROP_VERSION_RELEASE, "build.prop");
                    }
                    return null;
                }
                String stringValue = map.get(PROP_VERSION_SDK);
                if (stringValue == null) {
                    if (log != null) {
                        log.error(null, "Ignoring platform '%1$s': %2$s is missing from '%3$s'", platform.getName(), PROP_VERSION_SDK, "build.prop");
                    }
                    return null;
                }
                try {
                    apiNumber = Integer.parseInt(stringValue);
                }
                catch (NumberFormatException e) {
                    if (log != null) {
                        log.error(null, "Ignoring platform '%1$s': %2$s is not a valid number in %3$s.", platform.getName(), PROP_VERSION_SDK, "build.prop");
                    }
                    return null;
                }
                String apiCodename = map.get(PROP_VERSION_CODENAME);
                if (apiCodename != null && apiCodename.equals("REL")) {
                    apiCodename = null;
                }
                int revision = 1;
                if (!SdkManager.checkPlatformContent(platform, log)) {
                    return null;
                }
                PlatformTarget target = new PlatformTarget(platform.getAbsolutePath(), map, apiNumber, apiCodename, apiName, revision);
                String[] skins = SdkManager.parseSkinFolder(target.getPath(5));
                target.setSkins(skins);
                return target;
            }
        } else if (log != null) {
            log.error(null, "Ignoring platform '%1$s': %2$s is missing.", platform.getName(), "build.prop");
        }
        return null;
    }

    private static void loadAddOns(String location, ArrayList<IAndroidTarget> list, ISdkLog log) {
        File addonFolder = new File(location, "add-ons");
        if (addonFolder.isDirectory()) {
            File[] addons;
            for (File addon : addons = addonFolder.listFiles()) {
                AddOnTarget target;
                if (!addon.isDirectory() || (target = SdkManager.loadAddon(addon, list, log)) == null) continue;
                list.add(target);
            }
            return;
        }
        String message = null;
        message = !addonFolder.exists() ? "%s is missing." : "%s is not a folder.";
        throw new IllegalArgumentException(String.format(message, addonFolder.getAbsolutePath()));
    }

    private static AddOnTarget loadAddon(File addon, ArrayList<IAndroidTarget> targetList, ISdkLog log) {
        File addOnManifest = new File(addon, "manifest.ini");
        if (addOnManifest.isFile()) {
            Map<String, String> propertyMap = SdkManager.parsePropertyFile(addOnManifest, log);
            if (propertyMap != null) {
                int usbVendorId;
                String[] libraries;
                String name = propertyMap.get(ADDON_NAME);
                if (name == null) {
                    SdkManager.displayAddonManifestError(log, addon.getName(), ADDON_NAME);
                    return null;
                }
                String vendor = propertyMap.get(ADDON_VENDOR);
                if (vendor == null) {
                    SdkManager.displayAddonManifestError(log, addon.getName(), ADDON_VENDOR);
                    return null;
                }
                String api = propertyMap.get(ADDON_API);
                PlatformTarget baseTarget = null;
                if (api == null) {
                    SdkManager.displayAddonManifestError(log, addon.getName(), ADDON_API);
                    return null;
                }
                for (IAndroidTarget target : targetList) {
                    if (!target.isPlatform() || !target.getVersion().equals(api)) continue;
                    baseTarget = (PlatformTarget)target;
                    break;
                }
                if (baseTarget == null) {
                    if (log != null) {
                        log.error(null, "Ignoring add-on '%1$s': Unable to find base platform with API level '%2$s'", addon.getName(), api);
                    }
                    return null;
                }
                String description = propertyMap.get(ADDON_DESCRIPTION);
                int revisionValue = 1;
                String revision = propertyMap.get(ADDON_REVISION);
                if (revision == null) {
                    revision = propertyMap.get(ADDON_REVISION_OLD);
                }
                if (revision != null) {
                    try {
                        revisionValue = Integer.parseInt(revision);
                    }
                    catch (NumberFormatException e) {
                        if (log != null) {
                            log.error(null, "Ignoring add-on '%1$s': %2$s is not a valid number in %3$s.", addon.getName(), ADDON_REVISION, "build.prop");
                        }
                        return null;
                    }
                }
                String librariesValue = propertyMap.get(ADDON_LIBRARIES);
                HashMap<String, String[]> libMap = null;
                if (librariesValue != null && (librariesValue = librariesValue.trim()).length() > 0 && (libraries = librariesValue.split(";")).length > 0) {
                    libMap = new HashMap<String, String[]>();
                    for (String libName : libraries) {
                        String libData = propertyMap.get(libName = libName.trim());
                        if (libData != null) {
                            Matcher m = PATTERN_LIB_DATA.matcher(libData);
                            if (m.matches()) {
                                libMap.put(libName, new String[]{m.group(1), m.group(2)});
                                continue;
                            }
                            if (log == null) continue;
                            log.error(null, "Ignoring library '%1$s', property value has wrong format\n\t%2$s", libName, libData);
                            continue;
                        }
                        if (log == null) continue;
                        log.error(null, "Ignoring library '%1$s', missing property value", libName, libData);
                    }
                }
                AddOnTarget target = new AddOnTarget(addon.getAbsolutePath(), name, vendor, revisionValue, description, libMap, baseTarget);
                String[] skins = SdkManager.parseSkinFolder(target.getPath(5));
                String defaultSkin = propertyMap.get(ADDON_DEFAULT_SKIN);
                if (defaultSkin == null) {
                    defaultSkin = skins.length == 1 ? skins[0] : baseTarget.getDefaultSkin();
                }
                if ((usbVendorId = SdkManager.convertId(propertyMap.get(ADDON_USB_VENDOR))) != 0) {
                    target.setUsbVendorId(usbVendorId);
                }
                target.setSkins(skins, defaultSkin);
                return target;
            }
        } else if (log != null) {
            log.error(null, "Ignoring add-on '%1$s': %2$s is missing.", addon.getName(), "manifest.ini");
        }
        return null;
    }

    private static int convertId(String value) {
        if (value != null && value.length() > 0 && PATTERN_USB_IDS.matcher(value).matches()) {
            String v = value.substring(2);
            try {
                return Integer.parseInt(v, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static void displayAddonManifestError(ISdkLog log, String addonName, String valueName) {
        if (log != null) {
            log.error(null, "Ignoring add-on '%1$s': '%2$s' is missing from %3$s.", addonName, valueName, "manifest.ini");
        }
    }

    private static boolean checkPlatformContent(File platform, ISdkLog log) {
        for (String relativePath : sPlatformContentList) {
            File f = new File(platform, relativePath);
            if (f.exists()) continue;
            log.error(null, "Ignoring platform '%1$s': %2$s is missing.", platform.getName(), relativePath);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> parsePropertyFile(File buildProp, ISdkLog log) {
        FileInputStream fis = null;
        BufferedReader reader = null;
        try {
            fis = new FileInputStream(buildProp);
            reader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            String line = null;
            HashMap<String, String> map = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                Matcher m = PATTERN_PROP.matcher(line);
                if (!m.matches()) {
                    log.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", buildProp.getAbsolutePath(), line);
                    Map<String, String> map2 = null;
                    return map2;
                }
                map.put(m.group(1), m.group(2));
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            if (log != null) {
                log.warning("Error parsing '%1$s': %2$s.", buildProp.getAbsolutePath(), e.getMessage());
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private static String[] parseSkinFolder(String osPath) {
        File skinRootFolder = new File(osPath);
        if (skinRootFolder.isDirectory()) {
            File[] files;
            ArrayList<String> skinList = new ArrayList<String>();
            for (File skinFolder : files = skinRootFolder.listFiles()) {
                File layout;
                if (!skinFolder.isDirectory() || !(layout = new File(skinFolder, "layout")).isFile()) continue;
                skinList.add(skinFolder.getName());
            }
            return skinList.toArray(new String[skinList.size()]);
        }
        return new String[0];
    }
}

