/*
 * Decompiled with CFR 0.152.
 */
package com.google.map;

import com.google.map.MapPoint;
import com.google.map.Zoom;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MapState {
    private final MapPoint centerPoint;
    private final Zoom zoom;
    private final boolean isSatellite;

    public MapState(MapPoint mapPoint, Zoom zoom, boolean bl) {
        this.centerPoint = mapPoint;
        this.zoom = zoom;
        this.isSatellite = bl;
    }

    public MapPoint getCenterPoint() {
        return this.centerPoint;
    }

    public Zoom getZoom() {
        return this.zoom;
    }

    public boolean isSatellite() {
        return this.isSatellite;
    }

    public MapState newMapState(MapPoint mapPoint) {
        return new MapState(mapPoint, this.zoom, this.isSatellite);
    }

    public MapState newMapState(Zoom zoom) {
        return new MapState(this.centerPoint, zoom, this.isSatellite);
    }

    public MapState toggleTileMode() {
        return new MapState(this.centerPoint, this.zoom, !this.isSatellite);
    }

    public static MapState read(DataInput dataInput) throws IOException {
        return new MapState(MapPoint.readPoint(dataInput), Zoom.getZoom(dataInput.readInt()), dataInput.readBoolean());
    }

    public static void write(MapState mapState, DataOutput dataOutput) throws IOException {
        if (mapState != null) {
            MapPoint.writePoint(mapState.getCenterPoint(), dataOutput);
            dataOutput.writeInt(mapState.getZoom().getZoomLevel());
            dataOutput.writeBoolean(mapState.isSatellite());
        }
    }
}

