/*
 * Decompiled with CFR 0.152.
 */
package com.google.image.compression.jpeg;

import com.google.image.compression.jpeg.JpegHeaderParams;
import com.google.image.compression.jpeg.JpegUtil;

public class AnalyzeJpegHeader {
    private static final byte[][] JPEG_HUFFMAN_TABLES = new byte[][]{{0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125, 1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, -127, -111, -95, 8, 35, 66, -79, -63, 21, 82, -47, -16, 36, 51, 98, 114, -126, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6}, {0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119, 0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, -127, 8, 20, 66, -111, -95, -79, -63, 9, 35, 51, 82, -16, 21, 98, 114, -47, 10, 22, 36, 52, -31, 37, -15, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -126, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -30, -29, -28, -27, -26, -25, -24, -23, -22, -14, -13, -12, -11, -10, -9, -8, -7, -6}};
    private static final byte[] JPEG_QUANT_56_TO_QUALITY = new byte[1024];

    private AnalyzeJpegHeader() {
    }

    private static int getQualityFromQTable(byte[] byArray, int n, int n2, int n3) {
        int n4 = byArray[n + 56] & 0xFF;
        int n5 = 512 * n2 + 256 * n3 + n4;
        byte by = JPEG_QUANT_56_TO_QUALITY[n5];
        if (by == 0) {
            return -(n2 + 1);
        }
        byte[] byArray2 = JpegUtil.getQuantTable(n2, by, n3);
        for (int i = 0; i < 64; ++i) {
            if (byArray2[i] == byArray[n + i]) continue;
            return -(n2 + 1);
        }
        return by;
    }

    public static JpegHeaderParams analyze(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean[] blArray = new boolean[2];
        boolean[] blArray2 = new boolean[4];
        int n6 = -1;
        int n7 = -1;
        int n8 = n;
        int n9 = n + n2;
        if (byArray[n] != -1 || byArray[n + 1] != -40) {
            throw new IllegalStateException("Data must start with 0xff 0xd8");
        }
        n += 2;
        nArray[0] = -1;
        nArray[1] = -2;
        nArray2[0] = -1;
        nArray2[1] = -2;
        boolean bl4 = false;
        block8: while (!bl4 && n < n9) {
            if (byArray[n++] != -1) {
                throw new IllegalStateException("Expected a marker byte 0xff at offset " + (n - 1));
            }
            switch (byArray[n++]) {
                case -32: {
                    n5 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
                    bl = true;
                    n += n5;
                    continue block8;
                }
                case -37: {
                    n4 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
                    if (n4 != 67) {
                        throw new IllegalStateException("Expected length 67 for DQT marker, got " + n4);
                    }
                    n += 2;
                    if ((n3 = byArray[n++]) != 0 && n3 != 1) {
                        throw new IllegalStateException("Expected quant type 0 or 1, got " + n3);
                    }
                    nArray[n3] = AnalyzeJpegHeader.getQualityFromQTable(byArray, n, n3, 0);
                    nArray2[n3] = AnalyzeJpegHeader.getQualityFromQTable(byArray, n, n3, 1);
                    n += 64;
                    if (nArray[n3] < 0 && nArray2[n3] < 0) {
                        throw new IllegalStateException("Couldn't compact DQT table " + n3);
                    }
                    blArray[n3] = true;
                    continue block8;
                }
                case -64: {
                    byte by;
                    int n10 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
                    if (n10 != 17) {
                        throw new IllegalStateException("Expected length 17 for SOF marker, got " + n10);
                    }
                    n += 2;
                    if ((by = byArray[n++]) != 8) {
                        throw new IllegalStateException("SOF marker: expected bit depth 8, got " + by);
                    }
                    n7 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
                    n6 = (byArray[n += 2] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
                    if (byArray[n += 2] != 3 || byArray[n + 1] != 1 || byArray[n + 2] != 34 || byArray[n + 3] != 0 || byArray[n + 4] != 2 || byArray[n + 5] != 17 || byArray[n + 6] != 1 || byArray[n + 7] != 3 || byArray[n + 8] != 17 || byArray[n + 9] != 1) {
                        throw new IllegalStateException("Expected 4:2:0 subsampling");
                    }
                    n += 10;
                    bl2 = true;
                    continue block8;
                }
                case -60: {
                    int n11;
                    int n12 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
                    n += 2;
                    byte by = byArray[n++];
                    int n13 = by >> 4;
                    int n14 = by & 0xF;
                    byte[] byArray2 = JPEG_HUFFMAN_TABLES[2 * n13 + n14];
                    int n15 = byArray2.length;
                    if (n12 != n15 + 3) {
                        throw new IllegalStateException("Expected length " + (n15 + 3) + " for DHT marker");
                    }
                    for (n11 = 0; n11 < n15; ++n11) {
                        if (byArray2[n11] == byArray[n++]) continue;
                        throw new IllegalStateException("Found unexpected Huffman table value");
                    }
                    blArray2[2 * n13 + n14] = true;
                    continue block8;
                }
                case -38: {
                    if (byArray[n] != 0 || byArray[n + 1] != 12 || byArray[n + 2] != 3 || byArray[n + 3] != 1 || byArray[n + 4] != 0 || byArray[n + 5] != 2 || byArray[n + 6] != 17 || byArray[n + 7] != 3 || byArray[n + 8] != 17 || byArray[n + 9] != 0 || byArray[n + 10] != 63 || byArray[n + 11] != 0) {
                        throw new IllegalStateException("Found unexpected value in SOS marker");
                    }
                    bl3 = true;
                    bl4 = true;
                    continue block8;
                }
                case -2: {
                    int n11 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
                    n += n11;
                    continue block8;
                }
            }
            throw new IllegalStateException("Found an unknown marker at offset " + (n - 2));
        }
        if (!bl) {
            throw new IllegalStateException("Didn't find JFIF marker");
        }
        if (!bl3) {
            throw new IllegalStateException("Didn't find SOS marker");
        }
        if (!bl2) {
            throw new IllegalStateException("Didn't find SOF marker");
        }
        if (!blArray[0]) {
            throw new IllegalStateException("Didn't find luminance quantization table");
        }
        if (!blArray[1]) {
            throw new IllegalStateException("Didn't find chrominance quantization table");
        }
        for (n5 = 0; n5 < 4; ++n5) {
            if (blArray2[n5]) continue;
            throw new IllegalStateException("Didn't find Huffman table " + n5);
        }
        if (n6 < 0 || n7 < 0) {
            throw new IllegalStateException("Image width or eight is negative");
        }
        if (nArray[0] == nArray[1]) {
            n5 = nArray[0];
            n4 = 0;
        } else if (nArray2[0] == nArray2[1]) {
            n5 = nArray2[0];
            n4 = 1;
        } else {
            throw new IllegalStateException("Unable to determine quality parameter");
        }
        n3 = n - n8 + 12;
        return new JpegHeaderParams(0, n6, n7, n5, n4, n3);
    }

    static {
        for (int i = 0; i <= 1; ++i) {
            for (int j = 0; j <= 1; ++j) {
                int n = JpegUtil.getQuantizationTableEntry(i, 56) & 0xFF;
                for (int k = 24; k <= 100; ++k) {
                    int n2 = JpegUtil.getScaledQuantizationFactor(n, k, j) & 0xFF;
                    int n3 = 512 * i + 256 * j + n2;
                    AnalyzeJpegHeader.JPEG_QUANT_56_TO_QUALITY[n3] = (byte)k;
                }
            }
        }
    }
}

