/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.ui;

import com.google.googlenav.ui.RenderableEllipse;
import com.google.googlenav.ui.RenderablePoly;
import com.google.googlenav.ui.RenderableShape;
import com.google.map.MapPoint;
import com.google.map.Zoom;

public class ShapeRenderer {
    protected static final int MAX_RANGE = 4000;
    private final RenderableShape[] shapes;
    private Zoom pixelZoom;
    private long[][][] polyBoundaryPixelXY;

    public ShapeRenderer(RenderableShape[] renderableShapeArray) {
        if (renderableShapeArray == null || renderableShapeArray.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < renderableShapeArray.length; ++i) {
            if (renderableShapeArray[i] != null) continue;
            throw new IllegalArgumentException();
        }
        this.shapes = renderableShapeArray;
        this.pixelZoom = null;
    }

    public int getImageVersion() {
        int n = 0;
        for (int i = 0; i < this.shapes.length; ++i) {
            if (!this.shapes[i].isAvailable()) {
                return 0;
            }
            n = n * 29 + this.shapes[i].getId();
        }
        return n;
    }

    public long[] getShapeXY(RenderableShape renderableShape, Zoom zoom) {
        this.precalculatePixels(zoom);
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] != renderableShape) continue;
            return this.polyBoundaryPixelXY[i][0];
        }
        return null;
    }

    public RenderableShape[] getShapes() {
        return this.shapes;
    }

    private void precalculatePixels(Zoom zoom) {
        if (zoom == this.pixelZoom) {
            return;
        }
        this.polyBoundaryPixelXY = new long[this.shapes.length][][];
        for (int i = 0; i < this.shapes.length; ++i) {
            if (!(this.shapes[i] instanceof RenderablePoly)) continue;
            RenderablePoly renderablePoly = (RenderablePoly)this.shapes[i];
            int n = ShapeRenderer.getBoundaryCount(renderablePoly);
            this.polyBoundaryPixelXY[i] = new long[n][];
            MapPoint[][] mapPointArray = ShapeRenderer.getBoundaries(renderablePoly);
            for (int j = 0; j < n; ++j) {
                MapPoint[] mapPointArray2 = mapPointArray[j];
                long[] lArray = new long[mapPointArray2.length];
                int n2 = 1;
                this.pixelZoom = zoom;
                lArray[0] = ShapeRenderer.getXY(mapPointArray2[0].getXPixel(this.pixelZoom), mapPointArray2[0].getYPixel(this.pixelZoom));
                for (int k = 1; k < mapPointArray2.length; ++k) {
                    int n3 = mapPointArray2[k].getXPixel(this.pixelZoom);
                    int n4 = mapPointArray2[k].getYPixel(this.pixelZoom);
                    if (Math.abs(n3 - ShapeRenderer.getX(lArray[n2 - 1])) <= 2 && Math.abs(n4 - ShapeRenderer.getY(lArray[n2 - 1])) <= 2 && k != mapPointArray2.length - 1) continue;
                    lArray[n2] = ShapeRenderer.getXY(n3, n4);
                    ++n2;
                }
                this.polyBoundaryPixelXY[i][j] = new long[n2];
                System.arraycopy(lArray, 0, this.polyBoundaryPixelXY[i][j], 0, n2);
            }
        }
    }

    private static int outcode(int n, int n2, int n3, int n4) {
        return (n3 < 0 ? 8 : (n3 > n ? 4 : 0)) | (n4 < 0 ? 2 : (n4 > n2 ? 1 : 0));
    }

    public void render(Painter painter, int n, int n2, int n3, int n4, Zoom zoom) {
        if (this.getImageVersion() == 0) {
            return;
        }
        this.precalculatePixels(zoom);
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] instanceof RenderableEllipse) {
                this.renderEllipse(painter, n, n2, n3, n4, (RenderableEllipse)this.shapes[i], zoom);
                continue;
            }
            RenderablePoly renderablePoly = (RenderablePoly)this.shapes[i];
            if (this.shapes[i].isFilled()) {
                this.renderPolygonFill(painter, n, n2, n3, n4, this.polyBoundaryPixelXY[i], renderablePoly, zoom);
            } else {
                for (int j = 0; j < this.polyBoundaryPixelXY[i].length; ++j) {
                    this.renderLine(painter, n, n2, n3, n4, this.polyBoundaryPixelXY[i][j], renderablePoly, zoom);
                }
            }
            this.renderDirectionsDiamonds(painter, n, n2, zoom, renderablePoly);
        }
    }

    private void renderEllipse(Painter painter, int n, int n2, int n3, int n4, RenderableEllipse renderableEllipse, Zoom zoom) {
        int n5;
        int n6;
        if (renderableEllipse.getLineColor() == -1 && renderableEllipse.getFillColor() == -1) {
            return;
        }
        MapPoint mapPoint = renderableEllipse.getCenter();
        int n7 = zoom.getPixelsForDistance(renderableEllipse.getEllipseWidth());
        int n8 = zoom.getPixelsForDistance(renderableEllipse.getEllipseHeight());
        int n9 = mapPoint.getXPixel(zoom) - n;
        int n10 = ShapeRenderer.outcode(n3, n4, n9 - n7 / 2, (n6 = mapPoint.getYPixel(zoom) - n2) - n8 / 2);
        if ((n10 & (n5 = ShapeRenderer.outcode(n3, n4, n9 + n7 / 2, n6 + n8 / 2))) == 0) {
            painter.paintEllipse(n9, n6, n7, n8, renderableEllipse.getLineWidthForZoom(zoom), renderableEllipse.getLineColor(), renderableEllipse.getFillColor());
        }
    }

    protected static int[] makeInRange(int n, int n2, int n3, int n4) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        if (n > 4000 || n < -4000) {
            n = n > 0 ? 4000 : -4000;
            n2 = n4 + (int)((long)(n - n3) * (long)n6 / (long)n5);
        }
        if (n2 > 4000 || n2 < -4000) {
            n2 = n6 + n4;
            n2 = n2 > 0 ? 4000 : -4000;
            n = n3 + (int)((long)(n2 - n4) * (long)n5 / (long)n6);
        }
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    protected static boolean isInRange(int[] nArray) {
        return nArray[0] <= 4000 && nArray[0] >= -4000 && nArray[1] <= 4000 && nArray[1] >= -4000;
    }

    private void renderLine(Painter painter, int n, int n2, int n3, int n4, long[] lArray, RenderablePoly renderablePoly, Zoom zoom) {
        int[] nArray = new int[2];
        int[] nArray2 = new int[]{ShapeRenderer.getX(lArray[0]) - n, ShapeRenderer.getY(lArray[0]) - n2};
        int n5 = ShapeRenderer.outcode(n3, n4, nArray2[0], nArray2[1]);
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 1; i < lArray.length; ++i) {
            nArray[0] = ShapeRenderer.getX(lArray[i]) - n;
            int n6 = ShapeRenderer.outcode(n3, n4, nArray[0], nArray[1] = ShapeRenderer.getY(lArray[i]) - n2);
            if ((n5 & n6) == 0) {
                if (!bl2) {
                    painter.startLine(renderablePoly.getLineColor(), renderablePoly.getLineWidthForZoom(zoom), renderablePoly.getLineStyle());
                    bl2 = true;
                }
                int[] nArray3 = null;
                boolean bl3 = ShapeRenderer.isInRange(nArray);
                if (!bl3) {
                    nArray3 = ShapeRenderer.makeInRange(nArray[0], nArray[1], nArray2[0], nArray2[1]);
                }
                if (!ShapeRenderer.isInRange(nArray2)) {
                    nArray2 = ShapeRenderer.makeInRange(nArray2[0], nArray2[1], nArray[0], nArray[1]);
                }
                if (bl3) {
                    painter.addLineSegment(nArray, nArray2, bl);
                } else {
                    painter.addLineSegment(nArray3, nArray2, bl);
                }
                bl = !bl3;
            } else {
                bl = true;
            }
            nArray2[0] = nArray[0];
            nArray2[1] = nArray[1];
            n5 = n6;
        }
        if (bl2) {
            painter.endLine();
        }
    }

    private void renderDirectionsDiamonds(Painter painter, int n, int n2, Zoom zoom, RenderablePoly renderablePoly) {
        MapPoint[] mapPointArray = renderablePoly.getMarkedVertices();
        if (mapPointArray != null) {
            // empty if block
        }
    }

    private void renderPolygonFill(Painter painter, int n, int n2, int n3, int n4, long[][] lArray, RenderablePoly renderablePoly, Zoom zoom) {
        int n5;
        int n6;
        boolean bl = false;
        int n7 = ShapeRenderer.getBoundaryCount(renderablePoly);
        long[][] lArrayArray = new long[n7][];
        lArrayArray[0] = ShapeRenderer.getPixelXYOnScreen(n, n2, lArray[0]);
        int n8 = n6 = ShapeRenderer.outcode(n3, n4, ShapeRenderer.getX(lArrayArray[0][0]), ShapeRenderer.getY(lArrayArray[0][0]));
        for (n5 = 1; n5 < lArrayArray[0].length; ++n5) {
            int n9 = ShapeRenderer.outcode(n3, n4, ShapeRenderer.getX(lArrayArray[0][n5]), ShapeRenderer.getY(lArrayArray[0][n5]));
            if ((n6 & n9) == 0) {
                bl = true;
                break;
            }
            n8 |= n9;
            n6 = n9;
        }
        if (n8 == 15) {
            bl = true;
        }
        if (bl) {
            for (n5 = 1; n5 < n7; ++n5) {
                lArrayArray[n5] = ShapeRenderer.getPixelXYOnScreen(n, n2, lArray[n5]);
            }
            painter.paintPolygon(lArrayArray, renderablePoly.getLineColor(), renderablePoly.getLineWidthForZoom(zoom), renderablePoly.getFillColor());
        }
    }

    private static long[] getPixelXYOnScreen(int n, int n2, long[] lArray) {
        long[] lArray2 = new long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray2[i] = ShapeRenderer.getXY(ShapeRenderer.getX(lArray[i]) - n, ShapeRenderer.getY(lArray[i]) - n2);
        }
        return lArray2;
    }

    private static int getBoundaryCount(RenderablePoly renderablePoly) {
        if (renderablePoly.getInnerBoundaries() == null) {
            return 1;
        }
        return 1 + renderablePoly.getInnerBoundaries().length;
    }

    private static MapPoint[][] getBoundaries(RenderablePoly renderablePoly) {
        if (renderablePoly.getInnerBoundaries() == null) {
            return new MapPoint[][]{renderablePoly.getLine()};
        }
        MapPoint[][] mapPointArray = new MapPoint[ShapeRenderer.getBoundaryCount(renderablePoly)][];
        mapPointArray[0] = renderablePoly.getLine();
        for (int i = 1; i < mapPointArray.length; ++i) {
            mapPointArray[i] = renderablePoly.getInnerBoundaries()[i - 1];
        }
        return mapPointArray;
    }

    public static long getXY(int n, int n2) {
        long l = (long)n << 32;
        long l2 = (long)n2 << 32 >>> 32;
        return l | l2;
    }

    public static int getX(long l) {
        return (int)(l >> 32);
    }

    public static int getY(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    public static interface Painter {
        public void startLine(int var1, int var2, int var3);

        public void endLine();

        public void addLineSegment(int[] var1, int[] var2, boolean var3);

        public void paintVertex(int var1, int var2, int var3, int var4);

        public void paintPolygon(long[][] var1, int var2, int var3, int var4);

        public void paintEllipse(int var1, int var2, int var3, int var4, int var5, int var6, int var7);
    }
}

