/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.ui;

import com.google.common.Config;
import com.google.common.graphics.GoogleImage;
import com.google.googlenav.map.Map;
import com.google.googlenav.map.MapTile;
import com.google.googlenav.map.Tile;
import com.google.googlenav.map.TrafficRenderer;
import com.google.googlenav.map.TrafficService;
import com.google.googlenav.map.TrafficTile;
import com.google.googlenav.ui.GmmTileOverlayRenderer;
import com.google.googlenav.ui.RenderableShape;
import com.google.googlenav.ui.ShapeRenderer;
import java.util.Vector;

public abstract class GmmTileOverlayRendererImpl
implements GmmTileOverlayRenderer {
    protected TrafficService trafficService;
    private boolean showTraffic = false;
    protected ShapeRenderer shapeRenderer;
    private int shapeRendererVersion;
    protected final TrafficRenderer trafficRenderer;
    private final Vector shapeProviders = new Vector();

    public GmmTileOverlayRendererImpl() {
        this.trafficRenderer = new TrafficRenderer();
    }

    public void setTrafficService(TrafficService trafficService) {
        this.trafficService = trafficService;
    }

    public void begin() {
        this.shapeRendererVersion = this.shapeRenderer != null ? this.shapeRenderer.getImageVersion() : 0;
    }

    public boolean isShowTraffic() {
        return this.showTraffic;
    }

    public boolean isTrafficDataComplete(Map map) {
        Tile[] tileArray = map.getTiles();
        if (tileArray == null) {
            return false;
        }
        for (int i = 0; i < tileArray.length; ++i) {
            TrafficTile trafficTile = this.trafficService.getTile(this.getTrafficTileLocation(tileArray[i]), false);
            if (trafficTile != null && trafficTile.isComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean checkNoTrafficData(Map map) {
        Tile[] tileArray = map.getTiles();
        if (tileArray == null) {
            return true;
        }
        for (int i = 0; i < tileArray.length; ++i) {
            TrafficTile trafficTile = this.trafficService.getTile(this.getTrafficTileLocation(tileArray[i]), false);
            if (trafficTile != null && trafficTile.isComplete() && (trafficTile.isEmpty() || trafficTile.getDataTime() == Long.MIN_VALUE)) continue;
            return false;
        }
        return true;
    }

    public void setShowTraffic(boolean bl) {
        this.showTraffic = bl;
    }

    public boolean renderTile(MapTile mapTile, boolean bl) {
        return this.renderTileImage(mapTile, bl);
    }

    public void end() {
        this.trafficService.requestTiles();
    }

    private boolean renderTileImage(MapTile mapTile, boolean bl) {
        TrafficTile trafficTile = null;
        Tile tile = mapTile.getLocation();
        if (this.showTraffic && tile.getZoom().getZoomLevel() >= 9 && tile.getZoom().getZoomLevel() <= 19) {
            tile = this.getTrafficTileLocation(mapTile.getLocation());
            trafficTile = this.trafficService.getTile(tile, bl);
        }
        int n = this.getImageVersion(mapTile);
        if ((this.isFast() || mapTile.hasImage()) && !mapTile.hasScaledImage() && mapTile.getImageVersion() != n) {
            this.updateTileImage(mapTile, trafficTile, n);
            return true;
        }
        return false;
    }

    private void updateTileImage(MapTile mapTile, TrafficTile trafficTile, int n) {
        if ((trafficTile != null || this.shapeRenderer != null) && mapTile.getImageVersion() == 0) {
            GoogleImage googleImage;
            if (trafficTile != null && !trafficTile.isComplete()) {
                trafficTile = null;
            }
            if ((googleImage = this.generateNewTileImage(mapTile, trafficTile)) == null) {
                mapTile.setImage(mapTile.getImage(), n);
            } else {
                mapTile.setImage(googleImage, n);
            }
        } else if (mapTile.getImageVersion() != 0 && mapTile.getImageVersion() != n) {
            mapTile.restoreBaseImage();
            mapTile.getImage();
        }
    }

    protected abstract GoogleImage generateNewTileImage(MapTile var1, TrafficTile var2);

    private int getImageVersion(MapTile mapTile) {
        TrafficTile trafficTile;
        int n = 0;
        if (this.showTraffic && (trafficTile = this.trafficService.getTile(this.getTrafficTileLocation(mapTile.getLocation()), false)) != null && trafficTile.isComplete()) {
            if (!trafficTile.isEmpty()) {
                n = (int)trafficTile.getDataTime();
            }
            trafficTile.setLastAccess(Config.getInstance().getClock().relativeTimeMillis());
        }
        return n * 29 + this.shapeRendererVersion;
    }

    public void close() {
        this.trafficService.close();
    }

    private Tile getTrafficTileLocation(Tile tile) {
        return Tile.getTile((byte)4, tile);
    }

    protected abstract boolean isFast();

    public ShapeRenderer getShapeRenderer() {
        return this.shapeRenderer;
    }

    public void refresh() {
        RenderableShape[][] renderableShapeArrayArray = new RenderableShape[this.shapeProviders.size()][];
        int n = 0;
        int n2 = this.shapeProviders.size();
        for (int i = 0; i < n2; ++i) {
            RenderableShape[] renderableShapeArray = ((GmmTileOverlayRenderer.ShapeProvider)this.shapeProviders.elementAt(i)).getShapes();
            if (renderableShapeArray == null) continue;
            int n3 = 0;
            int n4 = renderableShapeArray.length;
            for (int j = 0; j < n4; ++j) {
                if (renderableShapeArray[j] == null) continue;
                ++n3;
            }
            if (renderableShapeArray.length != n3) {
                RenderableShape[] renderableShapeArray2 = new RenderableShape[n3];
                n4 = 0;
                int n5 = renderableShapeArray.length;
                for (int j = 0; j < n5; ++j) {
                    if (renderableShapeArray[j] == null) continue;
                    renderableShapeArray2[n4++] = renderableShapeArray[j];
                }
                renderableShapeArray = renderableShapeArray2;
            }
            renderableShapeArrayArray[i] = renderableShapeArray;
            n += renderableShapeArray.length;
        }
        if (n == 0) {
            this.shapeRenderer = null;
            return;
        }
        RenderableShape[] renderableShapeArray = new RenderableShape[n];
        n2 = 0;
        for (int i = 0; i < renderableShapeArrayArray.length; ++i) {
            if (renderableShapeArrayArray[i] == null) continue;
            System.arraycopy(renderableShapeArrayArray[i], 0, renderableShapeArray, n2, renderableShapeArrayArray[i].length);
            n2 += renderableShapeArrayArray[i].length;
        }
        this.shapeRenderer = new ShapeRenderer(renderableShapeArray);
    }

    public void addShapeProvider(GmmTileOverlayRenderer.ShapeProvider shapeProvider) {
        this.shapeProviders.addElement(shapeProvider);
    }

    public void removeShapeProvider(GmmTileOverlayRenderer.ShapeProvider shapeProvider) {
        this.shapeProviders.removeElement(shapeProvider);
    }
}

