/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Clock;
import com.google.common.Config;
import com.google.common.Log;
import com.google.common.OutOfMemoryHandler;
import com.google.common.StaticUtil;
import com.google.common.util.RuntimeCheck;
import com.google.googlenav.datarequest.DataRequestDispatcher;
import com.google.googlenav.map.BaseTileRequest;
import com.google.googlenav.map.Tile;
import com.google.googlenav.map.TrafficReading;
import com.google.googlenav.map.TrafficTile;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TrafficService
implements Runnable,
OutOfMemoryHandler {
    public static final int MIN_TRAFFIC_ZOOM = 9;
    public static final int MAX_TRAFFIC_ZOOM = 19;
    private volatile TrafficTileRequest request;
    private final Hashtable cache;
    private final Hashtable requestedTiles;
    private final long refreshMillis;
    private static final long CLEAN_CACHE_TIME = 20113L;
    private static final long MAX_TILE_AGE = 60000L;
    private final Object indefiniteThreadLockObject = new Object();
    private final Object timedThreadLockObject = new Object();
    private volatile boolean exitWorkThread = true;
    private long nextRefreshTime;
    private Thread thread;

    public TrafficService(int n) {
        this.refreshMillis = n;
        this.nextRefreshTime = Long.MIN_VALUE;
        this.cache = new Hashtable();
        this.requestedTiles = new Hashtable();
        StaticUtil.registerOutOfMemoryHandler((OutOfMemoryHandler)this);
        this.start();
    }

    public void close() {
        StaticUtil.removeOutOfMemoryHandler((OutOfMemoryHandler)this);
        this.stop();
    }

    public synchronized TrafficTile getTile(Tile tile, boolean bl) {
        if (tile.getZoom().getZoomLevel() > 19) {
            return null;
        }
        TrafficTile trafficTile = (TrafficTile)this.cache.get(tile);
        TrafficTile trafficTile2 = (TrafficTile)this.requestedTiles.get(tile);
        if (trafficTile != null) {
            Clock clock = Config.getInstance().getClock();
            long l = trafficTile.getDataTime();
            long l2 = clock.relativeTimeMillis() - l;
            if (bl && trafficTile2 == null && l != Long.MIN_VALUE && l2 > this.refreshMillis / 2L && (clock.relativeTimeMillis() > this.nextRefreshTime || this.request != null)) {
                this.requestTile(tile, trafficTile);
            }
            return trafficTile;
        }
        if (trafficTile2 != null) {
            return trafficTile2;
        }
        trafficTile = new TrafficTile(tile);
        if (bl) {
            this.requestTile(tile, trafficTile);
        }
        return trafficTile;
    }

    private synchronized void requestTile(Tile tile, TrafficTile trafficTile) {
        if (this.request == null) {
            this.request = new TrafficTileRequest();
        }
        this.request.addTile(trafficTile);
        this.requestedTiles.put(tile, trafficTile);
    }

    public synchronized void requestTiles() {
        if (this.request != null) {
            DataRequestDispatcher.getInstance().addDataRequest(this.request);
            this.request = null;
            this.nextRefreshTime = Config.getInstance().getClock().relativeTimeMillis() + this.refreshMillis;
        }
    }

    synchronized void cleanCache(long l) {
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            Tile tile = (Tile)enumeration.nextElement();
            TrafficTile trafficTile = (TrafficTile)this.cache.get(tile);
            Clock clock = Config.getInstance().getClock();
            if (clock.relativeTimeMillis() - trafficTile.getLastAccess() <= l) continue;
            this.cache.remove(tile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.exitWorkThread) {
            try {
                Object object = this.indefiniteThreadLockObject;
                synchronized (object) {
                    try {
                        this.indefiniteThreadLockObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.exitWorkThread) break;
                object = this.timedThreadLockObject;
                synchronized (object) {
                    try {
                        this.timedThreadLockObject.wait(20113L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.exitWorkThread) break;
                this.cleanCache(60000L);
            }
            catch (Exception exception) {
                Log.logThrowable((String)"TrafficService BG", (Throwable)exception);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                StaticUtil.handleOutOfMemory();
            }
        }
    }

    public void handleOutOfMemory() {
        this.cache.clear();
    }

    public synchronized void start() {
        if (this.exitWorkThread) {
            this.exitWorkThread = false;
            this.thread = new Thread((Runnable)this, "TrafficService");
            this.thread.setPriority(1);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.exitWorkThread = true;
        Object object = this.timedThreadLockObject;
        synchronized (object) {
            this.timedThreadLockObject.notify();
        }
        object = this.indefiniteThreadLockObject;
        synchronized (object) {
            this.indefiniteThreadLockObject.notify();
        }
    }

    Thread getThreadForTest() {
        RuntimeCheck.checkUnitTest();
        return this.thread;
    }

    Object getIndefiniteThreadLockObjectForTest() {
        RuntimeCheck.checkUnitTest();
        return this.indefiniteThreadLockObject;
    }

    private class TrafficTileRequest
    extends BaseTileRequest {
        private final Vector tiles;

        public TrafficTileRequest() {
            super(26);
            this.tiles = new Vector();
        }

        public void writeRequestData(DataOutput dataOutput) throws IOException {
            Tile[] tileArray = new Tile[this.tiles.size()];
            for (int i = 0; i < this.tiles.size(); ++i) {
                tileArray[i] = ((TrafficTile)this.tiles.elementAt(i)).getLocation();
            }
            this.writeRequestForTiles(tileArray, dataOutput);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean processDownloadedTile(int n, Tile tile, byte[] byArray) throws IOException {
            TrafficTile trafficTile = (TrafficTile)TrafficService.this.requestedTiles.get(tile);
            if (trafficTile == null) {
                trafficTile = new TrafficTile(tile);
            } else if (trafficTile.isComplete()) {
                trafficTile = new TrafficTile(tile);
            }
            if (byArray.length == 0) {
                trafficTile.setData(Config.getInstance().getClock().relativeTimeMillis(), new TrafficReading[0][]);
            } else {
                trafficTile.readData(new DataInputStream(new ByteArrayInputStream(byArray)));
            }
            Object object = this;
            synchronized (object) {
                TrafficService.this.cache.put(tile, trafficTile);
                TrafficService.this.requestedTiles.remove(tile);
            }
            object = TrafficService.this.indefiniteThreadLockObject;
            synchronized (object) {
                TrafficService.this.indefiniteThreadLockObject.notify();
            }
            return false;
        }

        protected void setTileEdition(int n) {
        }

        protected void handleEndOfResponse(int n) {
        }

        public void addTile(TrafficTile trafficTile) {
            this.tiles.addElement(trafficTile);
        }
    }
}

