/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Config;
import com.google.common.util.MathUtil;
import com.google.googlenav.map.Tile;
import com.google.googlenav.map.TrafficReading;
import com.google.googlenav.map.TrafficTile;
import com.google.map.Zoom;

public class TrafficRenderer {
    protected static final int FIX_BITS = 8;
    private static final int ROAD_BACKGROUND = -2130706433;
    private static final int RED = 0x30990000;
    private static final int RED_OUTLINE = -1605894144;
    private static final int YELLOW = 1627382784;
    private static final int YELLOW_OUTLINE = 1627372032;
    private static final int GREEN = 1610660864;
    public static final int NO_DATA = 1624363473;
    private static final int NONE = 0xFFFFFF;

    public void renderTrafficTile(TrafficTile trafficTile, TrafficPainter trafficPainter) {
        trafficTile.setLastAccess(Config.getInstance().getClock().relativeTimeMillis());
        TrafficReading[][] trafficReadingArray = trafficTile.getReadings();
        Tile tile = trafficTile.getLocation();
        this.addRoadBackgroundLine(trafficReadingArray, tile.getZoom(), trafficPainter, trafficTile.isRightSideDrive());
        this.addRoadForegroundLine(trafficReadingArray, tile.getZoom(), trafficPainter, trafficTile.isRightSideDrive());
    }

    private void addRoadBackgroundLine(TrafficReading[][] trafficReadingArray, Zoom zoom, TrafficPainter trafficPainter, boolean bl) {
        int n = (zoom.getZoomLevel() > 13 ? 9 : (zoom.getZoomLevel() > 11 ? 8 : (zoom.getZoomLevel() > 9 ? 6 : 5))) << 8;
        Path path = trafficPainter.createPathObject();
        for (int i = 0; i < trafficReadingArray.length; ++i) {
            TrafficReading[] trafficReadingArray2 = trafficReadingArray[i];
            TrafficReading trafficReading = trafficReadingArray2[0];
            this.addPathPoint(path, trafficReading, zoom, false, bl);
            for (int j = 1; j < trafficReadingArray2.length; ++j) {
                this.addPathPoint(path, trafficReading, zoom, !(trafficReading = trafficReadingArray2[j]).isDiscontinuity(), bl);
            }
        }
        trafficPainter.addTrafficLine(path, -2130706433, n);
    }

    private void addRoadForegroundLine(TrafficReading[][] trafficReadingArray, Zoom zoom, TrafficPainter trafficPainter, boolean bl) {
        int n = (zoom.getZoomLevel() > 13 ? 4 : (zoom.getZoomLevel() > 11 ? 3 : (zoom.getZoomLevel() > 9 ? 2 : 2))) << 8;
        for (int i = 0; i < trafficReadingArray.length; ++i) {
            TrafficReading[] trafficReadingArray2 = trafficReadingArray[i];
            TrafficReading trafficReading = trafficReadingArray2[0];
            Path path = this.initPath(trafficPainter, trafficReading, zoom, bl);
            int n2 = this.getColor(trafficReading);
            for (int j = 1; j < trafficReadingArray2.length; ++j) {
                int n3;
                this.addPathPoint(path, trafficReading, zoom, !(trafficReading = trafficReadingArray2[j]).isDiscontinuity(), bl);
                if (trafficReading.isDiscontinuity() || (n3 = this.getColor(trafficReading)) == n2) continue;
                this.createForegroundLine(trafficPainter, path, n2, n);
                path = this.initPath(trafficPainter, trafficReading, zoom, bl);
                n2 = n3;
            }
            this.createForegroundLine(trafficPainter, path, n2, n);
        }
    }

    private void createForegroundLine(TrafficPainter trafficPainter, Path path, int n, int n2) {
        if (n == 1627382784 || n == 0x30990000) {
            int n3 = n == 1627382784 ? 1627372032 : -1605894144;
            trafficPainter.addTrafficLine(path, n3, n2 + 384);
        }
        trafficPainter.addTrafficLine(path, n, n2);
    }

    protected void addPathPoint(Path path, TrafficReading trafficReading, Zoom zoom, boolean bl, boolean bl2) {
        int n = trafficReading.getXOffset() << 8;
        int n2 = trafficReading.getYOffset() << 8;
        int n3 = zoom.getZoomLevel() > 10 ? 5 : 4;
        int n4 = trafficReading.getAzi();
        if (!bl2) {
            n4 += 180;
        }
        n += (n3 << 7) * MathUtil.cos((int)n4) / 250;
        n2 += (n3 << 7) * MathUtil.sin((int)n4) / 250;
        if (bl) {
            path.lineTo(n, n2);
        } else {
            path.moveTo(n, n2);
        }
    }

    protected Path initPath(TrafficPainter trafficPainter, TrafficReading trafficReading, Zoom zoom, boolean bl) {
        Path path = trafficPainter.createPathObject();
        this.addPathPoint(path, trafficReading, zoom, false, bl);
        return path;
    }

    private int getColor(TrafficReading trafficReading) {
        if (trafficReading.isDiscontinuity()) {
            return 0xFFFFFF;
        }
        if (!trafficReading.hasData()) {
            return 1624363473;
        }
        if (trafficReading.getSpeed() < 25) {
            return 0x30990000;
        }
        if (trafficReading.getSpeed() < 50) {
            return 1627382784;
        }
        return 1610660864;
    }

    public static interface TrafficPainter {
        public Path createPathObject();

        public void addTrafficLine(Path var1, int var2, int var3);
    }

    public static interface Path {
        public void lineTo(int var1, int var2);

        public void moveTo(int var1, int var2);
    }
}

