/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.googlenav.map.Tile;
import java.io.DataInput;
import java.io.IOException;

public class TrafficReading {
    private final int speed;
    private final int azi;
    private final Tile tile;
    private final int xOffset;
    private final int yOffset;

    public TrafficReading(Tile tile, int n, int n2, int n3, int n4) {
        this.tile = tile;
        this.xOffset = n;
        this.yOffset = n2;
        if (n4 > 127) {
            throw new IllegalArgumentException("Speed wrong: " + n4);
        }
        if (n3 < 0 || n3 > 360) {
            throw new IllegalArgumentException("Azi wrong: " + n3);
        }
        this.speed = n4;
        this.azi = n3;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getAzi() {
        return this.azi;
    }

    public Tile getTile() {
        return this.tile;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TrafficReading trafficReading = (TrafficReading)object;
        if (this.azi != trafficReading.azi) {
            return false;
        }
        if (this.speed != trafficReading.speed) {
            return false;
        }
        if (this.xOffset != trafficReading.xOffset) {
            return false;
        }
        if (this.yOffset != trafficReading.yOffset) {
            return false;
        }
        return !(this.tile != null ? !this.tile.equals(trafficReading.tile) : trafficReading.tile != null);
    }

    public int hashCode() {
        int n = this.speed;
        n = 31 * n + this.azi;
        n = 31 * n + (this.tile != null ? this.tile.hashCode() : 0);
        n = 31 * n + this.xOffset;
        n = 31 * n + this.yOffset;
        return n;
    }

    public static TrafficReading[] readPath(Tile tile, DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        TrafficReading[] trafficReadingArray = new TrafficReading[n];
        for (int i = 0; i < trafficReadingArray.length; ++i) {
            short s = dataInput.readShort();
            short s2 = dataInput.readShort();
            short s3 = dataInput.readShort();
            byte by = dataInput.readByte();
            trafficReadingArray[i] = new TrafficReading(tile, s, s2, s3, by);
        }
        return trafficReadingArray;
    }

    public boolean isDiscontinuity() {
        return this.speed == -2;
    }

    public boolean hasData() {
        return this.speed >= 0;
    }
}

