/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Config;
import com.google.common.Log;
import com.google.common.OutOfMemoryHandler;
import com.google.common.StaticUtil;
import com.google.common.graphics.GoogleGraphics;
import com.google.common.graphics.GoogleImage;
import com.google.common.ui.RepaintListener;
import com.google.common.util.ArrayUtil;
import com.google.googlenav.Stats;
import com.google.googlenav.datarequest.DataRequestDispatcher;
import com.google.googlenav.map.BaseTileRequest;
import com.google.googlenav.map.FlashRecord;
import com.google.googlenav.map.MapFlashService;
import com.google.googlenav.map.MapTile;
import com.google.googlenav.map.MapTileStorage;
import com.google.googlenav.map.NullMapTileStorage;
import com.google.googlenav.map.Tile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MapService
implements OutOfMemoryHandler,
Runnable {
    final Hashtable mapCache;
    final MapTileStorage flashService;
    private final boolean autoConfigCache;
    private int maxCacheDataSize;
    private int targetCacheDataSize;
    private static final long COMPACT_IMAGE_TIME = 12000L;
    private static final long EMERGENCY_IMAGE_COMPACT_TIME = 2000L;
    private volatile boolean mapCacheLocked;
    private MapTileRequest currentRequest = null;
    public static final int AUTO_CONFIG = -1;
    private final Hashtable tempScaledImages;
    static final long BACKGROUND_THREAD_WAIT_INTERVAL = 250L;
    private static final int MINIMUM_CACHE_SIZE = 25000;
    private static final int MINIMUM_FREE_MEM = 40000;
    private final Object indefiniteThreadLockObject = new Object();
    private final Object timedThreadLockObject = new Object();
    volatile boolean exitWorkThread = true;
    private RepaintListener repaintListener;
    private int requestType = 26;
    private static final long TRIM_TIME = 2101L;
    private static final long COMPACT_TIME = 3113L;
    private long outOfMemoryTime = Long.MIN_VALUE;
    private static final long OUT_OF_MEMORY_RECOVERY_TIME = 10000L;

    void setMapCacheLocked(boolean bl) {
        this.mapCacheLocked = bl;
    }

    MapService(int n, int n2, int n3, int n4, String string) {
        if (n == -1) {
            this.autoConfigCache = true;
            this.maxCacheDataSize = 25000;
            this.setAutoTargetCacheSize();
        } else {
            this.autoConfigCache = false;
            this.maxCacheDataSize = n;
            if (n2 == -1) {
                this.setAutoTargetCacheSize();
            } else {
                this.targetCacheDataSize = n2;
            }
        }
        this.tempScaledImages = new Hashtable();
        this.mapCache = new Hashtable();
        this.mapCacheLocked = false;
        this.flashService = n3 > 0 ? new MapFlashService(this, string, n3, n4) : new NullMapTileStorage();
        this.startWorkThread();
        StaticUtil.registerOutOfMemoryHandler((OutOfMemoryHandler)this);
    }

    void setRepaintListener(RepaintListener repaintListener) {
        this.repaintListener = repaintListener;
    }

    Hashtable getMapCache() {
        return this.mapCache;
    }

    MapTileStorage getMapFlashService() {
        return this.flashService;
    }

    private void setAutoTargetCacheSize() {
        this.targetCacheDataSize = this.maxCacheDataSize * 4 / 5;
    }

    public int getMaxCacheDataSize() {
        return this.maxCacheDataSize;
    }

    void close(boolean bl) {
        StaticUtil.removeOutOfMemoryHandler((OutOfMemoryHandler)this);
        this.stopWorkThread();
        this.flashService.close(bl);
    }

    boolean isTileInMemoryOrQueued(Tile tile) {
        return this.mapCache.containsKey(tile);
    }

    MapTile getTile(Tile tile, int n, boolean bl, boolean bl2) {
        return this.getTile(tile, n, bl, bl2, Long.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MapTile getTile(Tile tile, int n, boolean bl, boolean bl2, long l) {
        MapTile mapTile = (MapTile)this.mapCache.get(tile);
        if (l == Long.MIN_VALUE) {
            l = Config.getInstance().getClock().currentTimeMillis();
        }
        if (mapTile == null) {
            if (!this.mapCacheLocked) {
                Hashtable hashtable = this.mapCache;
                synchronized (hashtable) {
                    this.setMapCacheLocked(true);
                    try {
                        mapTile = this.flashService.getMapTile(tile);
                        if (mapTile == null) {
                            GoogleImage googleImage;
                            GoogleImage googleImage2 = googleImage = bl2 ? this.getScaledImage(tile) : null;
                            if (bl && DataRequestDispatcher.getInstance().canDispatchNow()) {
                                mapTile = new MapTile(tile, googleImage);
                                this.queueTileRequest(mapTile, n);
                                this.addMapEntry(mapTile);
                                Stats.getInstance().flashCacheMiss();
                            } else {
                                mapTile = new MapTile(tile, googleImage, true);
                            }
                        } else {
                            if (!bl) {
                                l -= 20000L;
                            }
                            this.addMapEntry(mapTile);
                            Stats.getInstance().flashCacheHit();
                        }
                    }
                    finally {
                        this.setMapCacheLocked(false);
                    }
                }
            }
            mapTile = new MapTile(tile, null, true);
        }
        mapTile.setLastAccessTime(l);
        return mapTile;
    }

    private GoogleImage getScaledImage(Tile tile) {
        GoogleImage googleImage = null;
        googleImage = (GoogleImage)this.tempScaledImages.get(tile);
        if (googleImage == null && (googleImage = this.createScaledImage(tile)) != null) {
            this.tempScaledImages.put(tile, googleImage);
        }
        return googleImage;
    }

    private GoogleImage createScaledImage(Tile tile) {
        long l = Config.getInstance().getClock().relativeTimeMillis();
        if (l < this.outOfMemoryTime + 10000L) {
            return null;
        }
        GoogleImage googleImage = null;
        try {
            Tile tile2 = tile.getZoomParent(false);
            if (tile2 != null) {
                int n = tile2.getZoom().getZoomRatio(tile.getZoom());
                MapTile mapTile = this.getTile(tile2, 0, false, false);
                if (n == 2 && mapTile.hasImage()) {
                    googleImage = this.createScaledImage(tile, tile2, mapTile.getImage());
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.clearScaledImages();
            this.outOfMemoryTime = l;
            Log.logQuietThrowable((String)"Map Service image scaling", (Throwable)outOfMemoryError);
        }
        return googleImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearScaledImages() {
        Hashtable hashtable = this.mapCache;
        synchronized (hashtable) {
            this.mapCacheLocked = true;
            this.tempScaledImages.clear();
            Enumeration enumeration = this.mapCache.elements();
            while (enumeration.hasMoreElements()) {
                MapTile mapTile = (MapTile)enumeration.nextElement();
                mapTile.removeScaledImage();
            }
            this.mapCacheLocked = false;
        }
    }

    private GoogleImage createScaledImageFromAncestor(Tile tile) {
        GoogleImage googleImage = null;
        Vector vector = this.getAncestorsUpToTileWithImage(tile);
        if (vector == null) {
            return null;
        }
        for (int i = vector.size() - 1; i > 0; --i) {
            Tile tile2 = (Tile)vector.elementAt(i);
            Tile tile3 = (Tile)vector.elementAt(i - 1);
            MapTile mapTile = this.getTile(tile2, 0, false, false);
            if (this.tempScaledImages.containsKey(tile3)) {
                googleImage = (GoogleImage)this.tempScaledImages.get(tile3);
                continue;
            }
            GoogleImage googleImage2 = mapTile.hasImage() ? mapTile.getImage() : (GoogleImage)this.tempScaledImages.get(tile2);
            if (googleImage2 != null) {
                googleImage = this.createScaledImage(tile3, tile2, googleImage2);
                this.tempScaledImages.put(tile3, googleImage);
                continue;
            }
            return null;
        }
        return googleImage;
    }

    private Vector getAncestorsUpToTileWithImage(Tile tile) {
        MapTile mapTile;
        Vector<Tile> vector = new Vector<Tile>();
        vector.addElement(tile);
        while (vector.size() <= 6 && !(mapTile = this.getTile(tile, 0, false, false)).hasImage()) {
            if ((tile = tile.getZoomParent(true)) == null) {
                return null;
            }
            vector.addElement(tile);
        }
        return vector.size() > 6 ? null : vector;
    }

    private GoogleImage createScaledImage(Tile tile, Tile tile2, GoogleImage googleImage) {
        int n = tile.getXIndex() == tile2.getXIndex() * 2 ? 0 : 64;
        int n2 = tile.getYIndex() == tile2.getYIndex() * 2 ? 0 : 64;
        GoogleImage googleImage2 = Config.getInstance().getImageFactory().createImage(128, 128);
        GoogleGraphics googleGraphics = googleImage2.getGraphics();
        boolean bl = googleGraphics.drawScaledImage(googleImage, 0, 0, 128, 128, n, n2, 64, 64);
        return bl ? googleImage2 : null;
    }

    private void queueTileRequest(MapTile mapTile, int n) {
        if (this.currentRequest == null) {
            this.currentRequest = new MapTileRequest();
        }
        this.currentRequest.requestTile(mapTile, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompact(boolean bl) {
        long l = bl ? 2000L : 12000L;
        Hashtable hashtable = this.mapCache;
        synchronized (hashtable) {
            this.setMapCacheLocked(true);
            try {
                long l2 = Config.getInstance().getClock().currentTimeMillis();
                Enumeration enumeration = this.mapCache.keys();
                while (enumeration.hasMoreElements()) {
                    Tile tile = (Tile)enumeration.nextElement();
                    MapTile mapTile = (MapTile)this.mapCache.get(tile);
                    long l3 = mapTile.getLastAccessTime();
                    if (l3 + l >= l2) continue;
                    mapTile.compact();
                }
            }
            finally {
                this.setMapCacheLocked(false);
            }
        }
    }

    private void addMapEntry(MapTile mapTile) {
        Tile tile = mapTile.getLocation();
        this.mapCache.put(tile, mapTile);
    }

    void checkTrimCache() {
        int n = this.getCacheSize();
        if (n > this.maxCacheDataSize) {
            if (this.autoConfigCache) {
                System.gc();
                long l = Runtime.getRuntime().freeMemory() + (long)n;
                int n2 = (int)(l - 40000L) / 2;
                int n3 = (int)Runtime.getRuntime().totalMemory();
                n2 = Math.min(n2, n3 / 3);
                this.maxCacheDataSize = Math.max(25000, n2);
                this.setAutoTargetCacheSize();
                if (n < this.maxCacheDataSize) {
                    return;
                }
            }
            this.trimCache(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimCache(int n) {
        Hashtable hashtable = this.mapCache;
        synchronized (hashtable) {
            try {
                this.mapCacheLocked = true;
                Tile[] tileArray = this.getSortedCacheList();
                for (int i = 0; i < tileArray.length && n > this.targetCacheDataSize; ++i) {
                    Tile tile = tileArray[i];
                    MapTile mapTile = (MapTile)this.mapCache.get(tile);
                    if (!mapTile.isComplete()) continue;
                    this.mapCache.remove(tile);
                    n -= mapTile.getDataSize();
                }
            }
            finally {
                this.mapCacheLocked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCacheSize() {
        int n = 0;
        Hashtable hashtable = this.mapCache;
        synchronized (hashtable) {
            Enumeration enumeration = this.mapCache.elements();
            while (enumeration.hasMoreElements()) {
                MapTile mapTile = (MapTile)enumeration.nextElement();
                n += mapTile.getDataSize();
            }
        }
        return n;
    }

    static long getScore(Tile tile, long l, long l2) {
        return l - l2;
    }

    long getTileDate(Tile tile) {
        return ((MapTile)this.mapCache.get(tile)).getLastAccessTime();
    }

    Tile[] getSortedCacheList() {
        long l = Config.getInstance().getClock().currentTimeMillis();
        Tile[] tileArray = new Tile[this.mapCache.size()];
        long[] lArray = new long[this.mapCache.size()];
        int n = 0;
        Enumeration enumeration = this.mapCache.keys();
        while (enumeration.hasMoreElements()) {
            tileArray[n] = (Tile)enumeration.nextElement();
            lArray[n] = MapService.getScore(tileArray[n], l, this.getTileDate(tileArray[n]));
            ++n;
        }
        this.sort(lArray, tileArray);
        return tileArray;
    }

    private void swap(long[] lArray, Tile[] tileArray, int n, int n2) {
        Tile tile = tileArray[n2];
        tileArray[n2] = tileArray[n];
        tileArray[n] = tile;
        long l = lArray[n2];
        lArray[n2] = lArray[n];
        lArray[n] = l;
    }

    private int partition(long[] lArray, Tile[] tileArray, int n, int n2, int n3) {
        long l = lArray[n3];
        this.swap(lArray, tileArray, n3, n2);
        int n4 = n;
        for (int i = n; i < n2; ++i) {
            if (lArray[i] < l) continue;
            this.swap(lArray, tileArray, i, n4++);
        }
        if (lArray[n2] > lArray[n4]) {
            this.swap(lArray, tileArray, n2, n4);
            return n4;
        }
        return n2;
    }

    private void qsort(long[] lArray, Tile[] tileArray, int n, int n2) {
        if (n2 > n) {
            int n3 = this.partition(lArray, tileArray, n, n2, n);
            this.qsort(lArray, tileArray, n, n3 - 1);
            this.qsort(lArray, tileArray, n3 + 1, n2);
        }
    }

    private void sort(long[] lArray, Tile[] tileArray) {
        this.qsort(lArray, tileArray, 0, tileArray.length - 1);
    }

    boolean requestTiles(boolean bl) {
        if (this.currentRequest != null) {
            MapTileRequest mapTileRequest = this.currentRequest;
            mapTileRequest.setForeground(bl);
            this.currentRequest = null;
            DataRequestDispatcher.getInstance().addDataRequest(mapTileRequest);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eraseAll() {
        Hashtable hashtable = this.mapCache;
        synchronized (hashtable) {
            this.mapCache.clear();
            this.flashService.eraseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTileEdition(int n) {
        if (this.flashService.setTileEdition(n)) {
            Hashtable hashtable = this.mapCache;
            synchronized (hashtable) {
                Enumeration enumeration = this.mapCache.keys();
                Vector<Tile> vector = new Vector<Tile>();
                while (enumeration.hasMoreElements()) {
                    Tile tile = (Tile)enumeration.nextElement();
                    MapTile mapTile = (MapTile)this.mapCache.get(tile);
                    if (!mapTile.isComplete()) continue;
                    vector.addElement(tile);
                }
                for (int i = 0; i < vector.size(); ++i) {
                    this.mapCache.remove(vector.elementAt(i));
                }
            }
        }
    }

    int getTileEdition() {
        return this.flashService.getTileEdition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mapChanged() {
        this.flashService.mapChanged();
        Object object = this.indefiniteThreadLockObject;
        synchronized (object) {
            this.indefiniteThreadLockObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOutOfMemory() {
        FlashRecord.clearDataCache();
        this.clearScaledImages();
        Hashtable hashtable = this.mapCache;
        synchronized (hashtable) {
            this.doCompact(true);
            if (this.autoConfigCache) {
                this.maxCacheDataSize = 25000;
                this.setAutoTargetCacheSize();
            } else {
                this.maxCacheDataSize = Math.max(this.maxCacheDataSize - 8000, 25000);
                this.setAutoTargetCacheSize();
            }
            this.checkTrimCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l;
        long l2 = l = Config.getInstance().getClock().relativeTimeMillis();
        while (!this.exitWorkThread) {
            try {
                Object object = this.timedThreadLockObject;
                synchronized (object) {
                    try {
                        this.timedThreadLockObject.wait(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.exitWorkThread) continue;
                if (l + 2101L < Config.getInstance().getClock().relativeTimeMillis()) {
                    this.checkTrimCache();
                    l = Config.getInstance().getClock().relativeTimeMillis();
                }
                if (l2 + 3113L < Config.getInstance().getClock().relativeTimeMillis()) {
                    this.doCompact(false);
                    l2 = Config.getInstance().getClock().relativeTimeMillis();
                }
                if (this.flashService.writeCache()) continue;
                object = this.indefiniteThreadLockObject;
                synchronized (object) {
                    try {
                        this.indefiniteThreadLockObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                Log.logThrowable((String)"MapService BG", (Throwable)exception);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                StaticUtil.handleOutOfMemory();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWorkThread() {
        if (!this.exitWorkThread) {
            this.exitWorkThread = true;
            Object object = this.timedThreadLockObject;
            synchronized (object) {
                this.timedThreadLockObject.notify();
            }
            object = this.indefiniteThreadLockObject;
            synchronized (object) {
                this.indefiniteThreadLockObject.notify();
            }
        }
    }

    private void startWorkThread() {
        if (this.exitWorkThread) {
            this.exitWorkThread = false;
            Thread thread = new Thread((Runnable)this, "MapService");
            thread.setPriority(1);
            thread.start();
        }
    }

    void pause() {
        this.stopWorkThread();
    }

    void resume() {
        this.startWorkThread();
    }

    void notifyUserInput() {
        this.flashService.notifyUserInput();
    }

    private class MapTileRequest
    extends BaseTileRequest {
        private Vector tileSchedule;
        private Vector tilePriorityList;
        private boolean closed;
        private boolean isForeground;

        MapTileRequest() {
            super(MapService.this.requestType);
            this.tileSchedule = new Vector();
            this.tilePriorityList = new Vector();
            this.isForeground = true;
            this.closed = false;
        }

        synchronized void requestTile(MapTile mapTile, int n) {
            int n2;
            if (this.closed) {
                throw new RuntimeException("Adding tiles to closed request!");
            }
            if (this.tileSchedule.indexOf(mapTile) != -1) {
                return;
            }
            for (n2 = this.tileSchedule.size(); n2 > 0; --n2) {
                int n3 = (Integer)this.tilePriorityList.elementAt(n2 - 1);
                if (n < n3) continue;
                this.tileSchedule.insertElementAt(mapTile, n2);
                this.tilePriorityList.insertElementAt(new Integer(n), n2);
                break;
            }
            if (n2 == 0) {
                this.tileSchedule.insertElementAt(mapTile, 0);
                this.tilePriorityList.insertElementAt(new Integer(n), 0);
            }
        }

        public boolean isForeground() {
            return this.isForeground;
        }

        public void setForeground(boolean bl) {
            this.isForeground = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeRequestData(DataOutput dataOutput) throws IOException {
            Tile[] tileArray = this;
            synchronized (this) {
                this.closed = true;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.tilePriorityList = null;
                tileArray = new Tile[this.tileSchedule.size()];
                for (int i = 0; i < this.tileSchedule.size(); ++i) {
                    tileArray[i] = ((MapTile)this.tileSchedule.elementAt(i)).getLocation();
                }
                this.writeRequestForTiles(tileArray, dataOutput);
                return;
            }
        }

        public boolean readResponseData(DataInput dataInput) throws IOException {
            super.readResponseData(dataInput);
            return this.tileSchedule.size() == 0;
        }

        protected void setTileEdition(int n) {
            MapService.this.setTileEdition(n);
        }

        protected void handleEndOfResponse(int n) {
            Vector vector = new Vector();
            ArrayUtil.copyIntoVector((Vector)this.tileSchedule, (int)n, vector);
            this.tileSchedule = vector;
            MapService.this.tempScaledImages.clear();
        }

        protected boolean processDownloadedTile(int n, Tile tile, byte[] byArray) {
            MapTile mapTile = (MapTile)this.tileSchedule.elementAt(n);
            if (mapTile != null) {
                if (mapTile.getLocation().equals(tile)) {
                    mapTile.setData(byArray);
                    mapTile.setLastAccessTime(mapTile.getLastAccessTime() - (long)n);
                    if (MapService.this.repaintListener != null) {
                        MapService.this.repaintListener.repaint();
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
    }
}

