/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Config;
import com.google.common.Log;
import com.google.common.io.PersistentStore;
import com.google.common.util.RuntimeCheck;
import com.google.googlenav.map.FlashEntry;
import com.google.googlenav.map.FlashRecord;
import com.google.googlenav.map.MapService;
import com.google.googlenav.map.MapTile;
import com.google.googlenav.map.MapTileStorage;
import com.google.googlenav.map.Tile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

class MapFlashService
implements MapTileStorage {
    private static final int TILE_STORE_FORMAT_VERSION = 7;
    static final int MIN_FLASH_RECORD_DATA_SIZE = 6000;
    static final int MAX_FLASH_RECORD_DATA_SIZE = 18000;
    static final int CATALOG_ALLOTMENT = 2000;
    protected static final int STATUS_TOO_SMALL_TO_PERSIST = 0;
    protected static final int STATUS_NOT_ENOUGH_SPACE_TO_PERSIST = 1;
    protected static final int STATUS_TOO_LARGE_TO_PERSIST = 2;
    protected static final int STATUS_NEW_BLOCK_PERSISTED = 3;
    protected static final int STATUS_REPLACED_BLOCK_PERSISTED = 4;
    protected static final int STATUS_NOT_PERSISTED = 5;
    private final PersistentStore store = Config.getInstance().getPersistentStore();
    private final String recordStoreBaseName;
    private final MapService mapService;
    private int maxRecordBlocks;
    private int tileEdition = -1;
    private final Vector flashRecords = new Vector();
    private final Hashtable tileToRecordMap = new Hashtable();
    private int highestRecordId = 0;
    private int catalogRecordBytes = 0;
    private boolean catalogUpdatedSinceLastWrite;
    private int maxFlashSize;
    private long lastChangedTime;
    private long nextPersistTime;
    private static final long PERSIST_TIME = 2113L;
    private static final long PERSIST_IDLE_TIME = 1500L;

    MapFlashService(MapService mapService, String string, int n, int n2) {
        long l;
        this.mapService = mapService;
        this.recordStoreBaseName = string;
        this.maxFlashSize = n - 2000;
        this.lastChangedTime = l = Config.getInstance().getClock().relativeTimeMillis();
        this.nextPersistTime = l + 2113L;
        this.maxRecordBlocks = n2 - 1;
        this.catalogUpdatedSinceLastWrite = true;
        this.readCatalog();
        this.scavengeCatalog();
    }

    int getNumBlocks() {
        return this.flashRecords.size();
    }

    String recordBlockName(int n) {
        return this.recordStoreBaseName + '_' + n;
    }

    String recordBlockName(FlashRecord flashRecord) {
        return this.recordBlockName(flashRecord.getRecordId());
    }

    public synchronized void close(boolean bl) {
        if (bl) {
            try {
                this.writeCache();
                this.writeCatalog();
            }
            catch (IOException iOException) {
                Log.logThrowable((String)"FLASH", (Throwable)iOException);
            }
        }
    }

    private synchronized void readCatalog() {
        try {
            ByteArrayInputStream byteArrayInputStream;
            DataInputStream dataInputStream;
            int n;
            this.catalogUpdatedSinceLastWrite = true;
            byte[] byArray = this.store.readBlock(this.recordStoreBaseName);
            if (byArray != null && (n = (dataInputStream = new DataInputStream(byteArrayInputStream = new ByteArrayInputStream(byArray))).readInt()) == 7) {
                dataInputStream.readBoolean();
                this.tileEdition = dataInputStream.readShort();
                int n2 = dataInputStream.readInt();
                for (int i = 0; i < n2; ++i) {
                    FlashRecord flashRecord = FlashRecord.readFromCatalog(dataInputStream);
                    this.addToFlashCatalog(flashRecord);
                }
                this.catalogRecordBytes = byArray.length;
                this.catalogUpdatedSinceLastWrite = false;
            }
        }
        catch (IOException iOException) {
            Log.logThrowable((String)"FLASH", (Throwable)iOException);
        }
        if (this.catalogUpdatedSinceLastWrite) {
            this.eraseAll();
        }
    }

    synchronized boolean writeCatalog() throws IOException {
        boolean bl = true;
        if (!this.catalogUpdatedSinceLastWrite) {
            return true;
        }
        int n = this.flashRecords.size();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(7);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeShort(this.tileEdition);
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            FlashRecord flashRecord = this.getFlashRecord(i);
            flashRecord.writeToCatalog(dataOutputStream);
        }
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream = null;
        byteArrayOutputStream = null;
        try {
            this.store.writeBlockX(byArray, this.recordStoreBaseName);
        }
        catch (PersistentStore.PersistentStoreException persistentStoreException) {
            this.handlePersistentStoreWriteException(persistentStoreException, true);
            bl = false;
        }
        this.catalogRecordBytes = byArray.length;
        this.catalogUpdatedSinceLastWrite = false;
        return bl;
    }

    private void handlePersistentStoreWriteException(PersistentStore.PersistentStoreException persistentStoreException, boolean bl) {
        int n = this.getSize();
        int n2 = this.getNumBlocks();
        Log.logQuietThrowable((String)("FLASH " + n + "B " + n2 + "R" + (bl ? " catalog" : "")), (Throwable)persistentStoreException);
        if (persistentStoreException.getType() == -2) {
            if (this.canCreateAnEmptyRecordStore()) {
                this.maxFlashSize = n - 1000;
            } else {
                this.maxRecordBlocks = n2;
            }
        }
    }

    public synchronized void eraseAll() {
        this.tileToRecordMap.clear();
        this.flashRecords.removeAllElements();
        this.catalogRecordBytes = 0;
        this.highestRecordId = 0;
        this.catalogUpdatedSinceLastWrite = false;
        this.store.deleteAllBlocks(this.recordStoreBaseName);
    }

    synchronized boolean scavengeCatalog() {
        int n;
        boolean bl = true;
        String[] stringArray = this.store.listBlocks(this.recordStoreBaseName);
        for (n = this.getNumBlocks() - 1; n >= 0; --n) {
            FlashRecord flashRecord = (FlashRecord)this.flashRecords.elementAt(n);
            if (MapFlashService.removeNameFromArray(this.recordBlockName(flashRecord), stringArray)) continue;
            bl = false;
            this.removeFromFlashCatalog(flashRecord, n);
        }
        n = 0;
        if (stringArray != null) {
            n = MapFlashService.removeNameFromArray(this.recordStoreBaseName, stringArray) ? 1 : 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null) continue;
                bl = false;
                this.store.deleteBlock(string);
            }
        }
        if (this.getNumBlocks() > 0 && n == 0) {
            bl = false;
        }
        return bl;
    }

    private static boolean removeNameFromArray(String string, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            stringArray[i] = null;
            return true;
        }
        return false;
    }

    private int findRecordIndexByID(int n) {
        int n2 = this.flashRecords.size();
        for (int i = 0; i < n2; ++i) {
            FlashRecord flashRecord = (FlashRecord)this.flashRecords.elementAt(i);
            if (flashRecord.getRecordId() != n) continue;
            return i;
        }
        return -1;
    }

    synchronized boolean verifyForTest() {
        RuntimeCheck.checkUnitTest();
        int n = this.flashRecords.size();
        boolean bl = this.scavengeCatalog();
        for (int i = 0; i < n; ++i) {
            FlashRecord flashRecord = (FlashRecord)this.flashRecords.elementAt(i);
            bl &= flashRecord.verifyForTest(this.recordBlockName(flashRecord));
        }
        return bl;
    }

    private FlashRecord getFlashRecord(int n) {
        return (FlashRecord)this.flashRecords.elementAt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doPersist(Hashtable hashtable) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int[] nArray = new int[]{-1, -1};
        FlashRecord[] flashRecordArray = new FlashRecord[]{null, null};
        long l = Config.getInstance().getClock().currentTimeMillis();
        Object object = this;
        synchronized (object) {
            n3 = n4 = this.maxFlashSize - this.getSize();
            if (n4 < MAX_FLASH_RECORD_DATA_SIZE || this.getNumBlocks() >= this.maxRecordBlocks) {
                int n5 = -1;
                n2 = -1;
                long l2 = Long.MIN_VALUE;
                long l3 = Long.MIN_VALUE;
                int n6 = this.getNumBlocks();
                for (int i = 0; i < n6; ++i) {
                    FlashRecord flashRecord = this.getFlashRecord(i);
                    long l4 = flashRecord.getScore(l);
                    if (n2 != -1 && l4 <= l3) continue;
                    if (n5 == -1 || l4 > l2) {
                        n2 = n5;
                        l3 = l2;
                        n5 = i;
                        l2 = l4;
                        continue;
                    }
                    n2 = i;
                    l3 = l4;
                }
                if (n5 != -1) {
                    nArray[0] = n5;
                    flashRecordArray[0] = this.getFlashRecord(n5);
                    n3 += flashRecordArray[0].getDataSize();
                }
                if (n3 < MAX_FLASH_RECORD_DATA_SIZE && n2 != -1) {
                    nArray[1] = n2;
                    flashRecordArray[1] = this.getFlashRecord(n2);
                    n3 += flashRecordArray[1].getDataSize();
                }
                n3 = Math.min(n3, MAX_FLASH_RECORD_DATA_SIZE);
            } else {
                n3 = MAX_FLASH_RECORD_DATA_SIZE;
            }
        }
        if (n3 < MIN_FLASH_RECORD_DATA_SIZE) {
            if (flashRecordArray[0] != null) {
                this.store.deleteBlock(this.recordBlockName(flashRecordArray[0]));
                this.removeFromFlashCatalog(flashRecordArray[0], nArray[0]);
            }
            return 1;
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            try {
                this.mapService.setMapCacheLocked(true);
                object = this.fillNewRecord(hashtable, n3);
            }
            finally {
                this.mapService.setMapCacheLocked(false);
            }
        }
        int n7 = ((FlashRecord)object).getDataSize();
        if (n7 >= MIN_FLASH_RECORD_DATA_SIZE) {
            n2 = -1;
            Object object2 = this;
            synchronized (object2) {
                int n8;
                n4 = this.maxFlashSize - this.getSize();
                boolean[] blArray = new boolean[]{false, false};
                int n9 = 0;
                for (n8 = 0; n8 < 2; ++n8) {
                    if (flashRecordArray[n8] != null && flashRecordArray[n8].isSaved() && flashRecordArray[n8].getScore(l) > ((FlashRecord)object).getScore(l)) {
                        blArray[n8] = true;
                        n9 += flashRecordArray[n8].getDataSize();
                    }
                    if (n7 <= n4 + n9) break;
                }
                n8 = this.getNumBlocks();
                if (n7 > n4 + n9) {
                    n = 2;
                } else if (blArray[0] && (n7 > n4 || n8 >= this.maxRecordBlocks)) {
                    n = 4;
                    n2 = flashRecordArray[0].getRecordId();
                    this.removeFromFlashCatalog(flashRecordArray[0], nArray[0]);
                    if (blArray[1]) {
                        if (nArray[0] < nArray[1]) {
                            nArray[1] = nArray[1] - 1;
                        }
                        this.store.deleteBlock(this.recordBlockName(flashRecordArray[1]));
                        this.removeFromFlashCatalog(flashRecordArray[1], nArray[1]);
                    }
                } else if (n8 < this.maxRecordBlocks) {
                    n = 3;
                    n2 = ++this.highestRecordId;
                } else {
                    n = 5;
                }
            }
            if (n2 >= 0) {
                object2 = ((FlashRecord)object).createDataEntry(hashtable);
                if (object2 != null) {
                    this.persistRecord((FlashRecord)object, (byte[])object2, n2);
                }
                System.gc();
            }
        } else {
            n = 0;
        }
        this.writeCatalog();
        return n;
    }

    private synchronized void persistRecord(FlashRecord flashRecord, byte[] byArray, int n) {
        if (this.catalogRecordBytes == 0) {
            this.store.writeBlock(new byte[0], this.recordStoreBaseName);
        }
        try {
            flashRecord.writeRecord(this.recordBlockName(n), n, byArray);
            this.addToFlashCatalog(flashRecord);
        }
        catch (PersistentStore.PersistentStoreException persistentStoreException) {
            this.handlePersistentStoreWriteException(persistentStoreException, false);
        }
        catch (IllegalStateException illegalStateException) {
            Log.logThrowable((String)"FLASH", (Throwable)illegalStateException);
        }
    }

    private boolean canCreateAnEmptyRecordStore() {
        String string = this.recordStoreBaseName + "_Test";
        try {
            this.store.writeBlockX(new byte[0], string);
            this.store.deleteBlock(string);
        }
        catch (PersistentStore.PersistentStoreException persistentStoreException) {
            return false;
        }
        return true;
    }

    private FlashRecord fillNewRecord(Hashtable hashtable, int n) {
        FlashRecord flashRecord = new FlashRecord();
        int n2 = 1;
        Tile[] tileArray = this.mapService.getSortedCacheList();
        for (int i = tileArray.length - 1; i >= 0; --i) {
            FlashEntry flashEntry;
            int n3;
            MapTile mapTile;
            Tile tile = tileArray[i];
            if (this.tileToRecordMap.get(tile) != null || !(mapTile = (MapTile)hashtable.get(tile)).isComplete() || n2 + (n3 = (flashEntry = new FlashEntry(mapTile)).getByteSize()) > n || !flashRecord.addEntry(flashEntry)) continue;
            n2 += n3;
        }
        return flashRecord;
    }

    private void addToFlashCatalog(FlashRecord flashRecord) {
        int n = flashRecord.numEntries();
        this.catalogUpdatedSinceLastWrite = true;
        this.highestRecordId = Math.max(this.highestRecordId, flashRecord.getRecordId());
        this.flashRecords.addElement(flashRecord);
        for (int i = 0; i < n; ++i) {
            FlashEntry flashEntry = flashRecord.getEntry(i);
            this.tileToRecordMap.put(flashEntry.getTile(), flashRecord);
        }
    }

    private void removeFromFlashCatalog(FlashRecord flashRecord, int n) {
        if (!flashRecord.isSaved()) {
            return;
        }
        int n2 = flashRecord.numEntries();
        this.catalogUpdatedSinceLastWrite = true;
        flashRecord.setUnsaved();
        this.flashRecords.removeElementAt(n);
        for (int i = 0; i < n2; ++i) {
            FlashEntry flashEntry = flashRecord.getEntry(i);
            this.tileToRecordMap.remove(flashEntry.getTile());
        }
    }

    private FlashEntry getFlashEntry(Tile tile) {
        FlashRecord flashRecord = (FlashRecord)this.tileToRecordMap.get(tile);
        return flashRecord == null ? null : flashRecord.getEntry(tile);
    }

    synchronized int getFlashRecordsSize() {
        int n = this.flashRecords.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.getFlashRecord(i).getDataSize();
        }
        return n2;
    }

    public synchronized int getSize() {
        return this.catalogRecordBytes + this.getFlashRecordsSize();
    }

    public MapTile getMapTile(Tile tile) {
        MapTile mapTile = null;
        FlashEntry flashEntry = this.getFlashEntry(tile);
        if (flashEntry != null && (mapTile = this.loadFlashRecordTile(flashEntry.getFlashRecord(), tile)) != null) {
            flashEntry.setLastAccessTime(Config.getInstance().getClock().currentTimeMillis());
        }
        return mapTile;
    }

    MapTile getMapTileWithoutUpdatingAccessTime(Tile tile) {
        MapTile mapTile = null;
        FlashEntry flashEntry = this.getFlashEntry(tile);
        if (flashEntry != null) {
            mapTile = this.loadFlashRecordTile(flashEntry.getFlashRecord(), tile);
        }
        return mapTile;
    }

    public void mapChanged() {
        this.lastChangedTime = Config.getInstance().getClock().relativeTimeMillis();
    }

    public void notifyUserInput() {
        this.lastChangedTime = Config.getInstance().getClock().relativeTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeCache() throws IOException {
        long l = Config.getInstance().getClock().relativeTimeMillis();
        Hashtable hashtable = this.mapService.getMapCache();
        boolean bl = false;
        if (this.nextPersistTime < l && this.lastChangedTime + 1500L < l) {
            try {
                int n = this.doPersist(hashtable);
                bl = n == 3 || n == 4;
            }
            finally {
                this.nextPersistTime = Config.getInstance().getClock().relativeTimeMillis() + 2113L;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapTile loadFlashRecordTile(FlashRecord flashRecord, Tile tile) {
        MapTile mapTile = flashRecord.loadTile(this.recordBlockName(flashRecord), tile);
        if (mapTile == null) {
            MapFlashService mapFlashService = this;
            synchronized (mapFlashService) {
                int n = flashRecord.getRecordId();
                this.removeFromFlashCatalog(flashRecord, this.findRecordIndexByID(n));
                this.store.deleteBlock(this.recordBlockName(n));
            }
        }
        return mapTile;
    }

    public int getTileEdition() {
        return this.tileEdition;
    }

    public boolean setTileEdition(int n) {
        boolean bl = n != this.tileEdition && this.tileEdition != -1;
        this.tileEdition = n;
        if (bl) {
            this.eraseAll();
            this.catalogUpdatedSinceLastWrite = true;
        }
        return bl;
    }
}

