/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Config;
import com.google.common.graphics.GoogleImage;
import com.google.googlenav.layer.ClickableArea;
import com.google.googlenav.map.Tile;

public class LayerTile {
    private final Tile location;
    private ClickableArea[] clickableArea;
    private GoogleImage image;
    private long dataTime = Long.MIN_VALUE;

    public LayerTile(Tile tile) {
        this.location = tile;
    }

    public long getDataTime() {
        return this.isEmpty() ? Config.getInstance().getClock().relativeTimeMillis() : this.dataTime;
    }

    public Tile getLocation() {
        return this.location;
    }

    public boolean isComplete() {
        return this.clickableArea != null;
    }

    public boolean isEmpty() {
        return this.clickableArea != null && this.clickableArea.length == 0;
    }

    public ClickableArea[] getClickableArea() {
        return this.clickableArea;
    }

    public void setClickableArea(ClickableArea[] clickableAreaArray) {
        this.clickableArea = clickableAreaArray;
        this.dataTime = Config.getInstance().getClock().relativeTimeMillis();
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public synchronized GoogleImage getImage() {
        return this.image;
    }

    public synchronized void setImage(byte[] byArray) {
        this.image = byArray == null || byArray.length == 0 ? null : Config.getInstance().getImageFactory().createImage(byArray, 0, byArray.length);
    }

    public void mergeClickableArea(ClickableArea[] clickableAreaArray) {
        ClickableArea[] clickableAreaArray2 = new ClickableArea[this.clickableArea.length + clickableAreaArray.length];
        System.arraycopy(this.clickableArea, 0, clickableAreaArray2, 0, this.clickableArea.length);
        System.arraycopy(clickableAreaArray, 0, clickableAreaArray2, this.clickableArea.length, clickableAreaArray.length);
        this.clickableArea = clickableAreaArray2;
    }
}

