/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Config;
import com.google.common.OutOfMemoryHandler;
import com.google.common.StaticUtil;
import com.google.common.io.protocol.ProtoBuf;
import com.google.common.io.protocol.ProtoBufType;
import com.google.common.io.protocol.ProtoBufUtil;
import com.google.common.util.RuntimeCheck;
import com.google.googlenav.datarequest.BaseDataRequest;
import com.google.googlenav.datarequest.DataRequestDispatcher;
import com.google.googlenav.layer.ClickableArea;
import com.google.googlenav.layer.LayerInfo;
import com.google.googlenav.layer.LayerPayloadHandler;
import com.google.googlenav.map.LayerTile;
import com.google.googlenav.map.Tile;
import com.google.googlenav.proto.GmmMessageTypes;
import com.google.map.Zoom;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class LayerService
implements OutOfMemoryHandler,
LayerPayloadHandler {
    public static final long NO_REFRESH = -1L;
    private final Hashtable cache;
    private final Hashtable requestedTiles;
    private volatile LayerTileRequest request;
    private final Vector observers = new Vector();
    private long refreshMillis = -1L;
    private long nextRefreshTime;

    public LayerService() {
        this.cache = new Hashtable();
        this.requestedTiles = new Hashtable();
        this.nextRefreshTime = Long.MIN_VALUE;
        StaticUtil.registerOutOfMemoryHandler((OutOfMemoryHandler)this);
    }

    public void addTileUpdateObserver(TileUpdateObserver tileUpdateObserver) {
        this.observers.addElement(tileUpdateObserver);
        long l = tileUpdateObserver.getLayerInfo().getLayerTileExpirationTime();
        if (l != -1L && (this.refreshMillis == -1L || l < this.refreshMillis)) {
            this.refreshMillis = l;
        }
        this.cache.clear();
    }

    public void removeTileUpdateObserver(TileUpdateObserver tileUpdateObserver) {
        this.observers.removeElement(tileUpdateObserver);
        this.refreshMillis = -1L;
        int n = this.observers.size();
        for (int i = 0; i < n; ++i) {
            long l = ((TileUpdateObserver)this.observers.elementAt(i)).getLayerInfo().getLayerTileExpirationTime();
            if (l == -1L || this.refreshMillis != -1L && l >= this.refreshMillis) continue;
            this.refreshMillis = l;
        }
        this.cache.clear();
    }

    public boolean needFetchLayerTiles() {
        return this.observers.size() > 0;
    }

    public void notifyNewTile() {
        int n = this.observers.size();
        for (int i = 0; i < n; ++i) {
            ((TileUpdateObserver)this.observers.elementAt(i)).updateTile();
        }
    }

    public void notifyNewLayerInfo(String string, ProtoBuf[] protoBufArray) {
        int n = this.observers.size();
        for (int i = 0; i < n; ++i) {
            ((TileUpdateObserver)this.observers.elementAt(i)).updateLayerInfo(string, protoBufArray);
        }
    }

    public void close() {
        StaticUtil.removeOutOfMemoryHandler((OutOfMemoryHandler)this);
    }

    public synchronized LayerTile getTile(Tile tile, boolean bl) {
        LayerTile layerTile = (LayerTile)this.cache.get(tile);
        LayerTile layerTile2 = (LayerTile)this.requestedTiles.get(tile);
        if (layerTile != null) {
            if (this.refreshMillis != -1L) {
                long l = Config.getInstance().getClock().relativeTimeMillis();
                long l2 = layerTile.getDataTime();
                long l3 = l - l2;
                if (bl && layerTile2 == null && l2 != Long.MIN_VALUE && l3 > this.refreshMillis && (l > this.nextRefreshTime || this.request != null)) {
                    this.requestTile(tile, layerTile);
                }
            }
            return layerTile;
        }
        if (layerTile2 != null) {
            return layerTile2;
        }
        layerTile = new LayerTile(tile);
        if (bl) {
            this.requestTile(tile, layerTile);
        }
        return layerTile;
    }

    private synchronized void requestTile(Tile tile, LayerTile layerTile) {
        if (this.request == null) {
            this.request = new LayerTileRequest();
        }
        this.request.addTile(layerTile);
        this.requestedTiles.put(tile, layerTile);
    }

    public synchronized void requestTiles() {
        if (this.request != null) {
            DataRequestDispatcher.getInstance().addDataRequest(this.request);
            this.request = null;
            this.nextRefreshTime = Config.getInstance().getClock().relativeTimeMillis() + this.refreshMillis;
        }
    }

    public void handleOutOfMemory() {
        this.cache.clear();
    }

    public void handleLayerTileResponseHeader(ProtoBuf protoBuf) {
        LayerTileRequest layerTileRequest = new LayerTileRequest();
        layerTileRequest.processResponseHeader(protoBuf);
    }

    public void handleLayerTileInfo(ProtoBuf protoBuf) {
        LayerTileRequest layerTileRequest = new LayerTileRequest();
        layerTileRequest.processLayerTile(protoBuf, false);
    }

    public Vector getObserversForTest() {
        RuntimeCheck.checkUnitTest();
        return this.observers;
    }

    public Hashtable getTileCacheForTest() {
        RuntimeCheck.checkUnitTest();
        return this.cache;
    }

    public long getRefreshMillisForTest() {
        RuntimeCheck.checkUnitTest();
        return this.refreshMillis;
    }

    private class LayerTileRequest
    extends BaseDataRequest {
        public static final int LAYER_TILE_REQUEST_ID = 36;
        private boolean closed = false;
        private final Vector tiles = new Vector();

        public int getRequestType() {
            return 36;
        }

        public synchronized void addTile(LayerTile layerTile) {
            if (this.closed) {
                throw new RuntimeException("Adding tiles to closed request!");
            }
            if (this.tiles.indexOf(layerTile) != -1) {
                return;
            }
            this.tiles.addElement(layerTile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeRequestData(DataOutput dataOutput) throws IOException {
            ProtoBuf protoBuf;
            Object object;
            int n;
            LayerTileRequest layerTileRequest = this;
            synchronized (layerTileRequest) {
                this.closed = true;
            }
            layerTileRequest = new ProtoBuf(GmmMessageTypes.LAYER_TILE_REQUEST_PROTO);
            layerTileRequest.setInt(1, 128);
            int n2 = 1;
            int n3 = this.tiles.size();
            for (n = 0; n < n3; ++n) {
                object = ((LayerTile)this.tiles.elementAt(n)).getLocation();
                n2 = ((Tile)object).getZoom().getZoomLevel();
                protoBuf = new ProtoBuf(GmmMessageTypes.MAP_TILE_PROTO);
                protoBuf.setInt(1, 8);
                protoBuf.setInt(2, ((Tile)object).getXIndex());
                protoBuf.setInt(3, ((Tile)object).getYIndex());
                protoBuf.setInt(4, n2);
                layerTileRequest.addProtoBuf(3, protoBuf);
            }
            n3 = LayerService.this.observers.size();
            for (n = 0; n < n3; ++n) {
                object = ((TileUpdateObserver)LayerService.this.observers.elementAt(n)).getLayerInfo();
                protoBuf = new ProtoBuf(null);
                protoBuf.setString(21, ((LayerInfo)object).getId());
                ProtoBuf[] protoBufArray = ((LayerInfo)object).getParameters();
                if (protoBufArray != null) {
                    for (int i = 0; i < protoBufArray.length; ++i) {
                        protoBuf.addProtoBuf(22, protoBufArray[i]);
                    }
                }
                if (!((LayerInfo)object).isValidZoomLevel(n2)) continue;
                layerTileRequest.addProtoBuf(2, protoBuf);
            }
            dataOutput.writeInt(layerTileRequest.getDataSize());
            layerTileRequest.outputTo((OutputStream)((Object)dataOutput));
        }

        public boolean readResponseData(DataInput dataInput) throws IOException {
            ProtoBuf protoBuf = ProtoBufUtil.readProtoBufResponse((ProtoBufType)GmmMessageTypes.LAYER_TILE_RESPONSE_PROTO, (DataInput)dataInput);
            ProtoBuf protoBuf2 = protoBuf.getProtoBuf(1);
            this.processResponseHeader(protoBuf2);
            int n = protoBuf.getCount(2);
            for (int i = 0; i < n; ++i) {
                ProtoBuf protoBuf3 = protoBuf.getProtoBuf(2, i);
                this.processLayerTile(protoBuf3, true);
            }
            return true;
        }

        public void processResponseHeader(ProtoBuf protoBuf) {
            int n = protoBuf.getCount(1);
            for (int i = 0; i < n; ++i) {
                ProtoBuf protoBuf2 = protoBuf.getProtoBuf(1, i);
                String string = protoBuf2.getString(11);
                int n2 = protoBuf2.getCount(13);
                ProtoBuf[] protoBufArray = new ProtoBuf[n2];
                for (int j = 0; j < n2; ++j) {
                    protoBufArray[j] = protoBuf2.getProtoBuf(13, j);
                }
                LayerService.this.notifyNewLayerInfo(string, protoBufArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLayerTile(ProtoBuf protoBuf, boolean bl) {
            ProtoBuf protoBuf2 = protoBuf.getProtoBuf(1);
            Tile tile = Tile.getTile((byte)protoBuf2.getInt(1), protoBuf2.getInt(2), protoBuf2.getInt(3), Zoom.getZoom(protoBuf2.getInt(4)));
            int n = protoBuf.getCount(3);
            ClickableArea[] clickableAreaArray = new ClickableArea[n];
            for (int i = 0; i < n; ++i) {
                clickableAreaArray[i] = new ClickableArea(protoBuf.getProtoBuf(3, i));
            }
            LayerTile layerTile = (LayerTile)LayerService.this.requestedTiles.get(tile);
            if (layerTile == null) {
                layerTile = new LayerTile(tile);
            } else if (layerTile.isComplete() && bl) {
                layerTile = new LayerTile(tile);
            }
            if (!layerTile.isComplete() || bl) {
                layerTile.setClickableArea(clickableAreaArray);
            } else {
                layerTile.mergeClickableArea(clickableAreaArray);
            }
            if (protoBuf.has(2)) {
                layerTile.setImage(protoBuf.getBytes(2));
            }
            LayerTileRequest layerTileRequest = this;
            synchronized (layerTileRequest) {
                LayerService.this.cache.put(tile, layerTile);
                LayerService.this.requestedTiles.remove(tile);
            }
            LayerService.this.notifyNewTile();
        }
    }

    public static interface TileUpdateObserver {
        public LayerInfo getLayerInfo();

        public void updateLayerInfo(String var1, ProtoBuf[] var2);

        public void updateTile();
    }
}

