/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Config;
import com.google.common.Log;
import com.google.common.io.PersistentStore;
import com.google.common.util.RuntimeCheck;
import com.google.googlenav.map.FlashEntry;
import com.google.googlenav.map.MapFlashService;
import com.google.googlenav.map.MapService;
import com.google.googlenav.map.MapTile;
import com.google.googlenav.map.Tile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

class FlashRecord {
    static final int FLASH_BLOCK_OVERHEAD = 1;
    static final int NOT_SAVED = -1;
    private final Vector flashEntries = new Vector();
    private int recordId = -1;
    private boolean unverified = false;
    private static byte[] lastCachedData = null;
    private static FlashRecord lastFlashRecord = null;
    private static final Object lastCacheDataLock = new Object();

    public boolean addEntry(FlashEntry flashEntry) {
        if (this.numEntries() >= 255 || this.recordId != -1) {
            return false;
        }
        this.flashEntries.addElement(flashEntry);
        flashEntry.setFlashRecord(this);
        return true;
    }

    public FlashEntry getEntry(Tile tile) {
        for (int i = 0; i < this.flashEntries.size(); ++i) {
            FlashEntry flashEntry = this.getEntry(i);
            if (!flashEntry.getTile().equals(tile)) continue;
            return flashEntry;
        }
        return null;
    }

    public FlashEntry getEntry(int n) {
        return (FlashEntry)this.flashEntries.elementAt(n);
    }

    public int numEntries() {
        return this.flashEntries.size();
    }

    public int getDataSize() {
        int n = this.flashEntries.size();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 += this.getEntry(i).getByteSize();
        }
        return n2;
    }

    public int getRecordId() {
        return this.recordId;
    }

    boolean isSaved() {
        return this.recordId != -1;
    }

    void setUnsaved() {
        this.recordId = -1;
    }

    public long getScore(long l) {
        int n = this.flashEntries.size();
        long l2 = 0L;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                FlashEntry flashEntry = this.getEntry(i);
                l2 += MapService.getScore(flashEntry.getTile(), l, flashEntry.getLastAccessTime());
            }
            return l2 / (long)n;
        }
        return Long.MAX_VALUE;
    }

    public String toString() {
        return super.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FlashRecord)) {
            return false;
        }
        FlashRecord flashRecord = (FlashRecord)object;
        if (this.recordId != flashRecord.recordId) {
            return false;
        }
        int n = this.numEntries();
        if (n != flashRecord.numEntries()) {
            return false;
        }
        Vector vector = flashRecord.flashEntries;
        for (int i = 0; i < n; ++i) {
            FlashEntry flashEntry = (FlashEntry)this.flashEntries.elementAt(i);
            if (flashEntry.equals(vector.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.recordId;
    }

    public static FlashRecord readFromCatalog(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        int n2 = dataInput.readInt();
        FlashRecord flashRecord = new FlashRecord();
        for (int i = 0; i < n; ++i) {
            FlashEntry flashEntry = FlashEntry.readFromCatalog(dataInput);
            if (flashRecord.addEntry(flashEntry)) continue;
            throw new IOException("FlashRecord full");
        }
        flashRecord.unverified = true;
        flashRecord.recordId = n2;
        return flashRecord;
    }

    public void writeToCatalog(DataOutput dataOutput) throws IOException {
        if (this.recordId == -1) {
            throw new IllegalStateException("Can't write unsaved FlashRecord");
        }
        int n = this.numEntries();
        dataOutput.writeByte(n);
        dataOutput.writeInt(this.recordId);
        for (int i = 0; i < n; ++i) {
            FlashEntry flashEntry = this.getEntry(i);
            flashEntry.writeToCatalog(dataOutput);
        }
    }

    private MapTile loadTileFromDataEntry(byte[] byArray, Tile tile) {
        MapTile mapTile = null;
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readUnsignedByte();
            if (n != this.numEntries()) {
                return null;
            }
            for (int i = 0; i < n; ++i) {
                FlashEntry flashEntry;
                MapTile mapTile2 = MapTile.read(dataInputStream);
                if (this.unverified && !(flashEntry = new FlashEntry(mapTile2)).equals(this.flashEntries.elementAt(i))) {
                    return null;
                }
                if (!mapTile2.getLocation().equals(tile)) continue;
                mapTile = mapTile2;
                if (!this.unverified) break;
            }
            this.unverified = false;
        }
        catch (IOException iOException) {
            Log.logQuietThrowable((String)"FLASH", (Throwable)iOException);
        }
        return mapTile;
    }

    byte[] createDataEntry(Hashtable hashtable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(MapFlashService.MAX_FLASH_RECORD_DATA_SIZE);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n = this.numEntries();
        dataOutputStream.writeByte(n);
        for (int i = 0; i < n; ++i) {
            FlashEntry flashEntry = this.getEntry(i);
            MapTile mapTile = (MapTile)hashtable.get(flashEntry.getTile());
            if (mapTile == null) {
                return null;
            }
            mapTile.write(dataOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapTile loadTile(String string, Tile tile) {
        if (this.recordId == -1) {
            return null;
        }
        byte[] byArray = null;
        Object object = lastCacheDataLock;
        synchronized (object) {
            if (this.equals(lastFlashRecord)) {
                byArray = lastCachedData;
            }
        }
        if (byArray == null && (byArray = Config.getInstance().getPersistentStore().readBlock(string)) != null && byArray.length != 0) {
            object = lastCacheDataLock;
            synchronized (object) {
                lastCachedData = byArray;
                lastFlashRecord = this;
            }
        }
        if (byArray == null) {
            return null;
        }
        return this.loadTileFromDataEntry(byArray, tile);
    }

    void writeRecord(String string, int n, byte[] byArray) throws PersistentStore.PersistentStoreException, IllegalStateException {
        if (this.recordId != -1) {
            throw new IllegalStateException("already saved");
        }
        Config.getInstance().getPersistentStore().writeBlockX(byArray, string);
        this.recordId = n;
    }

    boolean verifyForTest(String string) {
        RuntimeCheck.checkUnitTest();
        if (this.numEntries() == 0 || this.recordId == -1) {
            return true;
        }
        FlashEntry flashEntry = this.getEntry(0);
        this.unverified = true;
        MapTile mapTile = this.loadTile(string, flashEntry.getTile());
        return mapTile != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearDataCache() {
        Object object = lastCacheDataLock;
        synchronized (object) {
            lastCachedData = null;
            lastFlashRecord = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getLastDataBlockForTest() {
        RuntimeCheck.checkUnitTest();
        Object object = lastCacheDataLock;
        synchronized (object) {
            return lastCachedData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FlashRecord getLastFlashRecordForTest() {
        RuntimeCheck.checkUnitTest();
        Object object = lastCacheDataLock;
        synchronized (object) {
            return lastFlashRecord;
        }
    }
}

