/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.googlenav.map.FlashRecord;
import com.google.googlenav.map.MapTile;
import com.google.googlenav.map.Tile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class FlashEntry {
    private final Tile tile;
    private int time;
    private final int dataSize;
    private static final long TIME_NORMALIZE = 1112219496L;
    private FlashRecord flashRecord;
    static int SIZE_IN_CATALOG = 16;

    public FlashEntry(MapTile mapTile) {
        this(mapTile.getLocation(), mapTile.getLastAccessTime(), mapTile.getDataSize());
    }

    private FlashEntry(Tile tile, long l, int n) {
        this.tile = tile;
        this.setLastAccessTime(l);
        this.dataSize = n;
    }

    public void setFlashRecord(FlashRecord flashRecord) {
        if (this.flashRecord != null) {
            throw new IllegalStateException("FlashRecord already set");
        }
        this.flashRecord = flashRecord;
    }

    public Tile getTile() {
        return this.tile;
    }

    public void setLastAccessTime(long l) {
        this.time = (int)(l / 1000L - 1112219496L);
    }

    public long getLastAccessTime() {
        return ((long)this.time + 1112219496L) * 1000L;
    }

    public int getByteSize() {
        return 12 + this.dataSize;
    }

    public String toString() {
        return this.tile.toString() + "B" + this.getByteSize();
    }

    public FlashRecord getFlashRecord() {
        return this.flashRecord;
    }

    public static FlashEntry readFromCatalog(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = dataInput.readUnsignedShort();
        Tile tile = Tile.read(dataInput);
        return new FlashEntry(tile, n, n2);
    }

    public void writeToCatalog(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.time);
        dataOutput.writeShort(this.dataSize);
        this.tile.write(dataOutput);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FlashEntry)) {
            return false;
        }
        FlashEntry flashEntry = (FlashEntry)object;
        if (this.dataSize != flashEntry.dataSize) {
            return false;
        }
        return this.tile == null ? flashEntry.tile == null : this.tile.equals(flashEntry.tile);
    }

    public int hashCode() {
        int n = this.tile != null ? this.tile.hashCode() : 0;
        n = 29 * n + this.dataSize;
        return n;
    }
}

