/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.layer;

import com.google.common.io.protocol.ProtoBuf;

public class LayerItem {
    private final String layerId;
    private final String itemId;
    private final String name;
    private final String snippet;
    private final boolean isRoutable;
    private final ProtoBuf rating;
    private final int ranking;

    public LayerItem(ProtoBuf protoBuf) {
        this.layerId = protoBuf.getString(1);
        this.itemId = protoBuf.getString(2);
        this.name = protoBuf.has(3) ? protoBuf.getString(3) : "";
        this.snippet = protoBuf.has(4) ? protoBuf.getString(4) : "";
        this.isRoutable = protoBuf.has(5) ? protoBuf.getBool(5) : false;
        this.rating = protoBuf.has(6) ? protoBuf.getProtoBuf(6) : null;
        this.ranking = protoBuf.has(7) ? protoBuf.getInt(7) : 0;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getName() {
        return this.name;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public ProtoBuf getStarRatings() {
        return this.rating;
    }

    public int getRanking() {
        return this.ranking;
    }

    public boolean isRoutable() {
        return this.isRoutable;
    }

    public String toString() {
        return "layerId: " + this.layerId + ", itemId: " + this.itemId + ", name: " + this.name + ", snippet: " + this.snippet;
    }
}

