/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.datarequest;

import com.google.googlenav.datarequest.BaseDataRequest;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SimpleDataRequest
extends BaseDataRequest {
    private final int requestType;
    private final byte[] data;
    private final boolean immediate;
    private final boolean foreground;
    private boolean sent;
    private boolean received;
    private final Object waitObject;

    public SimpleDataRequest(int n, byte[] byArray, boolean bl, boolean bl2) {
        this(n, byArray, bl, bl2, null);
    }

    public SimpleDataRequest(int n, byte[] byArray, boolean bl, boolean bl2, Object object) {
        this.requestType = n;
        this.data = byArray;
        this.immediate = bl;
        this.foreground = bl2;
        this.waitObject = object;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRequestData(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.data);
        this.sent = true;
        if (this.waitObject != null) {
            Object object = this.waitObject;
            synchronized (object) {
                this.waitObject.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readResponseData(DataInput dataInput) throws IOException {
        this.received = true;
        if (this.waitObject != null) {
            Object object = this.waitObject;
            synchronized (object) {
                this.waitObject.notifyAll();
            }
        }
        return true;
    }

    public boolean isReceived() {
        return this.received;
    }

    public boolean isSent() {
        return this.sent;
    }
}

