/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.datarequest;

import com.google.common.Clock;
import com.google.common.Config;
import com.google.common.Log;
import com.google.common.StaticUtil;
import com.google.common.io.HttpConnectionFactory;
import com.google.common.io.PersistentStore;
import com.google.common.io.protocol.ProtoBuf;
import com.google.common.io.protocol.ProtoBufType;
import com.google.common.util.ArrayUtil;
import com.google.common.util.text.TextUtil;
import com.google.googlenav.datarequest.BaseDataRequest;
import com.google.googlenav.datarequest.ClientPropertiesRequest;
import com.google.googlenav.datarequest.ConnectionWarmUpManager;
import com.google.googlenav.datarequest.DataRequest;
import com.google.googlenav.datarequest.DataRequestListener;
import com.google.googlenav.datarequest.NeedsSpecialUrl;
import com.google.googlenav.datarequest.SimpleDataRequest;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class DataRequestDispatcher {
    public static final int PROTOCOL_VERSION = 23;
    private static final String SESSION_ID_PREFERENCE = "SessionID";
    public static final byte HEADER_FULL = 0;
    public static final byte HEADER_SIMPLE = 1;
    public static final byte HEADER_NONE = 2;
    public static final short EVENT_TYPE_TIMING_REPORT = 22;
    private static final String EVENT_DATA_FIRST_BYTE = "fb";
    private static final String EVENT_DATA_LAST_BYTE = "lb";
    protected final String serverAddress;
    protected final String platformID;
    protected final String softwareVersion;
    protected Vector thirdPartyServers = new Vector();
    protected final DispatcherServer defaultServer;
    protected final String distributionChannel;
    protected long cookie;
    protected String globalSpecialUrlArguments;
    private DataRequestListener listenerData;
    protected int bytesSent;
    protected int bytesReceived;
    protected static final long NETWORK_FAILED_TIME = 15000L;
    protected static final int CONNECTION_SPEED_NUMERATOR = 5;
    protected static final int CONNECTION_SPEED_DENOMINATOR = 4;
    protected static final long INITIAL_NETWORK_ERROR_RETRY_TIMEOUT = 200L;
    protected static final long MIN_NETWORK_ERROR_RETRY_TIMEOUT = 2000L;
    protected static final long MAX_NETWORK_ERROR_RETRY_TIMEOUT = 300000L;
    protected static final String CONTENT_TYPE = "application/binary";
    protected volatile boolean active = false;
    private volatile int suspendCount;
    private volatile long lastActiveTime = Long.MIN_VALUE;
    private volatile long lastSuccessTime = Long.MIN_VALUE;
    private volatile boolean networkErrorMode;
    private long errorRetryTime = 0L;
    private long firstConnectionErrorTime = Long.MIN_VALUE;
    private volatile int workerThreadCount = 0;
    private volatile int workerForegroundThreadCount = 0;
    private volatile int workerSubmissionThreadCount = 0;
    private final Object threadDispatchLock = new Object();
    private final ProtoBuf properties;
    protected HttpConnectionFactory connectionFactory;
    private final Clock clock;
    protected final ConnectionWarmUpManager warmUpManager;
    private volatile int networkSpeedBytesPerSecond = -1;
    private static final int MIN_DATA_LENGTH_TO_UPDATE_BPS = 8192;
    private static final int MAX_MSEC_TO_UPDATE_BPS = 60000;
    public static final int MAX_WORKER_THREAD_COUNT = 4;
    public static final long IMMEDIATE_DELAY = 200L;
    private static volatile DataRequestDispatcher instance;

    public static synchronized DataRequestDispatcher createInstance(String string, String string2, String string3, String string4) {
        if (instance != null) {
            throw new RuntimeException("Attempting to create multiple DataRequestDispatchers");
        }
        instance = new DataRequestDispatcher(string, string2, string3, string4);
        Log.setLogSaver((Log.LogSaver)new DataRequestEventUploader(instance));
        return instance;
    }

    public static DataRequestDispatcher getInstance() {
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public static void setInstance(DataRequestDispatcher dataRequestDispatcher) {
        instance = dataRequestDispatcher;
        Log.setLogSaver((Log.LogSaver)new DataRequestEventUploader(instance));
    }

    protected DataRequestDispatcher(String string, String string2, String string3, String string4) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.serverAddress = string;
        this.softwareVersion = string3;
        this.platformID = string2;
        this.distributionChannel = string4;
        this.connectionFactory = Config.getInstance().getConnectionFactory();
        this.clock = Config.getInstance().getClock();
        this.warmUpManager = new ConnectionWarmUpManager(this, this.clock);
        this.bytesSent = 0;
        this.bytesReceived = 0;
        this.defaultServer = new DispatcherServer(this.serverAddress, new Vector(), 0);
        this.cookie = this.loadOrRequestCookie();
        ProtoBufType protoBufType = new ProtoBufType().addElement(540, 1, null).addElement(536, 2, (Object)ProtoBuf.FALSE).addElement(533, 3, null).addElement(536, 4, (Object)ProtoBuf.FALSE).addElement(540, 5, null).addElement(540, 17, null).addElement(540, 18, null).addElement(540, 19, null).addElement(540, 20, null).addElement(536, 21, (Object)ProtoBuf.FALSE);
        this.properties = new ProtoBuf(protoBufType);
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void addThirdPartyServer(String string, int[] nArray, byte by) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            vector.addElement(new Integer(nArray[i]));
        }
        DispatcherServer dispatcherServer = new DispatcherServer(string, vector, by);
        this.thirdPartyServers.addElement(dispatcherServer);
    }

    public synchronized boolean isSuspended() {
        return this.suspendCount > 0;
    }

    public synchronized void suspend() {
        ++this.suspendCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsuspend() {
        DataRequestDispatcher dataRequestDispatcher = this;
        synchronized (dataRequestDispatcher) {
            --this.suspendCount;
            if (this.isSuspended()) {
                return;
            }
        }
        for (int i = 0; i < this.thirdPartyServers.size(); ++i) {
            DispatcherServer dispatcherServer = (DispatcherServer)this.thirdPartyServers.elementAt(i);
            dispatcherServer.activateIfNeeded();
        }
        this.defaultServer.activateIfNeeded();
        this.warmUpManager.onUnsuspend();
    }

    protected long loadOrRequestCookie() {
        DataInput dataInput = StaticUtil.readPreferenceAsDataInput((String)SESSION_ID_PREFERENCE);
        if (dataInput != null) {
            try {
                return dataInput.readLong();
            }
            catch (IOException iOException) {
                Config.getInstance().getPersistentStore().setPreference(SESSION_ID_PREFERENCE, null);
            }
        }
        this.addDataRequest(new CookieDataRequest());
        return 0L;
    }

    public final synchronized void setDataRequestListener(DataRequestListener dataRequestListener) {
        this.listenerData = dataRequestListener;
    }

    protected synchronized DataRequestListener getDataRequestListener() {
        return this.listenerData;
    }

    public synchronized void ageFirstConnectionErrorTimeForTest() {
        this.firstConnectionErrorTime = this.clock.relativeTimeMillis() - 30000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyNetworkError(int n) {
        boolean bl;
        boolean bl2 = false;
        DataRequestListener dataRequestListener = this.getDataRequestListener();
        DataRequestDispatcher dataRequestDispatcher = this;
        synchronized (dataRequestDispatcher) {
            if (!this.networkErrorMode) {
                this.networkErrorMode = true;
                this.firstConnectionErrorTime = Long.MIN_VALUE;
                bl2 = true;
            }
        }
        boolean bl3 = this.connectionFactory.getNetworkWorked();
        boolean bl4 = bl = n == 3 && bl3;
        if (!bl && bl2 && dataRequestListener != null) {
            dataRequestListener.onNetworkError(n, bl3);
        }
    }

    public void addDataRequest(DataRequest dataRequest) {
        for (int i = 0; i < this.thirdPartyServers.size(); ++i) {
            DispatcherServer dispatcherServer = (DispatcherServer)this.thirdPartyServers.elementAt(i);
            if (!dispatcherServer.canHandle(dataRequest.getRequestType())) continue;
            dispatcherServer.addDataRequest(dataRequest);
            return;
        }
        this.defaultServer.addDataRequest(dataRequest);
    }

    public synchronized boolean isRequestActive() {
        return this.workerThreadCount > 0;
    }

    public synchronized boolean isForegroundRequestActive() {
        return this.workerForegroundThreadCount > 0;
    }

    public synchronized boolean isSubmissionRequestActive() {
        return this.workerSubmissionThreadCount > 0;
    }

    public synchronized boolean isNetworkErrorMode() {
        return this.networkErrorMode;
    }

    public synchronized boolean canDispatchNow() {
        return this.active && this.workerThreadCount < MAX_WORKER_THREAD_COUNT && (this.connectionFactory.getNetworkWorkedThisSession() || this.workerThreadCount == 0);
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public long getLastSuccessTime() {
        return this.lastSuccessTime;
    }

    public final int getBytesSent() {
        return this.bytesSent;
    }

    public final int getBytesReceived() {
        return this.bytesReceived;
    }

    public int getNetworkSpeedBytesPerSecond() {
        return this.networkSpeedBytesPerSecond;
    }

    public static String formatKb(long l) {
        return TextUtil.formatMessage((String)"{0}KB", (String)String.valueOf((l + 512L) / 1024L));
    }

    public void stop() {
        this.active = false;
    }

    public void start() {
        this.active = true;
        for (int i = 0; i < this.thirdPartyServers.size(); ++i) {
            ((DispatcherServer)this.thirdPartyServers.elementAt(i)).start();
        }
        this.defaultServer.start();
    }

    protected final void addDataRequests(Vector vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            this.addDataRequest((DataRequest)vector.elementAt(i));
        }
    }

    private synchronized void clearNetworkError() {
        this.firstConnectionErrorTime = Long.MIN_VALUE;
        this.networkErrorMode = false;
        this.errorRetryTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(int n) {
        boolean bl = false;
        DataRequestDispatcher dataRequestDispatcher = this;
        synchronized (dataRequestDispatcher) {
            this.connectionFactory.notifyFailure();
            if (!this.networkErrorMode) {
                this.errorRetryTime = 200L;
                if (this.firstConnectionErrorTime == Long.MIN_VALUE) {
                    this.firstConnectionErrorTime = this.clock.relativeTimeMillis();
                } else if (this.firstConnectionErrorTime + 15000L < this.clock.relativeTimeMillis()) {
                    bl = true;
                }
            } else {
                this.errorRetryTime = this.errorRetryTime < 2000L ? 2000L : this.errorRetryTime * (long)CONNECTION_SPEED_NUMERATOR / (long)CONNECTION_SPEED_DENOMINATOR;
                if (this.errorRetryTime > 300000L) {
                    this.errorRetryTime = 300000L;
                }
            }
        }
        if (bl) {
            if (n == 3 && this.connectionFactory.usingMDS() && !this.connectionFactory.getNetworkWorked()) {
                n = 4;
            }
            this.notifyNetworkError(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void serviceRequests(Vector var1_1, DispatcherServer var2_2) throws IOException, SecurityException {
        block65: {
            block64: {
                block63: {
                    block53: {
                        block62: {
                            block61: {
                                block60: {
                                    block52: {
                                        block59: {
                                            block58: {
                                                block57: {
                                                    block51: {
                                                        var3_3 = null;
                                                        var4_4 = null;
                                                        var5_5 = false;
                                                        var6_6 = null;
                                                        this.warmUpManager.onStartServiceRequests(var1_1);
                                                        var7_7 = new ByteArrayOutputStream();
                                                        var8_8 = this.urlArguments(var1_1);
                                                        this.generateRequest(var1_1, var7_7, var2_2);
                                                        var9_9 = var7_7.toByteArray();
                                                        var7_7 = null;
                                                        try {
                                                            try {
                                                                var12_10 = this.clock.relativeTimeMillis();
                                                                var3_3 = this.connectionFactory.createConnection(var2_2.serverAddress + var8_8, true);
                                                                var3_3.setConnectionProperty("Content-Type", "application/binary");
                                                                var3_3.setConnectionProperty("Content-Length", "" + var9_9.length);
                                                                var4_4 = var3_3.openDataOutputStream();
                                                                var4_4.write(var9_9);
                                                                this.bytesSent += var9_9.length;
                                                                var6_6 = var3_3.openDataInputStream();
                                                                var10_11 = var3_3.getResponseCode();
                                                                var11_12 = var3_3.getContentType();
                                                                var14_13 = this.clock.relativeTimeMillis() - var12_10;
                                                            }
                                                            catch (IOException var16_14) {
                                                                if (DataRequestDispatcher.isSprintNetworkAccessDenied(var16_14)) {
                                                                    var5_5 = true;
                                                                }
                                                                throw var16_14;
                                                            }
                                                            catch (SecurityException var16_15) {
                                                                throw var16_15;
                                                            }
                                                            if (var10_11 == 501) {
                                                                this.notifyNetworkError(2);
                                                                var22_17 = null;
                                                                break block51;
                                                            }
                                                            if (var10_11 != 200) {
                                                                throw new IOException("Bad HTTP response code: " + var10_11);
                                                            }
                                                            if (!"application/binary".equals(var11_12)) {
                                                                throw new IOException("Bad HTTP content type: " + var11_12);
                                                            }
                                                            var16_16 = (int)var3_3.getLength();
                                                            this.bytesReceived += var16_16;
                                                            var17_33 = var6_6.readUnsignedShort();
                                                            if (var17_33 != 23) {
                                                                this.notifyNetworkError(1);
                                                                break block52;
                                                            }
                                                            for (var18_34 = 0; var18_34 < var1_1.size(); ++var18_34) {
                                                                try {
                                                                    this.processDataRequest((DataInput)var6_6, (DataRequest)var1_1.elementAt(var18_34), var2_2);
                                                                    continue;
                                                                }
                                                                catch (IOException var19_36) {
                                                                    var20_37 = 0;
                                                                    while (true) {
                                                                        if (var20_37 >= var18_34) {
                                                                            throw var19_36;
                                                                        }
                                                                        var1_1.removeElementAt(0);
                                                                        ++var20_37;
                                                                    }
                                                                }
                                                            }
                                                            var18_35 = this.clock.relativeTimeMillis();
                                                            var20_38 = (int)(var18_35 - var12_10);
                                                            Log.addEvent((short)22, (String)"fb", (String)("" + var14_13));
                                                            Log.addEvent((short)22, (String)"lb", (String)("" + var20_38));
                                                            this.warmUpManager.onFinishServiceRequests(var1_1, var12_10, (int)var14_13, var20_38);
                                                            if (var16_16 >= 8192 && var20_38 <= 60000) {
                                                                this.networkSpeedBytesPerSecond = var16_16 * 1000 / var20_38;
                                                            }
                                                            var1_1.removeAllElements();
                                                            break block53;
                                                        }
                                                        catch (Throwable var21_39) {
                                                            var22_20 = null;
                                                            try {
                                                                if (var6_6 != null) {
                                                                    var6_6.close();
                                                                }
                                                            }
                                                            catch (IOException var23_27) {
                                                                // empty catch block
                                                            }
                                                            try {
                                                                if (var4_4 != null && !var5_5) {
                                                                    var4_4.close();
                                                                }
                                                            }
                                                            catch (IOException var23_27) {
                                                                // empty catch block
                                                            }
                                                            try {
                                                                if (var3_3 != null) {
                                                                    var3_3.close();
                                                                }
                                                            }
                                                            catch (IOException var23_27) {
                                                                // empty catch block
                                                            }
                                                            var23_28 = 0;
                                                            while (true) {
                                                                if (var23_28 >= var1_1.size()) {
                                                                    throw var21_39;
                                                                }
                                                                var24_32 = (DataRequest)var1_1.elementAt(var23_28);
                                                                if (!var24_32.retryOnFailure()) {
                                                                    var1_1.removeElement(var24_32);
                                                                }
                                                                ++var23_28;
                                                            }
                                                        }
                                                    }
                                                    ** try [egrp 3[TRYBLOCK] [7 : 560->573)] { 
lbl107:
                                                    // 1 sources

                                                    if (var6_6 != null) {
                                                        var6_6.close();
                                                    }
                                                    break block57;
lbl110:
                                                    // 1 sources

                                                    catch (IOException var23_21) {
                                                        // empty catch block
                                                    }
                                                }
                                                ** try [egrp 4[TRYBLOCK] [8 : 575->593)] { 
lbl114:
                                                // 1 sources

                                                if (var4_4 != null && !var5_5) {
                                                    var4_4.close();
                                                }
                                                break block58;
lbl117:
                                                // 1 sources

                                                catch (IOException var23_21) {
                                                    // empty catch block
                                                }
                                            }
                                            ** try [egrp 5[TRYBLOCK] [9 : 595->608)] { 
lbl121:
                                            // 1 sources

                                            if (var3_3 != null) {
                                                var3_3.close();
                                            }
                                            break block59;
lbl124:
                                            // 1 sources

                                            catch (IOException var23_21) {
                                                // empty catch block
                                            }
                                        }
                                        for (var23_22 = 0; var23_22 < var1_1.size(); ++var23_22) {
                                            var24_29 = (DataRequest)var1_1.elementAt(var23_22);
                                            if (var24_29.retryOnFailure()) continue;
                                            var1_1.removeElement(var24_29);
                                        }
                                        return;
                                    }
                                    var22_18 = null;
                                    ** try [egrp 3[TRYBLOCK] [7 : 560->573)] { 
lbl137:
                                    // 1 sources

                                    if (var6_6 != null) {
                                        var6_6.close();
                                    }
                                    break block60;
lbl140:
                                    // 1 sources

                                    catch (IOException var23_23) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 4[TRYBLOCK] [8 : 575->593)] { 
lbl144:
                                // 1 sources

                                if (var4_4 != null && !var5_5) {
                                    var4_4.close();
                                }
                                break block61;
lbl147:
                                // 1 sources

                                catch (IOException var23_23) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 5[TRYBLOCK] [9 : 595->608)] { 
lbl151:
                            // 1 sources

                            if (var3_3 != null) {
                                var3_3.close();
                            }
                            break block62;
lbl154:
                            // 1 sources

                            catch (IOException var23_23) {
                                // empty catch block
                            }
                        }
                        for (var23_24 = 0; var23_24 < var1_1.size(); ++var23_24) {
                            var24_30 = (DataRequest)var1_1.elementAt(var23_24);
                            if (var24_30.retryOnFailure()) continue;
                            var1_1.removeElement(var24_30);
                        }
                        return;
                    }
                    var22_19 = null;
                    ** try [egrp 3[TRYBLOCK] [7 : 560->573)] { 
lbl167:
                    // 1 sources

                    if (var6_6 != null) {
                        var6_6.close();
                    }
                    break block63;
lbl170:
                    // 1 sources

                    catch (IOException var23_25) {
                        // empty catch block
                    }
                }
                ** try [egrp 4[TRYBLOCK] [8 : 575->593)] { 
lbl174:
                // 1 sources

                if (var4_4 != null && !var5_5) {
                    var4_4.close();
                }
                break block64;
lbl177:
                // 1 sources

                catch (IOException var23_25) {
                    // empty catch block
                }
            }
            ** try [egrp 5[TRYBLOCK] [9 : 595->608)] { 
lbl181:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            break block65;
lbl184:
            // 1 sources

            catch (IOException var23_25) {
                // empty catch block
            }
        }
        var23_26 = 0;
        while (true) {
            if (var23_26 >= var1_1.size()) {
                return;
            }
            var24_31 = (DataRequest)var1_1.elementAt(var23_26);
            if (!var24_31.retryOnFailure()) {
                var1_1.removeElement(var24_31);
            }
            ++var23_26;
        }
    }

    protected void processDataRequest(DataInput dataInput, DataRequest dataRequest, DispatcherServer dispatcherServer) throws IOException {
        int n = dataInput.readUnsignedByte();
        if (n != dataRequest.getRequestType()) {
            throw new IOException("RT: " + n + " != " + dataRequest.getRequestType());
        }
        DataRequestListener dataRequestListener = this.getDataRequestListener();
        if (dataRequest.readResponseData(dataInput)) {
            if (dataRequestListener != null && dataRequest != this && !dataRequest.isCancelled()) {
                dataRequestListener.onComplete(dataRequest);
            }
        } else {
            dispatcherServer.serverRequests.insertElementAt(dataRequest, 0);
        }
    }

    public void generateRequest(Vector vector, OutputStream outputStream, DispatcherServer dispatcherServer) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.addClientPropertiesRequest(vector, dispatcherServer);
        if (dispatcherServer.headerFlag == 0) {
            dataOutputStream.writeShort(23);
            dataOutputStream.writeLong(this.cookie);
            dataOutputStream.writeUTF(Config.getLocale());
            dataOutputStream.writeUTF(this.platformID);
            dataOutputStream.writeUTF(this.softwareVersion);
            dataOutputStream.writeUTF(this.distributionChannel);
        } else if (dispatcherServer.headerFlag == 1) {
            dataOutputStream.writeShort(23);
            dataOutputStream.writeLong(this.cookie);
            dataOutputStream.writeUTF("");
            dataOutputStream.writeUTF("");
            dataOutputStream.writeUTF("");
            dataOutputStream.writeUTF("");
        }
        for (int i = 0; i < vector.size(); ++i) {
            DataRequest dataRequest = (DataRequest)vector.elementAt(i);
            dataOutputStream.writeByte(dataRequest.getRequestType());
            dataRequest.writeRequestData(dataOutputStream);
        }
        dataOutputStream.flush();
    }

    private void addClientPropertiesRequest(Vector vector, DispatcherServer dispatcherServer) {
        if (dispatcherServer.canHandle(62)) {
            ClientPropertiesRequest clientPropertiesRequest = new ClientPropertiesRequest(this.properties);
            if (vector.size() > 0) {
                DataRequest dataRequest = (DataRequest)vector.elementAt(0);
                if (dataRequest instanceof ClientPropertiesRequest) {
                    vector.setElementAt(clientPropertiesRequest, 0);
                } else {
                    vector.insertElementAt(clientPropertiesRequest, 0);
                }
            } else {
                vector.insertElementAt(clientPropertiesRequest, 0);
            }
        }
    }

    public final void addSimpleRequest(int n, byte[] byArray, boolean bl, boolean bl2) {
        this.addDataRequest(new SimpleDataRequest(n, byArray, bl, bl2));
    }

    protected static boolean containsForegroundRequest(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            DataRequest dataRequest = (DataRequest)vector.elementAt(i);
            if (!dataRequest.isForeground()) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsSubmissionRequest(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            DataRequest dataRequest = (DataRequest)vector.elementAt(i);
            if (!dataRequest.isSubmission()) continue;
            return true;
        }
        return false;
    }

    static void saveCookie(long l) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(l);
            PersistentStore persistentStore = Config.getInstance().getPersistentStore();
            persistentStore.setPreference(SESSION_ID_PREFERENCE, byteArrayOutputStream.toByteArray());
            persistentStore.savePreferences();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    protected String urlArguments(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "?";
        if (!TextUtil.isEmpty((String)this.globalSpecialUrlArguments)) {
            stringBuffer.append(string);
            stringBuffer.append(this.globalSpecialUrlArguments);
            string = "&";
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string2;
            DataRequest dataRequest = (DataRequest)vector.elementAt(i);
            if (!(dataRequest instanceof NeedsSpecialUrl) || TextUtil.isEmpty((String)(string2 = ((NeedsSpecialUrl)((Object)dataRequest)).getParams()))) continue;
            stringBuffer.append(string);
            stringBuffer.append(string2);
            string = "&";
        }
        String string3 = stringBuffer.toString();
        if (!TextUtil.isEmpty((String)string3)) {
            // empty if block
        }
        return string3;
    }

    public void setGlobalSpecialUrlArguments(String string) {
        this.globalSpecialUrlArguments = string;
    }

    public long getCookie() {
        return this.cookie;
    }

    public void setVoiceSearch(boolean bl) {
        this.properties.setBool(21, bl);
    }

    public void setGaiaAuthToken(String string) {
        this.properties.setString(20, string);
    }

    public void setGzipEnabled(boolean bl) {
        this.properties.setBool(4, bl);
    }

    public void setAndroidMapKey(String string) {
        this.properties.setString(17, string);
    }

    public void setAndroidSignature(String string) {
        this.properties.setString(18, string);
    }

    public void setAndroidLoggingId2(String string) {
        this.properties.setString(19, string);
    }

    public void setApplicationName(String string) {
        this.properties.setString(5, string);
    }

    public void setGpsEnabled(boolean bl) {
        this.properties.setBool(2, bl);
    }

    public void setMobileCountryCode(int n) {
        this.properties.setInt(3, n);
    }

    protected static boolean isSprintNetworkAccessDenied(IOException iOException) {
        String string = iOException.getMessage();
        return string != null && (string.equals("Network can't access") || string.equals("Network unavailable due to Network Guard setting") || string.equals("Network unavailable due to Data Roam Guard setting"));
    }

    public void resetConnectionFactory() {
        this.connectionFactory = Config.getInstance().getConnectionFactory();
    }

    public void warmUpConnection(String string) {
        if (!this.active || !this.connectionFactory.getNetworkWorked()) {
            return;
        }
        this.warmUpManager.warmUp(string);
    }

    public static final class DataRequestEventUploader
    implements Log.LogSaver {
        public static final int EVENT_LOG_REQUEST_TYPE = 10;
        private static final int EXCEPTION_REQUEST_ID = 8;
        private final DataRequestDispatcher drd;

        private DataRequestEventUploader(DataRequestDispatcher dataRequestDispatcher) {
            this.drd = dataRequestDispatcher;
        }

        public Object uploadEventLog(boolean bl, Object object, byte[] byArray) {
            SimpleDataRequest simpleDataRequest = null;
            if (byArray != null && byArray.length > 2) {
                simpleDataRequest = new SimpleDataRequest(10, byArray, bl, false, object);
                DataRequestDispatcher dataRequestDispatcher = DataRequestDispatcher.getInstance();
                if (dataRequestDispatcher != null) {
                    dataRequestDispatcher.addDataRequest(simpleDataRequest);
                } else {
                    return null;
                }
            }
            return null;
        }

        public void uploadException(boolean bl, String string, Throwable throwable, Log.Printer printer) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                String string2 = bl ? " Q=Y" : " Q=N";
                dataOutputStream.writeUTF(string + " #" + "3200" + string2);
                dataOutputStream.writeUTF(throwable.getClass().toString());
                dataOutputStream.writeUTF(printer.getThrowableDetails(throwable));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            this.drd.addSimpleRequest(8, byteArrayOutputStream.toByteArray(), true, false);
        }
    }

    public class DispatcherServer
    implements Runnable {
        protected final String serverAddress;
        protected final Vector supportedDataRequests;
        protected final byte headerFlag;
        protected Vector serverRequests = new Vector();
        private Vector tempRequests;

        protected boolean canHandle(int n) {
            return this.supportedDataRequests.isEmpty() || this.supportedDataRequests.contains(new Integer(n));
        }

        public DispatcherServer(String string, Vector vector, byte by) {
            this.serverAddress = string;
            this.supportedDataRequests = vector;
            this.headerFlag = by;
        }

        public void addDataRequest(DataRequest dataRequest) {
            this.serverRequests.addElement(dataRequest);
            if (dataRequest.isImmediate() && !DataRequestDispatcher.this.isSuspended()) {
                this.activate();
            }
        }

        protected final void addDataRequests(Vector vector, int n) {
            ArrayUtil.copyIntoVector((Vector)vector, (int)n, (Vector)this.serverRequests);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Vector dequeuePendingRequests() {
            Vector vector;
            DispatcherServer dispatcherServer = this;
            synchronized (dispatcherServer) {
                vector = this.serverRequests;
                this.serverRequests = new Vector();
            }
            return vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void activate() {
            if (!DataRequestDispatcher.this.canDispatchNow()) {
                return;
            }
            Object object = DataRequestDispatcher.this.threadDispatchLock;
            synchronized (object) {
                this.tempRequests = this.dequeuePendingRequests();
                if (this.tempRequests != null) {
                    DataRequestDispatcher.this.workerThreadCount++;
                    if (DataRequestDispatcher.containsForegroundRequest(this.tempRequests)) {
                        DataRequestDispatcher.this.workerForegroundThreadCount++;
                    }
                    if (DataRequestDispatcher.containsSubmissionRequest(this.tempRequests)) {
                        DataRequestDispatcher.this.workerSubmissionThreadCount++;
                    }
                    new Thread(this).start();
                    while (this.tempRequests != null) {
                        try {
                            DataRequestDispatcher.this.threadDispatchLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        protected void activateIfNeeded() {
            if (this.checkNeedToActivate()) {
                this.activate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkNeedToActivate() {
            if (DataRequestDispatcher.this.isSuspended()) {
                return false;
            }
            Vector vector = this.serverRequests;
            synchronized (vector) {
                for (int i = 0; i < this.serverRequests.size(); ++i) {
                    DataRequest dataRequest = (DataRequest)this.serverRequests.elementAt(i);
                    if (!dataRequest.isImmediate()) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            Vector vector;
            Object object2 = DataRequestDispatcher.this.threadDispatchLock;
            synchronized (object2) {
                vector = this.tempRequests;
                this.tempRequests = null;
                DataRequestDispatcher.this.lastActiveTime = DataRequestDispatcher.this.clock.relativeTimeMillis();
                DataRequestDispatcher.this.threadDispatchLock.notifyAll();
            }
            boolean bl = false;
            boolean bl2 = false;
            try {
                while (DataRequestDispatcher.this.active && vector.size() > 0) {
                    object = this;
                    synchronized (object) {
                        if (DataRequestDispatcher.this.errorRetryTime > 0L) {
                            try {
                                this.wait(DataRequestDispatcher.this.errorRetryTime);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        bl = DataRequestDispatcher.containsForegroundRequest(vector);
                        bl2 = DataRequestDispatcher.containsSubmissionRequest(vector);
                        DataRequestDispatcher.this.serviceRequests(vector, this);
                        DataRequestDispatcher.this.connectionFactory.registerNetworkSuccess(false);
                        DataRequestDispatcher.this.clearNetworkError();
                        DataRequestDispatcher.this.lastSuccessTime = DataRequestDispatcher.this.clock.relativeTimeMillis();
                    }
                    catch (SecurityException securityException) {
                        this.networkAccessDenied(securityException);
                    }
                    catch (IOException iOException) {
                        if (DataRequestDispatcher.isSprintNetworkAccessDenied(iOException)) {
                            this.networkAccessDenied(iOException);
                            continue;
                        }
                        DataRequestDispatcher.this.handleError(3);
                    }
                    catch (Exception exception) {
                        DataRequestDispatcher.this.handleError(5);
                        Log.logThrowable((String)"REQUEST", (Throwable)exception);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        StaticUtil.handleOutOfMemory();
                        DataRequestDispatcher.this.handleError(5);
                    }
                }
            }
            finally {
                object = DataRequestDispatcher.this.threadDispatchLock;
                synchronized (object) {
                    DataRequestDispatcher.this.workerThreadCount--;
                    if (bl) {
                        DataRequestDispatcher.this.workerForegroundThreadCount--;
                    }
                    if (bl2) {
                        DataRequestDispatcher.this.workerSubmissionThreadCount--;
                    }
                }
                this.activateIfNeeded();
            }
        }

        private void networkAccessDenied(Exception exception) {
            Log.logQuietThrowable((String)"REQUEST", (Throwable)exception);
            DataRequestDispatcher.this.stop();
            DataRequestDispatcher.this.notifyNetworkError(0);
        }

        public void start() {
            this.activateIfNeeded();
        }
    }

    private class CookieDataRequest
    extends BaseDataRequest {
        private static final int COOKIE_DATA_REQUEST_ID = 15;

        private CookieDataRequest() {
        }

        public int getRequestType() {
            return 15;
        }

        public boolean isImmediate() {
            return false;
        }

        public void writeRequestData(DataOutput dataOutput) throws IOException {
        }

        public boolean readResponseData(DataInput dataInput) throws IOException {
            DataRequestDispatcher.this.cookie = dataInput.readLong();
            DataRequestDispatcher.saveCookie(DataRequestDispatcher.this.cookie);
            return true;
        }
    }
}

