/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.datarequest;

import com.google.common.Clock;
import com.google.common.Config;
import com.google.common.Log;
import com.google.googlenav.datarequest.DataRequestDispatcher;

public class ConnectionWarmUpManager {
    public static final short EVENT_TYPE_WARM_UP = 64;
    static final String EVENT_STATUS_WARM_UP_NOT_SENT = "ns";
    static final String EVENT_STATUS_WARM_UP_SENT = "s";
    static final String EVENT_STATUS_WARM_UP_USED = "u";
    static final String EVENT_STATUS_WARM_UP_OVERRIDDEN = "o";
    static final String EVENT_STATUS_WARM_UP_FAILED = "f";
    static final String EVENT_DATA_WARM_UP_DELTA = "d";
    static final String EVENT_DATA_WARM_UP_SOURCE = "s";
    static final String EVENT_DATA_WARM_UP_REASON = "r";
    static final String EVENT_DATA_WARM_UP_REASON_ACTIVE = "a";
    static final String EVENT_DATA_WARM_UP_REASON_DUPLICATE = "d";
    private int state = 0;
    private static final int STATE_IDLE = 0;
    private static final int STATE_WARM_UP_QUEUED = 1;
    private static final int STATE_WARM_UP_SENT = 2;
    private static final int STATE_CONNECTION_STARTED = 3;
    private String requestSource = null;
    private String pendingSource = null;
    private long pendingWarmUpTime;
    private Object pendingKey;
    public static final int EXPERIMENT_NUM_GROUPS = 4;
    public static final int EXPERIMENT_GROUP_NONE = 0;
    public static final int EXPERIMENT_GROUP_5_SECONDS = 1;
    public static final int EXPERIMENT_GROUP_7_SECONDS = 2;
    public static final int EXPERIMENT_GROUP_9_SECONDS = 3;
    private DataRequestDispatcher drd;
    private Clock clock;

    public ConnectionWarmUpManager(DataRequestDispatcher dataRequestDispatcher, Clock clock) {
        this.drd = dataRequestDispatcher;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmUp(String string) {
        if (!this.shouldWarmUp()) {
            return;
        }
        if ("WiFi".equals(Config.getInstance().getNetworkType())) {
            return;
        }
        ConnectionWarmUpManager connectionWarmUpManager = this;
        synchronized (connectionWarmUpManager) {
            if (this.requestSource != null) {
                this.logNotSent(string, "d");
                return;
            }
            this.requestSource = string;
        }
        if (!this.drd.isSuspended()) {
            this.warmUpIfNeeded();
        }
    }

    public void onUnsuspend() {
        this.warmUpIfNeeded();
    }

    private boolean canTriggerWarmUp() {
        if (this.drd.isRequestActive()) {
            return false;
        }
        long l = this.clock.relativeTimeMillis();
        long l2 = Math.max(this.drd.getLastSuccessTime(), this.drd.getLastActiveTime());
        return l2 == Long.MIN_VALUE || l - l2 >= (long)this.getWarmUpMinimumIdleTime();
    }

    int getWarmUpMinimumIdleTime() {
        switch (this.getExperimentGroup()) {
            default: {
                return 5000;
            }
            case 2: {
                return 7000;
            }
            case 3: 
        }
        return 9000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warmUpIfNeeded() {
        ConnectionWarmUpManager connectionWarmUpManager = this;
        synchronized (connectionWarmUpManager) {
            if (this.requestSource == null) {
                return;
            }
            if (!this.canTriggerWarmUp()) {
                this.logNotSent(this.requestSource, EVENT_DATA_WARM_UP_REASON_ACTIVE);
                this.requestSource = null;
                return;
            }
            long l = this.clock.relativeTimeMillis();
            switch (this.state) {
                case 1: {
                    this.logNotSent(this.requestSource, "d");
                    this.requestSource = null;
                    return;
                }
                case 2: {
                    this.logOverridden(this.pendingSource, l - this.pendingWarmUpTime);
                    break;
                }
                case 3: {
                    this.logFailed(this.pendingSource);
                    break;
                }
            }
            this.pendingSource = this.requestSource;
            this.requestSource = null;
            this.state = 1;
        }
        this.logSent(this.pendingSource);
        Log.uploadEventLog((boolean)true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartServiceRequests(Object object) {
        ConnectionWarmUpManager connectionWarmUpManager = this;
        synchronized (connectionWarmUpManager) {
            if (this.state == 1) {
                this.state = 2;
                this.pendingWarmUpTime = this.clock.relativeTimeMillis();
            } else if (this.state == 2) {
                this.state = 3;
                this.pendingKey = object;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinishServiceRequests(Object object, long l, int n, int n2) {
        long l2;
        String string;
        ConnectionWarmUpManager connectionWarmUpManager = this;
        synchronized (connectionWarmUpManager) {
            if (this.state != 3 || this.pendingKey != object) {
                return;
            }
            this.state = 0;
            string = this.pendingSource;
            l2 = this.pendingWarmUpTime;
            this.pendingKey = null;
        }
        int n3 = (int)(l - l2);
        this.logUsed(string, n3, n, n2);
    }

    private void logSent(String string) {
        this.logWithSource("s", string, "");
    }

    private void logUsed(String string, int n, int n2, int n3) {
        String string2 = "|d=" + n + "|fb=" + n2 + "|lb=" + n3 + "|";
        this.logWithSource(EVENT_STATUS_WARM_UP_USED, string, string2);
    }

    private void logNotSent(String string, String string2) {
        String string3 = "|r=" + string2 + "|";
        this.logWithSource(EVENT_STATUS_WARM_UP_NOT_SENT, string, string3);
    }

    private void logOverridden(String string, long l) {
        String string2 = "|d=" + l + "|";
        this.logWithSource(EVENT_STATUS_WARM_UP_OVERRIDDEN, string, string2);
    }

    private void logFailed(String string) {
        this.logWithSource(EVENT_STATUS_WARM_UP_FAILED, string, "");
    }

    private void logWithSource(String string, String string2, String string3) {
        String string4 = "|s=" + string2 + (string3.length() == 0 ? "|" : "") + string3;
        Log.addEvent((short)64, (String)string, (String)string4);
    }

    private int getExperimentGroup() {
        return (int)Math.abs(this.drd.getCookie() % 4L);
    }

    private boolean shouldWarmUp() {
        return this.getExperimentGroup() != 0;
    }
}

