/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.datarequest;

import com.google.common.StaticUtil;
import com.google.common.io.protocol.ProtoBuf;
import com.google.common.io.protocol.ProtoBufType;
import com.google.common.io.protocol.ProtoBufUtil;
import com.google.common.util.RuntimeCheck;
import com.google.googlenav.datarequest.BaseDataRequest;
import com.google.googlenav.proto.GmmMessageTypes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClientPropertiesRequest
extends BaseDataRequest {
    public static final int REQUEST_ID = 62;
    private static final String COHORT_PREFERENCE = "Cohort";
    private final ProtoBuf properties;

    public ClientPropertiesRequest(ProtoBuf protoBuf) {
        String string;
        this.properties = protoBuf;
        if (!protoBuf.has(1) && (string = this.readCohortFromFlash()) != null) {
            protoBuf.setString(1, string);
        }
    }

    public int getRequestType() {
        return 62;
    }

    public boolean isImmediate() {
        return false;
    }

    public boolean isForeground() {
        return false;
    }

    public void writeRequestData(DataOutput dataOutput) throws IOException {
        ProtoBufUtil.writeProtoBufToOutput((DataOutput)dataOutput, (ProtoBuf)this.properties);
    }

    public boolean readResponseData(DataInput dataInput) throws IOException {
        ProtoBuf protoBuf = ProtoBufUtil.readProtoBufResponse((ProtoBufType)GmmMessageTypes.CLIENT_PROPERTIES_RESPONSE_PROTO, (DataInput)dataInput);
        if (protoBuf.has(1)) {
            String string = protoBuf.getString(1);
            this.properties.setString(1, string);
            StaticUtil.savePreferenceAsString((String)COHORT_PREFERENCE, (String)string);
        }
        return true;
    }

    private String readCohortFromFlash() {
        return StaticUtil.readPreferenceAsString((String)COHORT_PREFERENCE);
    }

    static void writeCohortForTest(String string) {
        RuntimeCheck.checkUnitTest();
        StaticUtil.savePreferenceAsString((String)COHORT_PREFERENCE, (String)string);
    }
}

