/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav;

import com.google.common.Config;
import com.google.common.Log;
import com.google.common.StaticUtil;
import com.google.common.util.RuntimeCheck;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class Stats {
    private static Stats currentInstance;
    private int flashCacheHits = 0;
    private int flashCacheMisses = 0;
    private int flashCacheHitsSinceLastLog = 0;
    private int flashCacheMissesSinceLastLog = 0;
    private int bytesDownloaded = 0;
    private int bytesUploaded = 0;
    public static final int AD_CLICK_TYPE_CALL = 1;
    public static final int AD_CLICK_TYPE_URL = 2;
    private static final String STATS_RECORD_STORE = "Stats";
    static final int FLASH_CACHE_LOG_THRESHOLD = 50;

    private Stats() {
    }

    public static synchronized void save() {
        if (currentInstance != null) {
            currentInstance.write();
            currentInstance.log(true);
        }
    }

    public static synchronized Stats getInstance() {
        if (currentInstance == null && (currentInstance = Stats.read()) == null) {
            currentInstance = new Stats();
        }
        return currentInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flashCacheHit() {
        Stats stats = this;
        synchronized (stats) {
            ++this.flashCacheHits;
            ++this.flashCacheHitsSinceLastLog;
        }
        this.log(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flashCacheMiss() {
        Stats stats = this;
        synchronized (stats) {
            ++this.flashCacheMisses;
            ++this.flashCacheMissesSinceLastLog;
        }
        this.log(false);
    }

    public synchronized void addBytesUploaded(int n) {
        this.bytesUploaded += n;
    }

    public synchronized void addBytesDownloaded(int n) {
        this.bytesDownloaded += n;
    }

    public void printStats() {
        if (this.flashCacheHits + this.flashCacheMisses > 0) {
            // empty if block
        }
    }

    private static Stats read() {
        Stats stats = null;
        DataInput dataInput = StaticUtil.readPreferenceAsDataInput((String)STATS_RECORD_STORE);
        if (dataInput != null) {
            try {
                stats = new Stats();
                stats.flashCacheHits = dataInput.readInt();
                stats.flashCacheMisses = dataInput.readInt();
                stats.bytesDownloaded = dataInput.readInt();
                stats.bytesUploaded = dataInput.readInt();
            }
            catch (IOException iOException) {
                Log.logThrowable((String)"STATS", (Throwable)iOException);
                stats = null;
                Config.getInstance().getPersistentStore().deleteBlock(STATS_RECORD_STORE);
            }
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            Object object = this;
            synchronized (object) {
                dataOutputStream.writeInt(this.flashCacheHits);
                dataOutputStream.writeInt(this.flashCacheMisses);
                dataOutputStream.writeInt(this.bytesDownloaded);
                dataOutputStream.writeInt(this.bytesUploaded);
            }
            object = byteArrayOutputStream.toByteArray();
            dataOutputStream = null;
            byteArrayOutputStream = null;
            Config.getInstance().getPersistentStore().setPreference(STATS_RECORD_STORE, (byte[])object);
        }
        catch (IOException iOException) {
            Log.logThrowable((String)"STATS", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(boolean bl) {
        int n;
        int n2;
        int n3 = bl ? 0 : 50;
        Object object = this;
        synchronized (object) {
            n2 = this.flashCacheHitsSinceLastLog;
            n = this.flashCacheMissesSinceLastLog;
            if (n2 + n > n3) {
                this.flashCacheHitsSinceLastLog = 0;
                this.flashCacheMissesSinceLastLog = 0;
            }
        }
        if (n2 + n > n3) {
            object = new StringBuffer();
            if (n2 > 0) {
                ((StringBuffer)object).append("|");
                ((StringBuffer)object).append("f");
                ((StringBuffer)object).append("=");
                ((StringBuffer)object).append(n2);
            }
            if (n > 0) {
                ((StringBuffer)object).append("|");
                ((StringBuffer)object).append("m");
                ((StringBuffer)object).append("=");
                ((StringBuffer)object).append(n);
            }
            ((StringBuffer)object).append("|");
            Log.addEvent((short)22, (String)"c", (String)((StringBuffer)object).toString());
        }
    }

    public synchronized int getFlashCacheHits() {
        return this.flashCacheHits;
    }

    public synchronized int getFlashCacheMisses() {
        return this.flashCacheMisses;
    }

    public synchronized int getBytesDownloaded() {
        return this.bytesDownloaded;
    }

    public synchronized int getBytesUploaded() {
        return this.bytesUploaded;
    }

    static synchronized void setInstanceForTest(Stats stats) {
        RuntimeCheck.checkUnitTest();
        currentInstance = stats;
    }
}

