/*
 * Decompiled with CFR 0.152.
 */
package com.google.debug;

public class DebugUtil {
    private DebugUtil() {
    }

    public static boolean isAntPropertyExpanded(String string) {
        return !string.startsWith("${");
    }

    public static String getAntProperty(String string, String string2) {
        return DebugUtil.isAntPropertyExpanded(string) ? string : string2;
    }

    public static int getAntPropertyAsInt(String string, int n) {
        try {
            return Integer.parseInt(DebugUtil.getAntPropertyOrNull(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static boolean getAntPropertyAsBoolean(String string, boolean bl) {
        String string2 = DebugUtil.getAntPropertyOrNull(string);
        if (string2 != null) {
            if ((string2 = string2.toLowerCase()).equals("true")) {
                return true;
            }
            if (string2.equals("false")) {
                return false;
            }
        }
        return bl;
    }

    public static String getAntPropertyOrNull(String string) {
        return DebugUtil.getAntProperty(string, null);
    }

    public static Class getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Missing class " + string);
        }
    }

    public static Class injectClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Missing injectable class " + string + "\n" + "This may be a symptom of a dynamically referenced class being removed during\n" + "optimization. The most likely cause of this is a bug in Bolide which has\n" + "prevented one the optimizer steps from knowing that the class should not be\n" + "removed or renamed. Please mail bolide-dev@google.com with details.");
        }
    }

    public static Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Cannot instantiate instance of class " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("No public default constructor for class " + clazz.getName());
        }
    }
}

