/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.google.common.graphics.GoogleImage;
import com.google.common.graphics.android.AndroidImage;
import com.google.googlenav.map.MapTile;
import com.google.googlenav.map.Tile;
import com.google.googlenav.map.TrafficReading;
import com.google.googlenav.map.TrafficService;
import com.google.googlenav.map.TrafficTile;
import com.google.googlenav.ui.GmmTileOverlayRendererImpl;
import com.google.map.Zoom;

class TrafficRenderer
extends GmmTileOverlayRendererImpl {
    private static final int ROAD_BACKGROUND = -2130706433;
    private static final int RED = -1734803456;
    private static final int RED_OUTLINE = -800587776;
    private static final int YELLOW = -1325407232;
    private static final int YELLOW_OUTLINE = -1325417984;
    private static final int GREEN = -1342129152;
    private static final int NONE = 0xFFFFFF;
    private static final int NO_DATA = -1328426543;

    public TrafficRenderer(TrafficService trafficService) {
        this.setTrafficService(trafficService);
    }

    public GoogleImage generateNewTileImage(MapTile mapTile, TrafficTile tt) {
        if (tt == null) {
            return mapTile.getImage();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)128, (int)128, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawBitmap(((AndroidImage)mapTile.getImage()).getBitmap(), 0.0f, 0.0f, null);
        this.drawTraffic(canvas, tt);
        return new AndroidImage(bitmap);
    }

    protected boolean isFast() {
        return true;
    }

    private void drawTraffic(Canvas canvas, TrafficTile tt) {
        int bgLineWidth;
        Tile tile = tt.getLocation();
        int baseX = tile.getXPixelTopLeft();
        int baseY = tile.getYPixelTopLeft();
        Zoom zoom = tile.getZoom();
        int z = zoom.getZoomLevel();
        int n = z > 13 ? 9 : (z > 11 ? 8 : (bgLineWidth = z > 9 ? 6 : 5));
        int fgLineWidth = z > 13 ? 4 : (z > 11 ? 3 : 2);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStyle(Paint.Style.STROKE);
        TrafficReading[][] readings = tt.getReadings();
        if (readings.length == 0 || readings[0].length == 0) {
            return;
        }
        Path path = new Path();
        TrafficReading lastReading = readings[0][0];
        int lastColor = this.getColor(lastReading);
        for (int i = 0; i < readings.length; ++i) {
            for (int j = 0; j < readings[i].length; ++j) {
                TrafficReading tr = readings[i][j];
                int color = this.getColor(tr);
                if (color != lastColor) {
                    TrafficRenderer.paintPath(path, canvas, paint, lastColor, bgLineWidth, fgLineWidth);
                    path = new Path();
                    TrafficRenderer.addPathPoint(path, lastReading, zoom, baseX, baseY, false);
                    lastColor = color;
                }
                TrafficRenderer.addPathPoint(path, tr, zoom, baseX, baseY, !tr.isDiscontinuity() && j != 0);
                lastReading = tr;
            }
        }
        TrafficRenderer.paintPath(path, canvas, paint, lastColor, bgLineWidth, fgLineWidth);
    }

    private int getColor(TrafficReading reading) {
        if (reading.isDiscontinuity()) {
            return 0xFFFFFF;
        }
        if (!reading.hasData()) {
            return -1328426543;
        }
        if (reading.getSpeed() < 25) {
            return -1734803456;
        }
        if (reading.getSpeed() < 50) {
            return -1325407232;
        }
        return -1342129152;
    }

    private static void paintPath(Path path, Canvas canvas, Paint paint, int color, int bgLineWidth, int fgLineWidth) {
        paint.setColor(-2130706433);
        paint.setStrokeWidth((float)bgLineWidth);
        canvas.drawPath(path, paint);
        paint.setColor(color);
        paint.setStrokeWidth((float)fgLineWidth);
        canvas.drawPath(path, paint);
    }

    private static void addPathPoint(Path path, TrafficReading reading, Zoom z, int baseX, int baseY, boolean draw) {
        float x = reading.getXOffset();
        float y = reading.getYOffset();
        int separation = z.getZoomLevel() > 10 ? 5 : 4;
        x = (float)((double)x + (double)separation * Math.cos((double)reading.getAzi() * Math.PI / 180.0) / 2.0);
        y = (float)((double)y + (double)separation * Math.sin((double)reading.getAzi() * Math.PI / 180.0) / 2.0);
        if (draw) {
            path.lineTo(x, y);
        } else {
            path.moveTo(x, y);
        }
    }
}

