/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import com.google.common.graphics.GoogleImage;
import com.google.common.graphics.android.AndroidImage;
import com.google.googlenav.datarequest.DataRequest;
import com.google.googlenav.datarequest.DataRequestDispatcher;
import com.google.googlenav.map.MapTile;
import com.google.googlenav.map.Tile;
import com.google.googlenav.map.TileOverlayRenderer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

class StreetViewRenderer
implements TileOverlayRenderer {
    private static final int DRAWN_VERSION = 1;
    private static final byte TILE_TYPE = 9;
    private static final String LOG_TAG = StreetViewRenderer.class.toString();
    private final DataRequestDispatcher mDispatcher;
    private boolean mEnabled = false;
    private Map<Tile, TileRequest> mRequests = new HashMap<Tile, TileRequest>();
    private static final boolean DEBUGV = false;
    private long mStartTime = 0L;
    private int mTiles = 0;
    private int mDecodes = 0;
    private boolean mRequested = false;
    private final Vector<TileRequest> mPendingRequests = new Vector(18);

    public StreetViewRenderer(DataRequestDispatcher dispatcher) {
        this.mDispatcher = dispatcher;
    }

    public void begin() {
        this.mRequested = false;
    }

    public boolean renderTile(MapTile tile, boolean downloadData) {
        if (this.mEnabled) {
            switch (tile.getImageVersion()) {
                case 1: {
                    return false;
                }
                default: {
                    tile.restoreBaseImage();
                }
                case 0: 
            }
            Bitmap overlay = this.getOverlay(tile, downloadData);
            if (overlay == null) {
                return false;
            }
            return StreetViewRenderer.generateNewTileImage(tile, overlay);
        }
        if (tile.getImageVersion() == 1) {
            tile.restoreBaseImage();
            return true;
        }
        return false;
    }

    public void end() {
        if (!this.mPendingRequests.isEmpty()) {
            this.mPendingRequests.lastElement().mLast = true;
            for (TileRequest request : this.mPendingRequests) {
                this.mDispatcher.addDataRequest(request);
            }
            this.mPendingRequests.clear();
        }
    }

    private static boolean generateNewTileImage(MapTile tile, Bitmap overlay) {
        Bitmap bitmap = Bitmap.createBitmap((int)128, (int)128, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawBitmap(((AndroidImage)tile.getImage()).getBitmap(), 0.0f, 0.0f, null);
        canvas.drawBitmap(overlay, 0.0f, 0.0f, null);
        tile.setImage((GoogleImage)new AndroidImage(bitmap), 1);
        return true;
    }

    private Bitmap getOverlay(MapTile tile, boolean downloadData) {
        Tile location = Tile.getTile((byte)9, tile.getLocation());
        TileRequest request = this.mRequests.get(location);
        if (request == null) {
            if (downloadData) {
                request = new TileRequest(location);
                this.mPendingRequests.add(request);
                this.mRequested = true;
                this.mRequests.put(location, request);
            }
            return null;
        }
        byte[] data = request.getData();
        if (data == null) {
            return null;
        }
        Bitmap decoded = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
        this.mRequests.remove(location);
        return decoded;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean show) {
        this.mEnabled = show;
    }

    private static class TileRequest
    implements DataRequest {
        private static final int REQUEST_TYPE = 26;
        private static final int TILE_OK = 0;
        private final Tile mTile;
        private byte[] mData = null;
        private boolean mLast = false;

        public TileRequest(Tile tile) {
            this.mTile = tile;
        }

        public byte[] getData() {
            return this.mData;
        }

        public int getRequestType() {
            return 26;
        }

        public boolean isImmediate() {
            return this.mLast;
        }

        public boolean isSubmission() {
            return false;
        }

        public boolean isForeground() {
            return false;
        }

        public boolean retryOnFailure() {
            return true;
        }

        public boolean isCancelled() {
            return false;
        }

        public void setCancelled() {
        }

        public boolean isCancellable() {
            return false;
        }

        public void onComplete() {
        }

        public void writeRequestData(DataOutput dos) throws IOException {
            dos.writeShort(1);
            dos.writeShort(1);
            dos.writeShort(128);
            dos.writeLong(4L);
            this.mTile.write(dos);
        }

        public boolean readResponseData(DataInput dis) throws IOException {
            int tileEdition = dis.readUnsignedShort();
            int responseCode = dis.readUnsignedByte();
            int tileCount = dis.readUnsignedShort();
            Tile location = Tile.read(dis);
            if (responseCode != 0) {
                throw new IOException("Server returned: " + responseCode);
            }
            if (tileCount != 1) {
                throw new IOException("Server returned " + tileCount + " tiles");
            }
            if (!location.equals(this.mTile)) {
                throw new IOException("Server returned wrong tile: " + location);
            }
            int tileSize = dis.readUnsignedShort();
            byte[] imageBytes = new byte[tileSize];
            dis.readFully(imageBytes);
            this.mData = imageBytes;
            return true;
        }
    }
}

