/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.graphics.Matrix;
import android.util.Log;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.Projection;
import com.google.common.geom.Point;
import com.google.googlenav.map.Map;
import com.google.map.MapPoint;

final class PixelConverter
implements Projection {
    private static final String LOG_TAG = "PixelConverter";
    private final Map mMap;
    private final Matrix mMatrix = new Matrix();
    private final Matrix mInverse = new Matrix();
    private final float[] mTempFloats = new float[2];
    private final Point mTempPoint = new Point();

    PixelConverter(Map map) {
        this.mMap = map;
        this.mMatrix.reset();
        this.mInverse.reset();
    }

    public android.graphics.Point toPixels(GeoPoint in, android.graphics.Point out) {
        return this.toPixels(in, out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    android.graphics.Point toPixels(GeoPoint in, android.graphics.Point out, boolean transform) {
        if (out == null) {
            out = new android.graphics.Point();
        }
        Point point = this.mTempPoint;
        synchronized (point) {
            this.mMap.getPointXY(in.getMapPoint(), this.mTempPoint);
            if (transform) {
                this.transformTempPoint();
            }
            out.x = this.mTempPoint.x;
            out.y = this.mTempPoint.y;
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoPoint fromPixels(int x, int y) {
        Point point = this.mTempPoint;
        synchronized (point) {
            this.mTempFloats[0] = x;
            this.mTempFloats[1] = y;
            this.mInverse.mapPoints(this.mTempFloats);
            x = (int)this.mTempFloats[0];
            y = (int)this.mTempFloats[1];
        }
        MapPoint centerPoint = this.mMap.getCenterPoint();
        Point centerXY = this.mMap.getPointXY(centerPoint);
        int dx = x - centerXY.x;
        int dy = y - centerXY.y;
        MapPoint tapPoint = centerPoint.pixelOffset(dx, dy, this.mMap.getZoom());
        GeoPoint point2 = new GeoPoint(tapPoint);
        return point2;
    }

    public float metersToEquatorPixels(float meters) {
        return this.mMatrix.mapRadius((float)this.mMap.getZoom().getPixelsForDistance((int)meters));
    }

    private void transformTempPoint() {
        this.mTempFloats[0] = this.mTempPoint.x;
        this.mTempFloats[1] = this.mTempPoint.y;
        this.mMatrix.mapPoints(this.mTempFloats);
        this.mTempPoint.x = (int)this.mTempFloats[0];
        this.mTempPoint.y = (int)this.mTempFloats[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMatrix(Matrix animationState, float scale, GeoPoint fixed, float fixedX, float fixedY) {
        float correctionY;
        float correctionX;
        this.mMatrix.reset();
        Point point = this.mTempPoint;
        synchronized (point) {
            this.mMap.getPointXY(fixed.getMapPoint(), this.mTempPoint);
            this.mMatrix.postTranslate((float)(-this.mTempPoint.x), (float)(-this.mTempPoint.y));
            this.mMatrix.postScale(scale, scale);
            this.mMatrix.postTranslate(fixedX, fixedY);
            correctionX = (float)this.mTempPoint.x - fixedX;
            correctionY = (float)this.mTempPoint.y - fixedY;
        }
        animationState.postTranslate(correctionX, correctionY);
        this.mMatrix.postConcat(animationState);
        if (!this.mMatrix.invert(this.mInverse)) {
            Log.e((String)LOG_TAG, (String)("Setting singular matrix " + this.mMatrix));
        }
    }

    void resetMatrix() {
        this.mMatrix.reset();
        this.mInverse.reset();
    }
}

