/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.graphics.drawable.Drawable;
import com.google.android.maps.GeoPoint;

public class OverlayItem {
    protected final GeoPoint mPoint;
    protected final String mTitle;
    protected final String mSnippet;
    protected Drawable mMarker = null;
    public static final int ITEM_STATE_FOCUSED_MASK = 4;
    public static final int ITEM_STATE_SELECTED_MASK = 2;
    public static final int ITEM_STATE_PRESSED_MASK = 1;
    private static final int[][] ITEM_STATE_TO_STATE_SET = new int[][]{{-16842908, -16842913, -16842919}, {-16842908, -16842913, 16842919}, {-16842908, 0x10100A1, -16842919}, {-16842908, 0x10100A1, 16842919}, {16842908, -16842913, -16842919}, {16842908, -16842913, 16842919}, {16842908, 0x10100A1, -16842919}, {16842908, 0x10100A1, 16842919}};

    public OverlayItem(GeoPoint point, String title, String snippet) {
        this.mPoint = point;
        this.mTitle = title;
        this.mSnippet = snippet;
    }

    public void setMarker(Drawable marker) {
        this.mMarker = marker;
    }

    public Drawable getMarker(int stateBitset) {
        if (this.mMarker != null) {
            OverlayItem.setState(this.mMarker, stateBitset);
        }
        return this.mMarker;
    }

    public static void setState(Drawable drawable2, int stateBitset) {
        drawable2.setState(ITEM_STATE_TO_STATE_SET[stateBitset]);
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getSnippet() {
        return this.mSnippet;
    }

    public GeoPoint getPoint() {
        return this.mPoint;
    }

    public String routableAddress() {
        StringBuilder sb = new StringBuilder();
        sb.append((float)this.mPoint.getLatitudeE6() / 1000000.0f);
        sb.append(", ");
        sb.append((float)this.mPoint.getLongitudeE6() / 1000000.0f);
        return sb.toString();
    }
}

