/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.view.animation.TranslateAnimation;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapView;
import com.google.googlenav.map.Map;
import com.google.map.MapPoint;
import com.google.map.Zoom;

public final class MapController
implements View.OnKeyListener {
    private static final String LOG_TAG = "Maps.MapController";
    private static final int MAX_PAN_SPEED = 8;
    private static final int MAX_PAN_SPEED_NEG = -8;
    private final Map mMap;
    private final float[] mOrigin = new float[]{0.0f, 0.0f};
    private final int[] mDeltas = new int[]{0, 0};
    private HorizPanState mHorizPan = HorizPanState.NONE;
    private VertPanState mVertPan = VertPanState.NONE;
    private float mXPanSpeed = 0.0f;
    private float mYPanSpeed = 0.0f;
    private Animation mPanAnimation = null;
    private MapPoint mPanPoint = null;
    private MapView mMapView = null;
    private Message mAnimationCompletedMessage = null;
    private Runnable mAnimationCompletedRunnable = null;
    private static final Transformation EMPTY_TRANSFORM = new Transformation();
    private boolean mHasBeenMeasured = false;
    private int mDeferredLatSpanE6 = -1;
    private int mDeferredLonSpanE6 = -1;
    private volatile boolean mDirty;
    private static final long TRACKBALL_RELEASE_SLOP_TIME_MILLIS = 250L;

    MapController(Map map, MapView mapView) {
        this.mMap = map;
        this.mMapView = mapView;
    }

    public void stopPanning() {
        this.mHorizPan = HorizPanState.NONE;
        this.mVertPan = VertPanState.NONE;
    }

    int[] getDeltas() {
        switch (this.mHorizPan) {
            case LEFT: {
                this.mXPanSpeed = this.curve(this.mXPanSpeed, -8.0f);
                break;
            }
            case RIGHT: {
                this.mXPanSpeed = this.curve(this.mXPanSpeed, 8.0f);
                break;
            }
            case NONE: {
                this.mXPanSpeed = 0.0f;
            }
        }
        switch (this.mVertPan) {
            case UP: {
                this.mYPanSpeed = this.curve(this.mYPanSpeed, -8.0f);
                break;
            }
            case DOWN: {
                this.mYPanSpeed = this.curve(this.mYPanSpeed, 8.0f);
                break;
            }
            case NONE: {
                this.mYPanSpeed = 0.0f;
            }
        }
        this.mDeltas[0] = (int)this.mXPanSpeed;
        this.mDeltas[1] = (int)this.mYPanSpeed;
        return this.mDeltas;
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (this.onKeyDown(keyCode)) {
                    this.repaint();
                    return true;
                }
                return false;
            }
            case 1: {
                if (this.onKeyUp(keyCode)) {
                    this.repaint();
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown key action: " + event.getAction());
    }

    private boolean onKeyUp(int keyCode) {
        switch (keyCode) {
            case 19: {
                if (this.mVertPan == VertPanState.UP) {
                    this.mVertPan = VertPanState.NONE;
                    return true;
                }
                return false;
            }
            case 20: {
                if (this.mVertPan == VertPanState.DOWN) {
                    this.mVertPan = VertPanState.NONE;
                    return true;
                }
                return false;
            }
            case 21: {
                if (this.mHorizPan == HorizPanState.LEFT) {
                    this.mHorizPan = HorizPanState.NONE;
                    return true;
                }
                return false;
            }
            case 22: {
                if (this.mHorizPan == HorizPanState.RIGHT) {
                    this.mHorizPan = HorizPanState.NONE;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean onKeyDown(int keyCode) {
        switch (keyCode) {
            case 19: {
                this.mVertPan = VertPanState.UP;
                return true;
            }
            case 20: {
                this.mVertPan = VertPanState.DOWN;
                return true;
            }
            case 21: {
                this.mHorizPan = HorizPanState.LEFT;
                return true;
            }
            case 22: {
                this.mHorizPan = HorizPanState.RIGHT;
                return true;
            }
        }
        return false;
    }

    private float curve(float last, float max) {
        return last + (max - last) / 8.0f;
    }

    public void animateTo(GeoPoint point) {
        this.animateTo(point, null, null);
    }

    public void animateTo(GeoPoint point, Message message) {
        this.animateTo(point, null, message);
    }

    public void animateTo(GeoPoint point, Runnable runnable) {
        this.animateTo(point, runnable, null);
    }

    private void animateTo(GeoPoint point, Runnable runnable, Message message) {
        this.mAnimationCompletedRunnable = runnable;
        this.mAnimationCompletedMessage = message;
        MapPoint mapPoint = point.getMapPoint();
        this.stopAnimation(false);
        this.mMap.preLoad(mapPoint);
        this.mPanPoint = mapPoint;
        MapPoint center = this.mMap.getCenterPoint();
        double distance = Math.sqrt((int)mapPoint.pixelDistanceSquared(center, this.mMap.getZoom()));
        int animateMillis = (int)Math.min(200.0 + distance * 10.0, 800.0);
        this.mPanAnimation = new TranslateAnimation((float)center.getLatitude() / 1000000.0f, (float)mapPoint.getLatitude() / 1000000.0f, (float)center.getLongitude() / 1000000.0f, (float)mapPoint.getLongitude() / 1000000.0f);
        this.mPanAnimation.setDuration((long)animateMillis);
        this.mPanAnimation.startNow();
        this.mPanAnimation.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.mPanAnimation.initialize(0, 0, 0, 0);
        this.repaint();
    }

    boolean stepAnimation(long drawTime) {
        int[] panDeltas = this.getDeltas();
        if (panDeltas[0] != 0 || panDeltas[1] != 0) {
            this.scrollBy(panDeltas[0], panDeltas[1]);
            return true;
        }
        if (this.mPanAnimation != null) {
            Transformation xform = EMPTY_TRANSFORM;
            xform.clear();
            if (this.mPanAnimation.getTransformation(drawTime, xform)) {
                this.mOrigin[0] = 0.0f;
                this.mOrigin[1] = 0.0f;
                xform.getMatrix().mapPoints(this.mOrigin);
                MapPoint newCenter = new MapPoint((int)((double)this.mOrigin[0] * 1000000.0), (int)((double)this.mOrigin[1] * 1000000.0));
                this.centerMapToInternal(newCenter);
                return true;
            }
            this.centerMapToInternal(this.mPanPoint);
            this.mPanPoint = null;
            this.mPanAnimation = null;
            if (this.mAnimationCompletedMessage != null) {
                this.mAnimationCompletedMessage.sendToTarget();
                this.mAnimationCompletedMessage = null;
            }
            if (this.mAnimationCompletedRunnable != null) {
                this.mMapView.post(this.mAnimationCompletedRunnable);
                this.mAnimationCompletedRunnable = null;
            }
            return false;
        }
        return false;
    }

    public void scrollBy(int x, int y) {
        this.stopAnimation(false);
        MapPoint newCenter = this.mMap.getCenterPoint().pixelOffset(x, y, this.mMap.getZoom());
        this.centerMapToInternal(newCenter);
    }

    void scrollByTrackball(int x, int y) {
        long delta;
        if (this.mPanAnimation != null && (delta = AnimationUtils.currentAnimationTimeMillis() - this.mPanAnimation.getStartTime()) < 250L) {
            return;
        }
        this.scrollBy(x, y);
    }

    void repaint() {
        this.mDirty = true;
        this.mMapView.postInvalidate();
    }

    public void setCenter(GeoPoint point) {
        this.centerMapToInternal(point.getMapPoint());
    }

    private void centerMapToInternal(MapPoint mapPoint) {
        this.mMap.setCenterPoint(mapPoint);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(boolean jumpToFinish) {
        if (this.mPanAnimation != null) {
            if (jumpToFinish) {
                Map map = this.mMap;
                synchronized (map) {
                    this.centerMapToInternal(this.mPanPoint);
                }
            }
            this.mPanAnimation = null;
            this.mPanPoint = null;
        }
        this.mAnimationCompletedMessage = null;
    }

    void zoomTo(Zoom zoom) {
        this.mMap.setZoom(zoom);
        this.repaint();
    }

    public int setZoom(int zoomLevel) {
        zoomLevel = Math.min(22, Math.max(1, zoomLevel));
        this.zoomTo(Zoom.getZoom(zoomLevel));
        return zoomLevel;
    }

    public void zoomToSpan(int latSpanE6, int lonSpanE6) {
        if (this.mHasBeenMeasured) {
            this.mMap.zoomToSpan(latSpanE6, lonSpanE6);
            this.repaint();
        } else {
            this.mDeferredLatSpanE6 = latSpanE6;
            this.mDeferredLonSpanE6 = lonSpanE6;
        }
    }

    public boolean zoomIn() {
        return this.mMapView.doZoom(true);
    }

    public boolean zoomOut() {
        return this.mMapView.doZoom(false);
    }

    public boolean zoomInFixing(int xPixel, int yPixel) {
        return this.mMapView.doZoom(true, xPixel, yPixel);
    }

    public boolean zoomOutFixing(int xPixel, int yPixel) {
        return this.mMapView.doZoom(false, xPixel, yPixel);
    }

    void onMeasure() {
        if (!this.mHasBeenMeasured) {
            this.mHasBeenMeasured = true;
            if (this.mDeferredLatSpanE6 >= 0) {
                this.zoomToSpan(this.mDeferredLatSpanE6, this.mDeferredLonSpanE6);
            }
        }
    }

    boolean isDirty() {
        return this.mDirty;
    }

    void clean() {
        this.mDirty = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum VertPanState {
        UP,
        DOWN,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HorizPanState {
        LEFT,
        RIGHT,
        NONE;

    }
}

