/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;
import com.google.android.maps.OverlayItem;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemizedOverlay<Item extends OverlayItem>
extends Overlay
implements Overlay.Snappable {
    private static final String LOG_TAG = "Maps_ItemizedOverlay";
    private int[] mRanksOrderedByLat = null;
    private ArrayList<Item> mItemsOrderedByRank = null;
    private int mLatSpanE6;
    private int mLonSpanE6;
    private final Drawable mBalloon;
    private OnFocusChangeListener mOnFocusChangeListener;
    private boolean mDrawFocusedItem = true;
    private int[] mItemState;
    private int mLastSelectedItemRank = -1;
    private Item mFocused = null;
    protected int mLastFocusedIndex = -1;
    private int mCurrentlyPressedItemRank;
    private int mCurrentlySelectedItemRank;
    private int mInGestureMask;
    private static final int GESTURE_TRACKBALL_MASK = 1;
    private static final int GESTURE_TOUCH_MASK = 2;
    private final Rect mTouchableBounds = new Rect();
    private static final int MINIMUM_TOUCH_DIAMETER = ViewConfiguration.getTouchSlop() * 4;
    private final Point mTempPoint = new Point();

    public ItemizedOverlay(Drawable defaultMarker) {
        this.mBalloon = defaultMarker;
    }

    private Rect getTouchableBounds(Rect bounds) {
        int w = bounds.width();
        int h = bounds.height();
        if (w >= MINIMUM_TOUCH_DIAMETER && h >= MINIMUM_TOUCH_DIAMETER) {
            return bounds;
        }
        int cx = bounds.centerX();
        int cy = bounds.centerY();
        int touchW = Math.max(MINIMUM_TOUCH_DIAMETER, w);
        int touchL = cx - touchW / 2;
        int touchH = Math.max(MINIMUM_TOUCH_DIAMETER, h);
        int touchT = cy - touchH / 2;
        this.mTouchableBounds.set(touchL, touchT, touchL + touchW, touchT + touchH);
        return this.mTouchableBounds;
    }

    protected static Drawable boundCenterBottom(Drawable balloon) {
        int width = balloon.getIntrinsicWidth();
        int w2 = width / 2;
        int height = balloon.getIntrinsicHeight();
        balloon.setBounds(-w2, 1 - height, width - w2, 1);
        return balloon;
    }

    protected static Drawable boundCenter(Drawable balloon) {
        int width = balloon.getIntrinsicWidth();
        int w2 = width / 2;
        int height = balloon.getIntrinsicHeight();
        int h2 = height / 2;
        balloon.setBounds(-w2, -h2, width - w2, height - h2);
        return balloon;
    }

    protected abstract Item createItem(int var1);

    public abstract int size();

    public GeoPoint getCenter() {
        if (this.mRanksOrderedByLat.length > 0) {
            return ((OverlayItem)this.getItem(0)).getPoint();
        }
        return null;
    }

    protected int getIndexToDraw(int drawingOrder) {
        return this.mRanksOrderedByLat[drawingOrder];
    }

    @Override
    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        int size = this.size();
        int focusedItemRank = -1;
        int itemStateFocusedMask = 4;
        for (int i = 0; i < size; ++i) {
            int rank = this.getIndexToDraw(i);
            int itemState = this.mItemState[rank];
            if ((itemState & 4) == 0) {
                this.drawItem(canvas, mapView, shadow, rank);
                continue;
            }
            focusedItemRank = rank;
        }
        if (this.mDrawFocusedItem && focusedItemRank >= 0) {
            this.drawItem(canvas, mapView, shadow, focusedItemRank);
        }
    }

    private void drawItem(Canvas canvas, MapView mapView, boolean shadow, int rank) {
        Item item = this.getItem(rank);
        Drawable marker = this.getDrawable(item, rank);
        mapView.getProjection().toPixels(((OverlayItem)item).getPoint(), this.mTempPoint);
        ItemizedOverlay.drawAt(canvas, marker, this.mTempPoint.x, this.mTempPoint.y, shadow);
    }

    private Drawable getDrawable(Item item, int rank) {
        int itemState = this.mItemState[rank];
        Drawable drawable = ((OverlayItem)item).getMarker(itemState);
        if (drawable == null) {
            drawable = this.mBalloon;
            OverlayItem.setState(drawable, itemState);
        }
        return drawable;
    }

    public int getLatSpanE6() {
        return this.mLatSpanE6;
    }

    public int getLonSpanE6() {
        return this.mLonSpanE6;
    }

    protected final void populate() {
        int resultCount = this.size();
        int minLat = 90000000;
        int maxLat = -90000000;
        int minLon = 180000000;
        int maxLon = -180000000;
        ArrayList<Item> itemsOrderedByRank = new ArrayList<Item>(resultCount);
        for (int i = 0; i < resultCount; ++i) {
            Item item = this.createItem(i);
            itemsOrderedByRank.add(item);
            GeoPoint point = ((OverlayItem)item).getPoint();
            minLat = Math.min(minLat, point.getLatitudeE6());
            maxLat = Math.max(maxLat, point.getLatitudeE6());
            minLon = Math.min(minLon, point.getLongitudeE6());
            maxLon = Math.max(maxLon, point.getLongitudeE6());
        }
        this.mLatSpanE6 = maxLat - minLat;
        this.mLonSpanE6 = maxLon - minLon;
        int[] ranksOrderedByLat = new int[resultCount];
        for (int i = 0; i < resultCount; ++i) {
            int insertRank = i;
            for (int j = 0; j <= i; ++j) {
                OverlayItem sorted = (OverlayItem)itemsOrderedByRank.get(ranksOrderedByLat[j]);
                if (j != i && sorted.getPoint().getLatitudeE6() >= ((OverlayItem)itemsOrderedByRank.get(i)).getPoint().getLatitudeE6()) continue;
                int tmp = ranksOrderedByLat[j];
                ranksOrderedByLat[j] = insertRank;
                insertRank = tmp;
            }
        }
        this.mRanksOrderedByLat = ranksOrderedByLat;
        this.mItemsOrderedByRank = itemsOrderedByRank;
        this.mItemState = new int[resultCount];
        this.mCurrentlySelectedItemRank = -1;
        this.mCurrentlyPressedItemRank = -1;
        this.mInGestureMask = 0;
    }

    protected void setLastFocusedIndex(int lastFocusedIndex) {
        this.mLastFocusedIndex = lastFocusedIndex;
    }

    private void setFocus(int rank, Item item) {
        boolean notify = this.mFocused != item && this.mOnFocusChangeListener != null;
        this.maskHelper(this.mLastFocusedIndex, rank, 4);
        if (rank != -1) {
            this.mLastFocusedIndex = rank;
        }
        this.mFocused = item;
        if (notify) {
            this.mOnFocusChangeListener.onFocusChanged(this, (OverlayItem)item);
        }
    }

    public void setFocus(Item item) {
        if (item == null) {
            this.setFocus(this.mLastFocusedIndex, null);
        } else {
            int index = 0;
            for (OverlayItem candidate : this.mItemsOrderedByRank) {
                if (candidate == item) {
                    this.setFocus(index, candidate);
                    return;
                }
                ++index;
            }
        }
    }

    public Item getFocus() {
        return this.mFocused;
    }

    public final int getLastFocusedIndex() {
        return this.mLastFocusedIndex;
    }

    public final Item getItem(int position) {
        return (Item)((OverlayItem)this.mItemsOrderedByRank.get(position));
    }

    public Item nextFocus(boolean forwards) {
        int rank = this.mLastFocusedIndex + (forwards ? 1 : -1);
        if (rank >= 0 && rank < this.mRanksOrderedByLat.length) {
            return this.getItem(rank);
        }
        return null;
    }

    @Override
    public boolean onTap(GeoPoint p, MapView mapView) {
        mapView.getProjection().toPixels(p, this.mTempPoint);
        int hit = this.getItemAtLocation(this.mTempPoint.x, this.mTempPoint.y, mapView);
        boolean retValue = false;
        if (hit != -1) {
            retValue = this.onTap(hit);
        }
        this.focus(hit);
        int selectHit = hit;
        this.select(selectHit);
        return retValue;
    }

    @Override
    public boolean onSnapToItem(int x, int y, Point snapPoint, MapView mapView) {
        int hitRank = this.getItemAtLocation(x, y, mapView);
        if (hitRank == -1) {
            return false;
        }
        OverlayItem item = (OverlayItem)this.mItemsOrderedByRank.get(hitRank);
        mapView.getProjection().toPixels(item.getPoint(), snapPoint);
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event, MapView mapView) {
        return this.handleMotionEvent(true, 1, event, mapView, mapView.getWidth() / 2, mapView.getHeight() / 2);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event, MapView mapView) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (this.getFocus() == null) break;
                return this.onTap(this.mLastFocusedIndex);
            }
        }
        return super.onKeyUp(keyCode, event, mapView);
    }

    private boolean handleMotionEvent(boolean trackball, int gestureMask, MotionEvent event, MapView mapView, int x, int y) {
        boolean inGesture;
        int action = event.getAction();
        boolean isDown = action == 0;
        boolean isDownOrMove = isDown || action == 2;
        int hit = this.getItemAtLocation(x, y, mapView);
        boolean hitSomething = hit != -1;
        int selectHit = trackball ? hit : -1;
        this.select(selectHit);
        if (isDown) {
            this.mInGestureMask = hitSomething ? (this.mInGestureMask |= gestureMask) : (this.mInGestureMask &= ~gestureMask);
        }
        boolean bl = inGesture = (this.mInGestureMask & gestureMask) != 0;
        if (inGesture) {
            if (isDownOrMove) {
                this.press(hit);
            } else if (action == 1) {
                this.press(-1);
                this.mInGestureMask &= ~gestureMask;
                if (gestureMask != 2) {
                    this.onTap(hit);
                }
            }
        }
        return inGesture && gestureMask != 2;
    }

    private void focus(int hit) {
        Item hitItem = hit != -1 ? (Item)this.getItem(hit) : null;
        this.setFocus(hit, hitItem);
    }

    private void select(int rank) {
        this.mCurrentlySelectedItemRank = this.maskHelper(this.mCurrentlySelectedItemRank, rank, 2);
    }

    private void press(int rank) {
        this.mCurrentlyPressedItemRank = this.maskHelper(this.mCurrentlyPressedItemRank, rank, 1);
    }

    private int maskHelper(int oldRank, int newRank, int mask) {
        if (oldRank != newRank) {
            if (oldRank != -1) {
                int n = oldRank;
                this.mItemState[n] = this.mItemState[n] & ~mask;
            }
            if (newRank != -1) {
                int n = newRank;
                this.mItemState[n] = this.mItemState[n] | mask;
            }
        }
        return newRank;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        return this.handleMotionEvent(false, 2, event, mapView, (int)event.getX(), (int)event.getY());
    }

    private int getItemAtLocation(int hitX, int hitY, MapView mapView) {
        ArrayList<Integer> hitItems = this.getItemsAtLocation(hitX, hitY, mapView);
        int closestRank = -1;
        int closestDistanceSquared = Integer.MAX_VALUE;
        for (int rank : hitItems) {
            int dy;
            OverlayItem item = (OverlayItem)this.mItemsOrderedByRank.get(rank);
            mapView.getProjection().toPixels(item.getPoint(), this.mTempPoint);
            int offsetX = hitX - this.mTempPoint.x;
            int offsetY = hitY - this.mTempPoint.y;
            Drawable marker = this.getDrawable(item, rank);
            Rect bounds = this.getTouchableBounds(marker.getBounds());
            int dx = bounds.centerX() - offsetX;
            int distanceSquared = dx * dx + (dy = bounds.centerY() - offsetY) * dy;
            if (distanceSquared >= closestDistanceSquared) continue;
            closestDistanceSquared = distanceSquared;
            closestRank = rank;
        }
        this.mLastSelectedItemRank = closestRank;
        return this.mLastSelectedItemRank;
    }

    private ArrayList<Integer> getItemsAtLocation(int hitX, int hitY, MapView mapView) {
        ArrayList<Item> itemsByRank = this.mItemsOrderedByRank;
        int[] ranksOrderedByLat = this.mRanksOrderedByLat;
        int length = ranksOrderedByLat.length;
        ArrayList<Integer> hitItemRanks = new ArrayList<Integer>(length);
        for (int i = length - 1; i >= 0; --i) {
            int rank = ranksOrderedByLat[i];
            int itemState = this.mItemState[rank];
            if (!this.mDrawFocusedItem && (itemState & 4) != 0) continue;
            OverlayItem item = (OverlayItem)itemsByRank.get(rank);
            mapView.getProjection().toPixels(item.getPoint(), this.mTempPoint);
            int offsetX = hitX - this.mTempPoint.x;
            int offsetY = hitY - this.mTempPoint.y;
            Drawable marker = this.getDrawable(item, rank);
            if (!this.hitTest(item, marker, offsetX, offsetY)) continue;
            hitItemRanks.add(rank);
        }
        return hitItemRanks;
    }

    protected boolean hitTest(Item item, Drawable marker, int hitX, int hitY) {
        Rect bounds = this.getTouchableBounds(marker.getBounds());
        return bounds.contains(hitX, hitY);
    }

    public void setOnFocusChangeListener(OnFocusChangeListener l) {
        this.mOnFocusChangeListener = l;
    }

    public void setDrawFocusedItem(boolean drawFocusedItem) {
        this.mDrawFocusedItem = drawFocusedItem;
    }

    protected boolean onTap(int index) {
        return false;
    }

    public static interface OnFocusChangeListener {
        public void onFocusChanged(ItemizedOverlay var1, OverlayItem var2);
    }
}

