/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.maps;

import com.google.android.maps.StreetViewRenderer;
import com.google.android.maps.TrafficRenderer;
import com.google.googlenav.datarequest.DataRequestDispatcher;
import com.google.googlenav.map.MapTile;
import com.google.googlenav.map.TileOverlayRenderer;
import com.google.googlenav.map.TrafficService;

class AndroidTileOverlayRenderer
implements TileOverlayRenderer {
    private static final int MODE_NONE = 0;
    private static final int MODE_STREET = 1;
    private static final int MODE_TRAFFIC = 2;
    private int mMode = 0;
    private final TrafficRenderer mTrafficRenderer;
    private final StreetViewRenderer mStreetViewRenderer;
    private static final boolean FAKE_STREETVIEW = false;
    private boolean mFakeStreetViewEnabled;

    public AndroidTileOverlayRenderer(TrafficService trafficService, DataRequestDispatcher dispatcher) {
        this.mTrafficRenderer = new TrafficRenderer(trafficService);
        this.mStreetViewRenderer = new StreetViewRenderer(dispatcher);
    }

    public void begin() {
        this.mTrafficRenderer.begin();
        this.mStreetViewRenderer.begin();
    }

    public boolean renderTile(MapTile tile, boolean downloadData) {
        if (!tile.isComplete()) {
            return false;
        }
        switch (this.mMode) {
            case 1: {
                return this.mStreetViewRenderer.renderTile(tile, downloadData);
            }
            case 2: {
                return this.mTrafficRenderer.renderTile(tile, downloadData);
            }
        }
        return false;
    }

    public void end() {
        this.mStreetViewRenderer.end();
        this.mTrafficRenderer.end();
    }

    public boolean isShowTraffic() {
        return this.mTrafficRenderer.isShowTraffic();
    }

    public void setShowTraffic(boolean show) {
        if (show) {
            this.setShowStreetView(false);
            this.mMode = 2;
        }
        this.mTrafficRenderer.setShowTraffic(show);
    }

    public boolean isShowStreetView() {
        return this.mStreetViewRenderer.isEnabled();
    }

    public void setShowStreetView(boolean show) {
        if (show) {
            this.setShowTraffic(false);
            this.mMode = 1;
        }
        this.mStreetViewRenderer.setEnabled(show);
    }
}

