/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.eclipse.swt.graphics.ImageData;

public class WritePng {
    private static final byte[] PNG_MAGIC = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    private WritePng() {
    }

    public static void savePng(String fileName, ImageData imageData) throws IOException {
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            Log.d((String)"ddms", (String)("Saving to PNG, width=" + imageData.width + ", height=" + imageData.height + ", depth=" + imageData.depth + ", bpl=" + imageData.bytesPerLine));
            WritePng.savePng(out, imageData);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            Log.e((String)"writepng", (Throwable)e);
        }
    }

    private static void savePng(OutputStream out, ImageData imageData) throws IOException {
        int compLen;
        byte[] out24;
        int width = imageData.width;
        int height = imageData.height;
        Log.i((String)"ddms-png", (String)("Convert to 24bit from " + imageData.depth));
        if (imageData.depth == 24 || imageData.depth == 32) {
            out24 = WritePng.convertTo24ForPng(imageData.data, width, height, imageData.depth, imageData.bytesPerLine);
        } else if (imageData.depth == 16) {
            out24 = WritePng.convert16to24(imageData);
        } else {
            return;
        }
        byte[] compPixels = new byte[out24.length + 16384];
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(out24);
        compressor.finish();
        do {
            compLen = compressor.deflate(compPixels);
            assert (compLen != 0 || !compressor.needsInput());
        } while (compLen == 0);
        Log.d((String)"ddms", (String)("Compressed image data from " + out24.length + " to " + compLen));
        out.write(PNG_MAGIC);
        byte[] header = new byte[25];
        ByteBuffer buf = ByteBuffer.wrap(header);
        buf.order(ByteOrder.BIG_ENDIAN);
        WritePng.putChunkHeader(buf, 13, "IHDR");
        buf.putInt(width);
        buf.putInt(height);
        buf.put((byte)8);
        buf.put((byte)2);
        buf.put((byte)0);
        buf.put((byte)0);
        buf.put((byte)0);
        CRC32 crc = new CRC32();
        crc.update(header, 4, 17);
        buf.putInt((int)crc.getValue());
        out.write(header);
        byte[] datHdr = new byte[12];
        buf = ByteBuffer.wrap(datHdr);
        buf.order(ByteOrder.BIG_ENDIAN);
        WritePng.putChunkHeader(buf, compLen, "IDAT");
        crc = new CRC32();
        crc.update(datHdr, 4, 4);
        crc.update(compPixels, 0, compLen);
        buf.putInt((int)crc.getValue());
        out.write(datHdr, 0, 8);
        out.write(compPixels, 0, compLen);
        out.write(datHdr, 8, 4);
        byte[] trailer = new byte[12];
        buf = ByteBuffer.wrap(trailer);
        buf.order(ByteOrder.BIG_ENDIAN);
        WritePng.putChunkHeader(buf, 0, "IEND");
        crc = new CRC32();
        crc.update(trailer, 4, 4);
        buf.putInt((int)crc.getValue());
        out.write(trailer);
    }

    private static void putChunkHeader(ByteBuffer buf, int length, String typeStr) {
        int type = 0;
        if (typeStr.length() != 4) {
            throw new RuntimeException();
        }
        for (int i = 0; i < 4; ++i) {
            type <<= 8;
            type |= (byte)typeStr.charAt(i);
        }
        buf.putInt(length);
        buf.putInt(type);
    }

    private static byte[] convertTo24ForPng(byte[] in, int width, int height, int depth, int stride) {
        assert (depth == 24 || depth == 32);
        assert (stride == width * (depth / 8));
        byte[] out24 = new byte[width * height * 3 + height];
        int inOff = 0;
        int outOff = 0;
        for (int y = 0; y < height; ++y) {
            out24[outOff++] = 0;
            if (depth == 24) {
                System.arraycopy(in, inOff, out24, outOff, width * 3);
                outOff += width * 3;
            } else if (depth == 32) {
                int tmpOff = inOff;
                for (int x = 0; x < width; ++x) {
                    int n = outOff++;
                    int n2 = ++tmpOff;
                    out24[n] = in[n2];
                    int n3 = outOff++;
                    int n4 = ++tmpOff;
                    out24[n3] = in[n4];
                    int n5 = outOff++;
                    int n6 = ++tmpOff;
                    ++tmpOff;
                    out24[n5] = in[n6];
                }
            }
            inOff += stride;
        }
        assert (outOff == out24.length);
        return out24;
    }

    private static byte[] convert16to24(ImageData imageData) {
        int width = imageData.width;
        int height = imageData.height;
        int redShift = imageData.palette.redShift;
        int greenShift = imageData.palette.greenShift;
        int blueShift = imageData.palette.blueShift;
        int redMask = imageData.palette.redMask;
        int greenMask = imageData.palette.greenMask;
        int blueMask = imageData.palette.blueMask;
        byte[] out24 = new byte[width * height * 3 + height];
        int outOff = 0;
        int[] line = new int[width];
        for (int y = 0; y < height; ++y) {
            imageData.getPixels(0, y, width, line, 0);
            out24[outOff++] = 0;
            for (int x = 0; x < width; ++x) {
                int pixelValue = line[x];
                out24[outOff++] = WritePng.byteChannelValue(pixelValue, redMask, redShift);
                out24[outOff++] = WritePng.byteChannelValue(pixelValue, greenMask, greenShift);
                out24[outOff++] = WritePng.byteChannelValue(pixelValue, blueMask, blueShift);
            }
        }
        return out24;
    }

    private static byte byteChannelValue(int value, int mask, int shift) {
        int bValue = value & mask;
        bValue = shift < 0 ? (bValue >>>= -shift) : (bValue <<= shift);
        return (byte)bValue;
    }
}

