/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Log;
import com.android.ddmuilib.IImageLoader;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageHelper {
    public static Image loadImage(IImageLoader loader, Display display, String fileName, int width, int height, Color phColor) {
        Image img = null;
        if (loader != null) {
            img = loader.loadImage(fileName, display);
        }
        if (img == null) {
            Log.w((String)"ddms", (String)("Couldn't load " + fileName));
            if (width != -1 && height != -1) {
                return ImageHelper.createPlaceHolderArt(display, width, height, phColor != null ? phColor : display.getSystemColor(9));
            }
            return null;
        }
        return img;
    }

    public static Image createPlaceHolderArt(Display display, int width, int height, Color color) {
        Image img = new Image((Device)display, width, height);
        GC gc = new GC((Drawable)img);
        gc.setForeground(color);
        gc.drawLine(0, 0, width, height);
        gc.drawLine(0, height - 1, width, -1);
        gc.dispose();
        return img;
    }
}

