/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.NativeStackCallInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeAllocationInfo {
    private static final int FLAG_ZYGOTE_CHILD = Integer.MIN_VALUE;
    private static final int FLAG_MASK = Integer.MIN_VALUE;
    private static ArrayList<String> sAllocFunctionFilter = new ArrayList();
    private final int mSize;
    private final boolean mIsZygoteChild;
    private final int mAllocations;
    private final ArrayList<Long> mStackCallAddresses = new ArrayList();
    private ArrayList<NativeStackCallInfo> mResolvedStackCall = null;
    private boolean mIsStackCallResolved = false;

    NativeAllocationInfo(int size, int allocations) {
        this.mSize = size & Integer.MAX_VALUE;
        this.mIsZygoteChild = (size & Integer.MIN_VALUE) != 0;
        this.mAllocations = allocations;
    }

    void addStackCallAddress(long address) {
        this.mStackCallAddresses.add(address);
    }

    public int getSize() {
        return this.mSize;
    }

    public boolean isZygoteChild() {
        return this.mIsZygoteChild;
    }

    public int getAllocationCount() {
        return this.mAllocations;
    }

    public boolean isStackCallResolved() {
        return this.mIsStackCallResolved;
    }

    public Long[] getStackCallAddresses() {
        return this.mStackCallAddresses.toArray(new Long[this.mStackCallAddresses.size()]);
    }

    public synchronized void setResolvedStackCall(List<NativeStackCallInfo> resolvedStackCall) {
        if (this.mResolvedStackCall == null) {
            this.mResolvedStackCall = new ArrayList();
        } else {
            this.mResolvedStackCall.clear();
        }
        this.mResolvedStackCall.addAll(resolvedStackCall);
        this.mIsStackCallResolved = this.mResolvedStackCall.size() != 0;
    }

    public synchronized NativeStackCallInfo[] getResolvedStackCall() {
        if (this.mIsStackCallResolved) {
            return this.mResolvedStackCall.toArray(new NativeStackCallInfo[this.mResolvedStackCall.size()]);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NativeAllocationInfo) {
            NativeAllocationInfo mi = (NativeAllocationInfo)obj;
            if (this.mSize != mi.mSize || this.mAllocations != mi.mAllocations || this.mStackCallAddresses.size() != mi.mStackCallAddresses.size()) {
                return false;
            }
            int count = this.mStackCallAddresses.size();
            for (int i = 0; i < count; ++i) {
                long b;
                long a = this.mStackCallAddresses.get(i);
                if (a == (b = mi.mStackCallAddresses.get(i).longValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Allocations: ");
        buffer.append(this.mAllocations);
        buffer.append("\n");
        buffer.append("Size: ");
        buffer.append(this.mSize);
        buffer.append("\n");
        buffer.append("Total Size: ");
        buffer.append(this.mSize * this.mAllocations);
        buffer.append("\n");
        Iterator<Long> addrIterator = this.mStackCallAddresses.iterator();
        Iterator<NativeStackCallInfo> sourceIterator = this.mResolvedStackCall.iterator();
        while (sourceIterator.hasNext()) {
            long addr = addrIterator.next();
            NativeStackCallInfo source = sourceIterator.next();
            if (addr == 0L) continue;
            if (source.getLineNumber() != -1) {
                buffer.append(String.format("\t%1$08x\t%2$s --- %3$s --- %4$s:%5$d\n", addr, source.getLibraryName(), source.getMethodName(), source.getSourceFile(), source.getLineNumber()));
                continue;
            }
            buffer.append(String.format("\t%1$08x\t%2$s --- %3$s --- %4$s\n", addr, source.getLibraryName(), source.getMethodName(), source.getSourceFile()));
        }
        return buffer.toString();
    }

    public synchronized NativeStackCallInfo getRelevantStackCallInfo() {
        if (this.mIsStackCallResolved && this.mResolvedStackCall != null) {
            Iterator<NativeStackCallInfo> sourceIterator = this.mResolvedStackCall.iterator();
            Iterator<Long> addrIterator = this.mStackCallAddresses.iterator();
            while (sourceIterator.hasNext() && addrIterator.hasNext()) {
                long addr = addrIterator.next();
                NativeStackCallInfo info = sourceIterator.next();
                if (addr == 0L || info == null || !this.isRelevant(info.getMethodName())) continue;
                return info;
            }
            if (this.mResolvedStackCall.size() > 0) {
                return this.mResolvedStackCall.get(0);
            }
        }
        return null;
    }

    private boolean isRelevant(String methodName) {
        for (String filter : sAllocFunctionFilter) {
            if (!methodName.contains(filter)) continue;
            return false;
        }
        return true;
    }

    static {
        sAllocFunctionFilter.add("malloc");
        sAllocFunctionFilter.add("calloc");
        sAllocFunctionFilter.add("realloc");
        sAllocFunctionFilter.add("get_backtrace");
        sAllocFunctionFilter.add("get_hash");
        sAllocFunctionFilter.add("??");
        sAllocFunctionFilter.add("internal_free");
        sAllocFunctionFilter.add("operator new");
        sAllocFunctionFilter.add("leak_free");
        sAllocFunctionFilter.add("chk_free");
        sAllocFunctionFilter.add("chk_memalign");
        sAllocFunctionFilter.add("Malloc");
    }
}

