/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Debugger;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class MonitorThread
extends Thread {
    private static final int CLIENT_READY = 2;
    private static final int CLIENT_DISCONNECTED = 3;
    private volatile boolean mQuit = false;
    private ArrayList<Client> mClientList = new ArrayList();
    private Selector mSelector;
    private HashMap<Integer, ChunkHandler> mHandlerMap = new HashMap();
    private ServerSocketChannel mDebugSelectedChan;
    private int mNewDebugSelectedPort = DdmPreferences.getSelectedDebugPort();
    private int mDebugSelectedPort = -1;
    private Client mSelectedClient = null;
    private static MonitorThread mInstance;

    private MonitorThread() {
        super("Monitor");
    }

    static MonitorThread createInstance() {
        mInstance = new MonitorThread();
        return mInstance;
    }

    static MonitorThread getInstance() {
        return mInstance;
    }

    synchronized void setDebugSelectedPort(int port) throws IllegalStateException {
        if (mInstance == null) {
            return;
        }
        if (!AndroidDebugBridge.getClientSupport()) {
            return;
        }
        if (this.mDebugSelectedChan != null) {
            Log.d("ddms", "Changing debug-selected port to " + port);
            this.mNewDebugSelectedPort = port;
            this.wakeup();
        } else {
            this.mNewDebugSelectedPort = port;
        }
    }

    synchronized void setSelectedClient(Client selectedClient) {
        if (mInstance == null) {
            return;
        }
        if (this.mSelectedClient != selectedClient) {
            Client oldClient = this.mSelectedClient;
            this.mSelectedClient = selectedClient;
            if (oldClient != null) {
                oldClient.update(4);
            }
            if (this.mSelectedClient != null) {
                this.mSelectedClient.update(4);
            }
        }
    }

    Client getSelectedClient() {
        return this.mSelectedClient;
    }

    boolean getRetryOnBadHandshake() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Client[] getClients() {
        ArrayList<Client> arrayList = this.mClientList;
        synchronized (arrayList) {
            return this.mClientList.toArray(new Client[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void registerChunkHandler(int type, ChunkHandler handler) {
        if (mInstance == null) {
            return;
        }
        HashMap<Integer, ChunkHandler> hashMap = this.mHandlerMap;
        synchronized (hashMap) {
            if (this.mHandlerMap.get(type) == null) {
                this.mHandlerMap.put(type, handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log.d("ddms", "Monitor is up");
        try {
            this.mSelector = Selector.open();
        }
        catch (IOException ioe) {
            Log.logAndDisplay(Log.LogLevel.ERROR, "ddms", "Failed to initialize Monitor Thread: " + ioe.getMessage());
            return;
        }
        while (!this.mQuit) {
            try {
                int count;
                ArrayList<Client> ioe = this.mClientList;
                synchronized (ioe) {
                }
                try {
                    if (AndroidDebugBridge.getClientSupport() && (this.mDebugSelectedChan == null || this.mNewDebugSelectedPort != this.mDebugSelectedPort) && this.mNewDebugSelectedPort != -1 && this.reopenDebugSelectedPort()) {
                        this.mDebugSelectedPort = this.mNewDebugSelectedPort;
                    }
                }
                catch (IOException ioe2) {
                    Log.e("ddms", "Failed to reopen debug port for Selected Client to: " + this.mNewDebugSelectedPort);
                    Log.e("ddms", ioe2);
                    this.mNewDebugSelectedPort = this.mDebugSelectedPort;
                }
                try {
                    count = this.mSelector.select();
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                    continue;
                }
                catch (CancelledKeyException cke) {
                    continue;
                }
                if (count == 0) continue;
                Set<SelectionKey> keys = this.mSelector.selectedKeys();
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    try {
                        if (key.attachment() instanceof Client) {
                            this.processClientActivity(key);
                            continue;
                        }
                        if (key.attachment() instanceof Debugger) {
                            this.processDebuggerActivity(key);
                            continue;
                        }
                        if (key.attachment() instanceof MonitorThread) {
                            this.processDebugSelectedActivity(key);
                            continue;
                        }
                        Log.e("ddms", "unknown activity key");
                    }
                    catch (Exception e) {
                        Log.e("ddms", "Exception during activity from Selector.");
                        Log.e("ddms", e);
                    }
                }
            }
            catch (Exception e) {
                Log.e("ddms", "Exception MonitorThread.run()");
                Log.e("ddms", e);
            }
        }
    }

    int getDebugSelectedPort() {
        return this.mDebugSelectedPort;
    }

    private void processClientActivity(SelectionKey key) {
        Client client = (Client)key.attachment();
        try {
            if (!key.isReadable() || !key.isValid()) {
                Log.d("ddms", "Invalid key from " + client + ". Dropping client.");
                this.dropClient(client, true);
                return;
            }
            client.read();
            JdwpPacket packet = client.getJdwpPacket();
            while (packet != null) {
                if (packet.isDdmPacket()) {
                    assert (!packet.isReply());
                    this.callHandler(client, packet, null);
                    packet.consume();
                } else if (packet.isReply() && client.isResponseToUs(packet.getId()) != null) {
                    ChunkHandler handler = client.isResponseToUs(packet.getId());
                    if (packet.isError()) {
                        client.packetFailed(packet);
                    } else if (packet.isEmpty()) {
                        Log.d("ddms", "Got empty reply for 0x" + Integer.toHexString(packet.getId()) + " from " + client);
                    } else {
                        this.callHandler(client, packet, handler);
                    }
                    packet.consume();
                    client.removeRequestId(packet.getId());
                } else {
                    Log.v("ddms", "Forwarding client " + (packet.isReply() ? "reply" : "event") + " 0x" + Integer.toHexString(packet.getId()) + " to " + client.getDebugger());
                    client.forwardPacketToDebugger(packet);
                }
                packet = client.getJdwpPacket();
            }
        }
        catch (CancelledKeyException e) {
            this.dropClient(client, true);
        }
        catch (IOException ex) {
            this.dropClient(client, true);
        }
        catch (Exception ex) {
            Log.e("ddms", ex);
            this.dropClient(client, true);
            if (ex instanceof BufferOverflowException) {
                Log.w("ddms", "Client data packet exceeded maximum buffer size " + client);
            }
            Log.e("ddms", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callHandler(Client client, JdwpPacket packet, ChunkHandler handler) {
        if (!client.ddmSeen()) {
            this.broadcast(2, client);
        }
        ByteBuffer buf = packet.getPayload();
        boolean reply = true;
        int type = buf.getInt();
        int length = buf.getInt();
        if (handler == null) {
            HashMap<Integer, ChunkHandler> hashMap = this.mHandlerMap;
            synchronized (hashMap) {
                handler = this.mHandlerMap.get(type);
                reply = false;
            }
        }
        if (handler == null) {
            Log.w("ddms", "Received unsupported chunk type " + ChunkHandler.name(type) + " (len=" + length + ")");
        } else {
            Log.d("ddms", "Calling handler for " + ChunkHandler.name(type) + " [" + handler + "] (len=" + length + ")");
            ByteBuffer ibuf = buf.slice();
            ByteBuffer roBuf = ibuf.asReadOnlyBuffer();
            roBuf.order(ChunkHandler.CHUNK_ORDER);
            ArrayList<Client> arrayList = this.mClientList;
            synchronized (arrayList) {
                handler.handleChunk(client, type, roBuf, reply, packet.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void dropClient(Client client, boolean notify) {
        if (mInstance == null) {
            return;
        }
        ArrayList<Client> arrayList = this.mClientList;
        synchronized (arrayList) {
            if (!this.mClientList.remove(client)) {
                return;
            }
        }
        client.close(notify);
        this.broadcast(3, client);
        this.wakeup();
    }

    private void processDebuggerActivity(SelectionKey key) {
        Debugger dbg = (Debugger)key.attachment();
        try {
            if (key.isAcceptable()) {
                try {
                    this.acceptNewDebugger(dbg, null);
                }
                catch (IOException ioe) {
                    Log.w("ddms", "debugger accept() failed");
                    ioe.printStackTrace();
                }
            } else if (key.isReadable()) {
                this.processDebuggerData(key);
            } else {
                Log.d("ddm-debugger", "key in unknown state");
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptNewDebugger(Debugger dbg, ServerSocketChannel acceptChan) throws IOException {
        ArrayList<Client> arrayList = this.mClientList;
        synchronized (arrayList) {
            SocketChannel chan = acceptChan == null ? dbg.accept() : dbg.accept(acceptChan);
            if (chan != null) {
                chan.socket().setTcpNoDelay(true);
                this.wakeup();
                try {
                    chan.register(this.mSelector, 1, dbg);
                }
                catch (IOException ioe) {
                    dbg.closeData();
                    throw ioe;
                }
                catch (RuntimeException re) {
                    dbg.closeData();
                    throw re;
                }
            } else {
                Log.i("ddms", "ignoring duplicate debugger");
            }
        }
    }

    private void processDebuggerData(SelectionKey key) {
        Debugger dbg = (Debugger)key.attachment();
        try {
            dbg.read();
            JdwpPacket packet = dbg.getJdwpPacket();
            while (packet != null) {
                Log.v("ddms", "Forwarding dbg req 0x" + Integer.toHexString(packet.getId()) + " to " + dbg.getClient());
                dbg.forwardPacketToClient(packet);
                packet = dbg.getJdwpPacket();
            }
        }
        catch (IOException ioe) {
            Log.i("ddms", "Closing connection to debugger " + dbg);
            dbg.closeData();
            Client client = dbg.getClient();
            if (client.isDdmAware()) {
                Log.i("ddms", " (recycling client connection as well)");
                client.getDeviceImpl().getMonitor().addClientToDropAndReopen(client, -1);
            }
            Log.i("ddms", " (recycling client connection as well)");
            client.getDeviceImpl().getMonitor().addClientToDropAndReopen(client, -1);
        }
    }

    private void wakeup() {
        this.mSelector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void quit() {
        this.mQuit = true;
        this.wakeup();
        Log.d("ddms", "Waiting for Monitor thread");
        try {
            this.join();
            ArrayList<Client> arrayList = this.mClientList;
            synchronized (arrayList) {
                for (Client c : this.mClientList) {
                    c.close(false);
                    this.broadcast(3, c);
                }
                this.mClientList.clear();
            }
            if (this.mDebugSelectedChan != null) {
                this.mDebugSelectedChan.close();
                this.mDebugSelectedChan.socket().close();
                this.mDebugSelectedChan = null;
            }
            this.mSelector.close();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mInstance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addClient(Client client) {
        if (mInstance == null) {
            return;
        }
        Log.d("ddms", "Adding new client " + client);
        ArrayList<Client> arrayList = this.mClientList;
        synchronized (arrayList) {
            this.mClientList.add(client);
            try {
                this.wakeup();
                client.register(this.mSelector);
                Debugger dbg = client.getDebugger();
                if (dbg != null) {
                    dbg.registerListener(this.mSelector);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(int event, Client client) {
        HashSet<ChunkHandler> set;
        Log.d("ddms", "broadcast " + event + ": " + client);
        HashMap<Integer, ChunkHandler> hashMap = this.mHandlerMap;
        synchronized (hashMap) {
            Collection<ChunkHandler> values = this.mHandlerMap.values();
            set = new HashSet<ChunkHandler>(values);
        }
        block9: for (ChunkHandler handler : set) {
            switch (event) {
                case 2: {
                    try {
                        handler.clientReady(client);
                        continue block9;
                    }
                    catch (IOException ioe) {
                        Log.w("ddms", "Got exception while broadcasting 'ready'");
                        return;
                    }
                }
                case 3: {
                    handler.clientDisconnected(client);
                    continue block9;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    private boolean reopenDebugSelectedPort() throws IOException {
        Log.d("ddms", "reopen debug-selected port: " + this.mNewDebugSelectedPort);
        if (this.mDebugSelectedChan != null) {
            this.mDebugSelectedChan.close();
        }
        this.mDebugSelectedChan = ServerSocketChannel.open();
        this.mDebugSelectedChan.configureBlocking(false);
        InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName("localhost"), this.mNewDebugSelectedPort);
        this.mDebugSelectedChan.socket().setReuseAddress(true);
        try {
            this.mDebugSelectedChan.socket().bind(addr);
            if (this.mSelectedClient != null) {
                this.mSelectedClient.update(4);
            }
            this.mDebugSelectedChan.register(this.mSelector, 16, this);
            return true;
        }
        catch (BindException e) {
            this.displayDebugSelectedBindError(this.mNewDebugSelectedPort);
            this.mDebugSelectedChan = null;
            this.mNewDebugSelectedPort = -1;
            return false;
        }
    }

    private void processDebugSelectedActivity(SelectionKey key) {
        Debugger dbg;
        assert (key.isAcceptable());
        ServerSocketChannel acceptChan = (ServerSocketChannel)key.channel();
        if (this.mSelectedClient != null && (dbg = this.mSelectedClient.getDebugger()) != null) {
            Log.i("ddms", "Accepting connection on 'debug selected' port");
            try {
                this.acceptNewDebugger(dbg, acceptChan);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        Log.w("ddms", "Connection on 'debug selected' port, but none selected");
        try {
            SocketChannel chan = acceptChan.accept();
            chan.close();
        }
        catch (IOException ioe) {
        }
        catch (NotYetBoundException e) {
            this.displayDebugSelectedBindError(this.mDebugSelectedPort);
        }
    }

    private void displayDebugSelectedBindError(int port) {
        String message = String.format("Could not open Selected VM debug port (%1$d). Make sure you do not have another instance of DDMS or of the eclipse plugin running. If it's being used by something else, choose a new port number in the preferences.", port);
        Log.logAndDisplay(Log.LogLevel.ERROR, "ddms", message);
    }
}

