/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import java.io.IOException;
import java.nio.ByteBuffer;

final class HandleProfiling
extends ChunkHandler {
    public static final int CHUNK_MPRS = HandleProfiling.type("MPRS");
    public static final int CHUNK_MPRE = HandleProfiling.type("MPRE");
    public static final int CHUNK_MPRQ = HandleProfiling.type("MPRQ");
    private static final HandleProfiling mInst = new HandleProfiling();

    private HandleProfiling() {
    }

    public static void register(MonitorThread mt) {
        mt.registerChunkHandler(CHUNK_MPRE, mInst);
        mt.registerChunkHandler(CHUNK_MPRQ, mInst);
    }

    public void clientReady(Client client) throws IOException {
    }

    public void clientDisconnected(Client client) {
    }

    public void handleChunk(Client client, int type, ByteBuffer data, boolean isReply, int msgId) {
        Log.d("ddm-prof", "handling " + ChunkHandler.name(type));
        if (type == CHUNK_MPRE) {
            this.handleMPRE(client, data);
        } else if (type == CHUNK_MPRQ) {
            this.handleMPRQ(client, data);
        } else {
            this.handleUnknownChunk(client, type, data, isReply, msgId);
        }
    }

    public static void sendMPRS(Client client, String fileName, int bufferSize, int flags) throws IOException {
        ByteBuffer rawBuf = HandleProfiling.allocBuffer(12 + fileName.length() * 2);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleProfiling.getChunkDataBuf(rawBuf);
        buf.putInt(bufferSize);
        buf.putInt(flags);
        buf.putInt(fileName.length());
        HandleProfiling.putString(buf, fileName);
        HandleProfiling.finishChunkPacket(packet, CHUNK_MPRS, buf.position());
        Log.d("ddm-prof", "Sending " + HandleProfiling.name(CHUNK_MPRS) + " '" + fileName + "', size=" + bufferSize + ", flags=" + flags);
        client.sendAndConsume(packet, mInst);
    }

    public static void sendMPRE(Client client) throws IOException {
        ByteBuffer rawBuf = HandleProfiling.allocBuffer(0);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleProfiling.getChunkDataBuf(rawBuf);
        HandleProfiling.finishChunkPacket(packet, CHUNK_MPRE, buf.position());
        Log.d("ddm-prof", "Sending " + HandleProfiling.name(CHUNK_MPRE));
        client.sendAndConsume(packet, mInst);
    }

    private void handleMPRE(Client client, ByteBuffer data) {
        byte result = data.get();
        if (result == 0) {
            Log.i("ddm-prof", "Method profiling has finished");
        } else {
            Log.w("ddm-prof", "Method profiling has failed (check device log)");
        }
    }

    public static void sendMPRQ(Client client) throws IOException {
        ByteBuffer rawBuf = HandleProfiling.allocBuffer(0);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleProfiling.getChunkDataBuf(rawBuf);
        HandleProfiling.finishChunkPacket(packet, CHUNK_MPRQ, buf.position());
        Log.d("ddm-prof", "Sending " + HandleProfiling.name(CHUNK_MPRQ));
        client.sendAndConsume(packet, mInst);
    }

    private void handleMPRQ(Client client, ByteBuffer data) {
        byte result = data.get();
        if (result == 0) {
            Log.i("ddm-prof", "Method profiling is not running");
        } else {
            Log.i("ddm-prof", "Method profiling is running");
        }
    }
}

