/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jce.provider.IndexedPKIXParameters;

public class TrustManagerImpl
implements X509TrustManager {
    public CertPathValidator validator;
    public PKIXParameters params;
    public Exception err = null;
    public CertificateFactory factory;

    public TrustManagerImpl(KeyStore ks) {
        try {
            this.validator = CertPathValidator.getInstance("PKIX");
            this.factory = CertificateFactory.getInstance("X509");
            byte[] nameConstrains = null;
            HashSet<TrustAnchor> trusted = new HashSet<TrustAnchor>();
            Enumeration<String> en2 = ks.aliases();
            while (en2.hasMoreElements()) {
                String alias = en2.nextElement();
                X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
                if (cert == null) continue;
                trusted.add(new TrustAnchor(cert, nameConstrains));
            }
            this.params = new PKIXParameters(trusted);
            this.params.setRevocationEnabled(false);
        }
        catch (Exception e) {
            this.err = e;
        }
    }

    public void indexTrustAnchors() throws CertificateEncodingException, InvalidAlgorithmParameterException, KeyStoreException {
        this.params = new IndexedPKIXParameters(this.params.getTrustAnchors());
        this.params.setRevocationEnabled(false);
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0 || authType == null || authType.length() == 0) {
            throw new IllegalArgumentException("null or zero-length parameter");
        }
        if (this.err != null) {
            throw new CertificateException(this.err);
        }
        if (this.isDirectlyTrustedCert(chain)) {
            return;
        }
        try {
            CertPath certPath = this.factory.generateCertPath(Arrays.asList(chain));
            if (!Arrays.equals(chain[0].getEncoded(), ((X509Certificate)certPath.getCertificates().get(0)).getEncoded())) {
                throw new CertificateException("Certificate chain error");
            }
            this.validator.validate(certPath, this.params);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException(e);
        }
        catch (CertPathValidatorException e) {
            throw new CertificateException(e);
        }
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0 || authType == null || authType.length() == 0) {
            throw new IllegalArgumentException("null or zero-length parameter");
        }
        if (this.err != null) {
            throw new CertificateException(this.err);
        }
        if (this.isDirectlyTrustedCert(chain)) {
            return;
        }
        try {
            CertPath certPath = this.factory.generateCertPath(Arrays.asList(chain));
            if (!Arrays.equals(chain[0].getEncoded(), ((X509Certificate)certPath.getCertificates().get(0)).getEncoded())) {
                throw new CertificateException("Certificate chain error");
            }
            this.validator.validate(certPath, this.params);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException(e);
        }
        catch (CertPathValidatorException e) {
            throw new CertificateException(e);
        }
    }

    public boolean isDirectlyTrustedCert(X509Certificate[] chain) {
        if (chain.length == 1) {
            try {
                byte[] questionable = chain[0].getEncoded();
                Set<TrustAnchor> anchors = this.params.getTrustAnchors();
                for (TrustAnchor trustAnchor : anchors) {
                    byte[] trusted = trustAnchor.getTrustedCert().getEncoded();
                    if (!Arrays.equals(questionable, trusted)) continue;
                    return true;
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
        return false;
    }

    public X509Certificate[] getAcceptedIssuers() {
        if (this.params == null) {
            return new X509Certificate[0];
        }
        Set<TrustAnchor> anchors = this.params.getTrustAnchors();
        X509Certificate[] certs = new X509Certificate[anchors.size()];
        int i = 0;
        Iterator<TrustAnchor> it = anchors.iterator();
        while (it.hasNext()) {
            certs[i++] = it.next().getTrustedCert();
        }
        return certs;
    }
}

